/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.util.comparator;

import com.liferay.message.boards.model.MBThread;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;

public class ThreadModifiedDateComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "priority DESC, modifiedDate ASC";
    public static final String ORDER_BY_DESC = "priority DESC, modifiedDate DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"priority", "modifiedDate"};
    private final boolean _ascending;

    public ThreadModifiedDateComparator() {
        this(false);
    }

    public ThreadModifiedDateComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(T t1, T t2) {
        Date modifiedDate1 = this.getModifiedDate(t1);
        Date modifiedDate2 = this.getModifiedDate(t2);
        int value = DateUtil.compareTo((Date)modifiedDate1, (Date)modifiedDate2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    protected Date getModifiedDate(Object object) {
        if (object instanceof MBThread) {
            MBThread mbThread = (MBThread)object;
            return mbThread.getModifiedDate();
        }
        return null;
    }
}

