/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.util.comparator;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;

public class CategoryTitleComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "name ASC, modifiedDate DESC";
    public static final String ORDER_BY_DESC = "name DESC, modifiedDate DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"name", "modifiedDate"};
    private final boolean _ascending;

    public CategoryTitleComparator() {
        this(false);
    }

    public CategoryTitleComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(T t1, T t2) {
        String name1 = StringUtil.toLowerCase((String)this.getCategoryName(t1));
        String name2 = StringUtil.toLowerCase((String)this.getCategoryName(t2));
        int value = name1.compareTo(name2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    protected String getCategoryName(Object obj) {
        if (obj instanceof MBCategory) {
            MBCategory mbCategory = (MBCategory)obj;
            return mbCategory.getName();
        }
        return null;
    }
}

