/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.util.comparator;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBThread;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;

public class MBObjectsTitleComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "modelCategory ASC, priority DESC, name ASC, modifiedDate DESC, modelId ASC";
    public static final String ORDER_BY_DESC = "modelCategory ASC, priority DESC, name DESC, modifiedDate DESC, modelId ASC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"modelCategory", "priority", "name", "modifiedDate", "modelId"};
    private final boolean _ascending;

    public MBObjectsTitleComparator() {
        this(false);
    }

    public MBObjectsTitleComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(T t1, T t2) {
        String name1 = StringUtil.toLowerCase((String)this.getMBObjectsTitle(t1));
        String name2 = StringUtil.toLowerCase((String)this.getMBObjectsTitle(t2));
        int value = name1.compareTo(name2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    protected String getMBObjectsTitle(Object obj) {
        if (obj instanceof MBCategory) {
            MBCategory mbCategory = (MBCategory)obj;
            return mbCategory.getName();
        }
        if (obj instanceof MBThread) {
            MBThread mbThread = (MBThread)obj;
            return mbThread.getTitle();
        }
        return null;
    }
}

