/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.util.comparator;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBThread;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;

public class MBObjectsModifiedDateComparator<T>
extends OrderByComparator<T> {
    public static final String ORDER_BY_ASC = "modelCategory ASC, priority DESC, modifiedDate ASC, name ASC, modelId ASC";
    public static final String ORDER_BY_DESC = "modelCategory ASC, priority DESC, modifiedDate DESC, name ASC, modelId ASC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"modelCategory", "priority", "modifiedDate", "name", "modelId"};
    private final boolean _ascending;

    public MBObjectsModifiedDateComparator() {
        this(false);
    }

    public MBObjectsModifiedDateComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(T t1, T t2) {
        Date modifiedDate1 = this.getMBObjectsModifiedDate(t1);
        Date modifiedDate2 = this.getMBObjectsModifiedDate(t2);
        int value = DateUtil.compareTo((Date)modifiedDate1, (Date)modifiedDate2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    protected Date getMBObjectsModifiedDate(Object obj) {
        if (obj instanceof MBCategory) {
            MBCategory mbCategory = (MBCategory)obj;
            return mbCategory.getModifiedDate();
        }
        if (obj instanceof MBThread) {
            MBThread mbThread = (MBThread)obj;
            return mbThread.getModifiedDate();
        }
        return null;
    }
}

