/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.message.boards.kernel.service.MBThreadLocalService;
import com.liferay.message.boards.uad.constants.MBUADConstants;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseMBThreadUADAnonymizer
extends DynamicQueryUADAnonymizer<MBThread> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected MBThreadLocalService mbThreadLocalService;

    public void autoAnonymize(MBThread mbThread, long userId, User anonymousUser) throws PortalException {
        if (mbThread.getUserId() == userId) {
            mbThread.setUserId(anonymousUser.getUserId());
            mbThread.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(mbThread, anonymousUser);
        }
        if (mbThread.getRootMessageUserId() == userId) {
            mbThread.setRootMessageUserId(anonymousUser.getUserId());
        }
        if (mbThread.getLastPostByUserId() == userId) {
            mbThread.setLastPostByUserId(anonymousUser.getUserId());
        }
        if (mbThread.getStatusByUserId() == userId) {
            mbThread.setStatusByUserId(anonymousUser.getUserId());
            mbThread.setStatusByUserName(anonymousUser.getFullName());
        }
        this.mbThreadLocalService.updateMBThread(mbThread);
    }

    public void delete(MBThread mbThread) throws PortalException {
        this.mbThreadLocalService.deleteThread(mbThread);
    }

    public Class<MBThread> getTypeClass() {
        return MBThread.class;
    }

    protected void autoAnonymizeAssetEntry(MBThread mbThread, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(mbThread);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.mbThreadLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return MBUADConstants.USER_ID_FIELD_NAMES_MB_THREAD;
    }

    protected AssetEntry fetchAssetEntry(MBThread mbThread) {
        return this.assetEntryLocalService.fetchEntry(MBThread.class.getName(), mbThread.getThreadId());
    }
}

