/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.asset;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.messageboards.service.permission.MBDiscussionPermission;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MBMessageAssetRenderer
extends BaseJSPAssetRenderer<MBMessage>
implements TrashRenderer {
    private final MBMessage _message;

    public MBMessageAssetRenderer(MBMessage message) {
        this._message = message;
    }

    public MBMessage getAssetObject() {
        return this._message;
    }

    public String getClassName() {
        return MBMessage.class.getName();
    }

    public long getClassPK() {
        return this._message.getMessageId();
    }

    @Deprecated
    public Date getDisplayDate() {
        return this._message.getModifiedDate();
    }

    public long getGroupId() {
        return this._message.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/message_boards/asset/" + template + ".jsp";
        }
        return null;
    }

    public String getPortletId() {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public String getSearchSummary(Locale locale) {
        if (this._message.isFormatBBCode()) {
            return HtmlUtil.extractText((String)BBCodeTranslatorUtil.getHTML((String)this._message.getBody()));
        }
        return this.getSummary(null, null);
    }

    public int getStatus() {
        return this._message.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return this._message.getBody();
    }

    public String getTitle(Locale locale) {
        return this._message.getSubject();
    }

    public String getType() {
        return "message";
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._message.getGroupId());
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (Group)group, (String)"com_liferay_message_boards_web_portlet_MBPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/edit_message");
        portletURL.setParameter("messageId", String.valueOf(this._message.getMessageId()));
        return portletURL;
    }

    public String getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, windowState);
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(this._message.getMessageId()));
        portletURL.setWindowState(windowState);
        return portletURL.toString();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/message_boards/find_message", "messageId", this._message.getMessageId());
    }

    public long getUserId() {
        return this._message.getUserId();
    }

    public String getUserName() {
        return this._message.getUserName();
    }

    public String getUuid() {
        return this._message.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException {
        if (this._message.isDiscussion()) {
            return MBDiscussionPermission.contains((PermissionChecker)permissionChecker, (long)this._message.getMessageId(), (String)"UPDATE");
        }
        return MBMessagePermission.contains((PermissionChecker)permissionChecker, (MBMessage)this._message, (String)"UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException {
        if (this._message.isDiscussion()) {
            return MBDiscussionPermission.contains((PermissionChecker)permissionChecker, (long)this._message.getMessageId(), (String)"VIEW");
        }
        return MBMessagePermission.contains((PermissionChecker)permissionChecker, (MBMessage)this._message, (String)"VIEW");
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("MESSAGE_BOARDS_MESSAGE", (Object)this._message);
        return super.include(request, response, template);
    }

    public boolean isPrintable() {
        return true;
    }
}

