/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.message.boards.kernel.model.MBBan;
import com.liferay.message.boards.kernel.service.MBBanService;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/ban_user"}, service={MVCActionCommand.class})
public class BanUserMVCActionCommand
extends BaseMVCActionCommand {
    private MBBanService _mbBanService;

    protected void banUser(ActionRequest actionRequest) throws Exception {
        long banUserId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"banUserId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBBan.class.getName(), (PortletRequest)actionRequest);
        this._mbBanService.addBan(banUserId, serviceContext);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("ban")) {
                this.banUser(actionRequest);
            } else if (cmd.equals("unban")) {
                this.unbanUser(actionRequest);
            }
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)pe)).getClass());
            actionResponse.setRenderParameter("mvcPath", "/message_boards/error.jsp");
        }
    }

    @Reference(unbind="-")
    protected void setMBBanService(MBBanService mbBanService) {
        this._mbBanService = mbBanService;
    }

    protected void unbanUser(ActionRequest actionRequest) throws Exception {
        long[] banUserIds = null;
        long banUserId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"banUserId");
        banUserIds = banUserId > 0L ? new long[]{banUserId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBBan.class.getName(), (PortletRequest)actionRequest);
        for (long curBanUserId : banUserIds) {
            this._mbBanService.deleteBan(curBanUserId, serviceContext);
        }
    }
}

