/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.message.boards.kernel.service.MBMessageLocalService;
import com.liferay.message.boards.kernel.service.MBMessageService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.RestoreEntryUtil;
import com.liferay.trash.kernel.service.TrashEntryService;
import com.liferay.trash.kernel.util.TrashUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/edit_message_attachments"}, service={MVCActionCommand.class})
public class EditMessageAttachmentsMVCActionCommand
extends BaseMVCActionCommand {
    private MBMessageLocalService _mbMessageLocalService;
    private MBMessageService _mbMessageService;
    private TrashEntryService _trashEntryService;

    protected void deleteAttachment(ActionRequest actionRequest) throws PortalException {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        this._mbMessageLocalService.deleteMessageAttachment(messageId, fileName);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("check")) {
                JSONObject jsonObject = RestoreEntryUtil.checkEntry((PortletRequest)actionRequest);
                JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
                return;
            }
            if (cmd.equals("delete")) {
                this.deleteAttachment(actionRequest);
            } else if (cmd.equals("empty_trash")) {
                this.emptyTrash(actionRequest);
            } else if (cmd.equals("rename")) {
                this.restoreRename(actionRequest);
            } else if (cmd.equals("restore")) {
                this.restoreEntries(actionRequest);
            } else if (cmd.equals("override")) {
                this.restoreOverride(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)pe)).getClass());
            actionResponse.setRenderParameter("mvcPath", "/message_boards/error.jsp");
        }
    }

    protected void emptyTrash(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.emptyMessageAttachments(messageId);
    }

    protected void restoreEntries(ActionRequest actionRequest) throws Exception {
        long[] restoreEntryIds;
        long trashEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"trashEntryId");
        if (trashEntryId > 0L) {
            this._trashEntryService.restoreEntry(trashEntryId);
            return;
        }
        for (long restoreEntryId : restoreEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreEntryId);
        }
    }

    protected void restoreOverride(ActionRequest actionRequest) throws Exception {
        long trashEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"trashEntryId");
        long duplicateEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"duplicateEntryId");
        this._trashEntryService.restoreEntry(trashEntryId, duplicateEntryId, null);
    }

    protected void restoreRename(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long trashEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"trashEntryId");
        String newName = ParamUtil.getString((PortletRequest)actionRequest, (String)"newName");
        if (Validator.isNull((String)newName)) {
            String oldName = ParamUtil.getString((PortletRequest)actionRequest, (String)"oldName");
            newName = TrashUtil.getNewName((ThemeDisplay)themeDisplay, null, (long)0L, (String)oldName);
        }
        this._trashEntryService.restoreEntry(trashEntryId, 0L, newName);
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageService(MBMessageService mbMessageService) {
        this._mbMessageService = mbMessageService;
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }
}

