/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.message.boards.kernel.exception.LockedThreadException;
import com.liferay.message.boards.kernel.exception.MessageBodyException;
import com.liferay.message.boards.kernel.exception.MessageSubjectException;
import com.liferay.message.boards.kernel.exception.NoSuchMessageException;
import com.liferay.message.boards.kernel.exception.RequiredMessageException;
import com.liferay.message.boards.kernel.model.MBCategory;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.service.MBCategoryService;
import com.liferay.message.boards.kernel.service.MBMessageService;
import com.liferay.message.boards.kernel.service.MBThreadLocalService;
import com.liferay.message.boards.kernel.service.MBThreadService;
import com.liferay.portal.kernel.captcha.Captcha;
import com.liferay.portal.kernel.captcha.CaptchaConfigurationException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.messageboards.MBGroupServiceSettings;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/edit_message"}, service={MVCActionCommand.class})
public class EditMessageMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private Captcha _captcha;
    private MBCategoryService _mbCategoryService;
    private MBMessageService _mbMessageService;
    private MBThreadLocalService _mbThreadLocalService;
    private MBThreadService _mbThreadService;
    @Reference
    private Portal _portal;

    protected void addAnswer(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.updateAnswer(messageId, true, false);
    }

    protected void deleteAnswer(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.updateAnswer(messageId, false, false);
    }

    protected void deleteMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.deleteMessage(messageId);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        MBMessage message = null;
        try {
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                Throwable cause = uploadException.getCause();
                if (uploadException.isExceededFileSizeLimit()) {
                    throw new FileSizeException(cause);
                }
                if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                    throw new LiferayFileItemException(cause);
                }
                if (uploadException.isExceededUploadRequestSizeLimit()) {
                    throw new UploadRequestSizeException(cause);
                }
                throw new PortalException(cause);
            }
            if (cmd.equals("add") || cmd.equals("update")) {
                message = this.updateMessage(actionRequest, actionResponse);
            } else if (cmd.equals("add_answer")) {
                this.addAnswer(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteMessage(actionRequest);
            } else if (cmd.equals("delete_answer")) {
                this.deleteAnswer(actionRequest);
            } else if (cmd.equals("lock")) {
                this.lockThreads(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeMessage(actionRequest);
            } else if (cmd.equals("unlock")) {
                this.unlockThreads(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeMessage(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                WindowState windowState = actionRequest.getWindowState();
                if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    String redirect = this.getRedirect(actionRequest, actionResponse, message);
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                } else {
                    String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                    if (Validator.isNotNull((String)redirect)) {
                        actionResponse.sendRedirect(redirect);
                    }
                }
            }
        }
        catch (NoSuchMessageException | RequiredMessageException | PrincipalException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcPath", "/message_boards/error.jsp");
        }
        catch (AntivirusScannerException | DuplicateFileEntryException | FileExtensionException | FileNameException | FileSizeException | LockedThreadException | MessageBodyException | MessageSubjectException | CaptchaConfigurationException | CaptchaTextException | SanitizerException | LiferayFileItemException | UploadRequestSizeException e) {
            if (e instanceof AntivirusScannerException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
        }
        catch (AssetCategoryException | AssetTagException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof SanitizerException) {
                SessionErrors.add((PortletRequest)actionRequest, SanitizerException.class);
            }
            throw e;
        }
    }

    protected String getRedirect(ActionRequest actionRequest, ActionResponse actionResponse, MBMessage message) {
        if (message == null) {
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            return redirect;
        }
        int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)1);
        if (workflowAction == 2) {
            return this.getSaveAndContinueRedirect(actionRequest, actionResponse, message);
        }
        if (message == null) {
            return ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        }
        ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
        PortletURL portletURL = actionResponseImpl.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        return portletURL.toString();
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, ActionResponse actionResponse, MBMessage message) {
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        boolean preview = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"preview");
        PortletURL portletURL = ((ActionResponseImpl)actionResponse).createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/edit_message");
        portletURL.setParameter("redirect", redirect);
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        portletURL.setParameter("preview", String.valueOf(preview));
        return portletURL.toString();
    }

    protected void lockThreads(ActionRequest actionRequest) throws Exception {
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        if (threadId > 0L) {
            this._mbThreadService.lockThread(threadId);
        } else {
            long[] threadIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"threadIds"), (long)0L);
            for (int i = 0; i < threadIds.length; ++i) {
                this._mbThreadService.lockThread(threadIds[i]);
            }
        }
    }

    @Reference(unbind="-")
    protected void setMBCategoryService(MBCategoryService mbCategoryService) {
        this._mbCategoryService = mbCategoryService;
    }

    @Reference(unbind="-")
    protected void setMBMessageService(MBMessageService mbMessageService) {
        this._mbMessageService = mbMessageService;
    }

    @Reference(unbind="-")
    protected void setMBThreadLocalService(MBThreadLocalService mbThreadLocalService) {
        this._mbThreadLocalService = mbThreadLocalService;
    }

    @Reference(unbind="-")
    protected void setMBThreadService(MBThreadService mbThreadService) {
        this._mbThreadService = mbThreadService;
    }

    protected void subscribeMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.subscribeMessage(messageId);
    }

    protected void unlockThreads(ActionRequest actionRequest) throws Exception {
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        if (threadId > 0L) {
            this._mbThreadService.unlockThread(threadId);
        } else {
            long[] threadIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"threadIds"), (long)0L);
            for (int i = 0; i < threadIds.length; ++i) {
                this._mbThreadService.unlockThread(threadIds[i]);
            }
        }
    }

    protected void unsubscribeMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.unsubscribeMessage(messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBMessage updateMessage(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        MBMessage mBMessage;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        long groupId = themeDisplay.getScopeGroupId();
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        long parentMessageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentMessageId");
        String subject = ParamUtil.getString((PortletRequest)actionRequest, (String)"subject");
        String body = ParamUtil.getString((PortletRequest)actionRequest, (String)"body");
        MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)groupId);
        ArrayList<ObjectValuePair> inputStreamOVPs = new ArrayList<ObjectValuePair>(5);
        try {
            MBCategory category;
            String displayStyle;
            UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
            for (int i = 1; i <= 5; ++i) {
                String fileName = uploadPortletRequest.getFileName("msgFile" + i);
                InputStream inputStream = uploadPortletRequest.getFileAsStream("msgFile" + i);
                if (inputStream == null || Validator.isNull((String)fileName)) continue;
                ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
                inputStreamOVPs.add(inputStreamOVP);
            }
            boolean question = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"question");
            if (categoryId != 0L && (displayStyle = (category = this._mbCategoryService.getCategory(categoryId)).getDisplayStyle()).equals("question")) {
                question = true;
            }
            boolean anonymous = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"anonymous");
            double priority = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"priority");
            boolean allowPingbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowPingbacks");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBMessage.class.getName(), (PortletRequest)actionRequest);
            boolean preview = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"preview");
            serviceContext.setAttribute("preview", (Serializable)Boolean.valueOf(preview));
            MBMessage message = null;
            if (messageId <= 0L) {
                if (PropsValues.CAPTCHA_CHECK_PORTLET_MESSAGE_BOARDS_EDIT_MESSAGE) {
                    this._captcha.check((PortletRequest)actionRequest);
                }
                if (threadId <= 0L) {
                    message = this._mbMessageService.addMessage(groupId, categoryId, subject, body, mbGroupServiceSettings.getMessageFormat(), inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
                    if (question) {
                        this._mbThreadLocalService.updateQuestion(message.getThreadId(), true);
                    }
                } else {
                    message = this._mbMessageService.addMessage(parentMessageId, subject, body, mbGroupServiceSettings.getMessageFormat(), inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
                }
            } else {
                ArrayList<String> existingFiles = new ArrayList<String>();
                for (int i = 1; i <= 5; ++i) {
                    String path = ParamUtil.getString((PortletRequest)actionRequest, (String)("existingPath" + i));
                    if (!Validator.isNotNull((String)path)) continue;
                    existingFiles.add(path);
                }
                message = this._mbMessageService.updateMessage(messageId, subject, body, inputStreamOVPs, existingFiles, priority, allowPingbacks, serviceContext);
                if (message.isRoot()) {
                    this._mbThreadLocalService.updateQuestion(message.getThreadId(), question);
                }
            }
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            boolean subscribe = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"subscribe");
            if (!preview && subscribe && MBMessagePermission.contains((PermissionChecker)permissionChecker, (MBMessage)message, (String)"SUBSCRIBE")) {
                this._mbMessageService.subscribeMessage(message.getMessageId());
            }
            mBMessage = message;
        }
        catch (Throwable throwable) {
            for (ObjectValuePair inputStreamOVP : inputStreamOVPs) {
                InputStream inputStream = (InputStream)inputStreamOVP.getValue();
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            }
            throw throwable;
        }
        for (ObjectValuePair inputStreamOVP : inputStreamOVPs) {
            InputStream inputStream = (InputStream)inputStreamOVP.getValue();
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        }
        return mBMessage;
    }
}

