/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.message.boards.kernel.service.MBMessageService;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.RSSUtil;
import com.liferay.portal.struts.BaseRSSStrutsAction;
import com.liferay.portlet.messageboards.MBGroupServiceSettings;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/message_boards/rss"}, service={StrutsAction.class})
public class RSSAction
extends BaseRSSStrutsAction {
    private MBMessageService _mbMessageService;

    protected byte[] getRSS(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (plid == 0L) {
            plid = themeDisplay.getPlid();
        }
        long companyId = ParamUtil.getLong((HttpServletRequest)request, (String)"companyId");
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        long userId = ParamUtil.getLong((HttpServletRequest)request, (String)"userId");
        long categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId");
        long threadId = ParamUtil.getLong((HttpServletRequest)request, (String)"threadId");
        int max = ParamUtil.getInteger((HttpServletRequest)request, (String)"max", (int)SearchContainer.DEFAULT_DELTA);
        String type = ParamUtil.getString((HttpServletRequest)request, (String)"type", (String)RSSUtil.FORMAT_DEFAULT);
        double version = ParamUtil.getDouble((HttpServletRequest)request, (String)"version", (double)RSSUtil.VERSION_DEFAULT);
        String displayStyle = ParamUtil.getString((HttpServletRequest)request, (String)"displayStyle", (String)RSSUtil.DISPLAY_STYLE_DEFAULT);
        String entryURL = themeDisplay.getPortalURL() + themeDisplay.getPathMain() + "/message_boards/find_message?p_l_id=" + plid;
        String rss = "";
        if (threadId > 0L) {
            String feedURL = themeDisplay.getPortalURL() + themeDisplay.getPathMain() + "/message_boards/find_thread?p_l_id=" + plid + "&threadId=" + threadId;
            rss = this._mbMessageService.getThreadMessagesRSS(threadId, 0, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
        } else if (categoryId > 0L) {
            String feedURL = themeDisplay.getPortalURL() + themeDisplay.getPathMain() + "/message_boards/find_category?p_l_id=" + plid + "&mbCategoryId=" + categoryId;
            rss = this._mbMessageService.getCategoryMessagesRSS(groupId, categoryId, 0, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
        } else if (groupId > 0L) {
            String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)request, (String)"mvcRenderCommandName");
            String feedURL = null;
            feedURL = mvcRenderCommandName.equals("/message_boards/view_recent_posts") ? themeDisplay.getPortalURL() + themeDisplay.getPathMain() + "/message_boards/find_recent_posts?p_l_id=" + plid : themeDisplay.getPortalURL() + themeDisplay.getPathMain() + "/message_boards/find_category?p_l_id=" + plid + "&mbCategoryId=" + categoryId;
            rss = userId > 0L ? this._mbMessageService.getGroupMessagesRSS(groupId, userId, 0, max, type, version, displayStyle, feedURL, entryURL, themeDisplay) : this._mbMessageService.getGroupMessagesRSS(groupId, 0, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
        } else if (companyId > 0L) {
            String feedURL = "";
            rss = this._mbMessageService.getCompanyMessagesRSS(companyId, 0, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
        }
        return rss.getBytes("UTF-8");
    }

    protected boolean isRSSFeedsEnabled(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)themeDisplay.getSiteGroupId());
        return mbGroupServiceSettings.isEnableRSS();
    }

    @Reference(unbind="-")
    protected void setMBMessageService(MBMessageService mbMessageService) {
        this._mbMessageService = mbMessageService;
    }
}

