/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.configuration.icon;

import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.message.boards.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "path=/message_boards/view_message"}, service={PortletConfigurationIcon.class})
public class ThreadLockPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    @Reference
    private Portal _portal;

    public String getMessage(PortletRequest portletRequest) {
        try {
            MBMessage message = ActionUtil.getMessage(portletRequest);
            MBThread thread = message.getThread();
            String key = "lock";
            if (thread.isLocked()) {
                key = "unlock";
            }
            return LanguageUtil.get((ResourceBundle)this.getResourceBundle(this.getLocale(portletRequest)), (String)key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        PortletURL portletURL = this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_message_boards_web_portlet_MBAdminPortlet", "ACTION_PHASE");
        portletURL.setParameter("javax.portlet.action", "/message_boards/edit_message");
        try {
            MBMessage message = ActionUtil.getMessage(portletRequest);
            MBThread thread = message.getThread();
            if (thread.isLocked()) {
                portletURL.setParameter("cmd", "unlock");
            } else {
                portletURL.setParameter("cmd", "lock");
            }
            portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
            portletURL.setParameter("threadId", String.valueOf(thread.getThreadId()));
        }
        catch (Exception e) {
            return null;
        }
        return portletURL.toString();
    }

    public double getWeight() {
        return 103.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            MBMessage message = ActionUtil.getMessage(portletRequest);
            return MBCategoryPermission.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (long)message.getCategoryId(), (String)"LOCK_THREAD");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

