/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.util;

import com.liferay.message.boards.kernel.model.MBCategory;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.service.MBCategoryLocalServiceUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class MBBreadcrumbUtil {
    public static void addPortletBreadcrumbEntries(long categoryId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        MBCategory category = null;
        if (categoryId != 0L && categoryId != -1L) {
            category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
        }
        MBBreadcrumbUtil.addPortletBreadcrumbEntries(category, request, renderResponse);
    }

    public static void addPortletBreadcrumbEntries(MBCategory category, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)request, (String)"mvcRenderCommandName");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (mvcRenderCommandName.equals("/message_boards/select_category")) {
            portletURL.setParameter("mvcRenderCommandName", "/message_boards/select_category");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("categories"), (String)portletURL.toString());
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/message_boards/view");
        }
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString());
        if (category == null) {
            return;
        }
        if (!mvcRenderCommandName.equals("/message_boards/select_category")) {
            portletURL.setParameter("mvcRenderCommandName", "/message_boards/view_category");
        }
        List ancestorCategories = category.getAncestors();
        Collections.reverse(ancestorCategories);
        for (MBCategory curCategory : ancestorCategories) {
            portletURL.setParameter("mbCategoryId", String.valueOf(curCategory.getCategoryId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)curCategory.getName(), (String)portletURL.toString());
        }
        portletURL.setParameter("mbCategoryId", String.valueOf(category.getCategoryId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)category.getName(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(MBMessage message, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (message.getCategoryId() == -1L) {
            return;
        }
        MBCategory category = null;
        if (message.getCategoryId() != 0L) {
            category = message.getCategory();
        }
        MBBreadcrumbUtil.addPortletBreadcrumbEntries(category, request, renderResponse);
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)message.getSubject(), (String)portletURL.toString());
    }
}

