/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.social;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.message.boards.kernel.model.MBDiscussion;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.service.MBDiscussionLocalService;
import com.liferay.message.boards.kernel.service.MBMessageLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.social.BaseSocialActivityManager;
import com.liferay.portal.kernel.social.SocialActivityManager;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.kernel.model.MBMessage"}, service={SocialActivityManager.class})
public class MBMessageSocialActivityManager
extends BaseSocialActivityManager<MBMessage> {
    private ClassNameLocalService _classNameLocalService;
    private MBDiscussionLocalService _mbDiscussionLocalService;
    private MBMessageLocalService _mbMessageLocalService;
    private SocialActivityLocalService _socialActivityLocalService;

    public void deleteActivities(MBMessage message) throws PortalException {
        this.deleteDiscussionSocialActivities(BlogsEntry.class.getName(), message);
    }

    protected void deleteDiscussionSocialActivities(String className, MBMessage message) throws PortalException {
        MBDiscussion discussion = this._mbDiscussionLocalService.getThreadDiscussion(message.getThreadId());
        long classNameId = this._classNameLocalService.getClassNameId(className);
        long classPK = discussion.getClassPK();
        if (discussion.getClassNameId() != classNameId) {
            return;
        }
        List socialActivities = this._socialActivityLocalService.getActivities(0L, className, classPK, -1, -1);
        for (SocialActivity socialActivity : socialActivities) {
            if (Validator.isNull((String)socialActivity.getExtraData())) continue;
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)socialActivity.getExtraData());
            long extraDataMessageId = extraDataJSONObject.getLong("messageId");
            if (message.getMessageId() != extraDataMessageId) continue;
            this._socialActivityLocalService.deleteActivity(socialActivity.getActivityId());
        }
    }

    protected SocialActivityLocalService getSocialActivityLocalService() {
        return this._socialActivityLocalService;
    }

    @Reference(unbind="-")
    protected void setClassNameLocalService(ClassNameLocalService classNameLocalService) {
        this._classNameLocalService = classNameLocalService;
    }

    @Reference(unbind="-")
    protected void setMBDiscussionLocalService(MBDiscussionLocalService mbDiscussionLocalService) {
        this._mbDiscussionLocalService = mbDiscussionLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setSocialActivityLocalService(SocialActivityLocalService socialActivityLocalService) {
        this._socialActivityLocalService = socialActivityLocalService;
    }
}

