/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.display.context;

import com.liferay.message.boards.display.context.MBListDisplayContext;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.service.MBCategoryServiceUtil;
import com.liferay.message.boards.kernel.service.MBThreadServiceUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.SearchResultUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.messageboards.MBGroupServiceSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultMBListDisplayContext
implements MBListDisplayContext {
    private static final UUID _UUID = UUID.fromString("c29b2669-a9ce-45e3-aa4e-9ec766a4ffad");
    private final long _categoryId;
    private final HttpServletRequest _request;

    public DefaultMBListDisplayContext(HttpServletRequest request, HttpServletResponse response, long categoryId) {
        this._request = request;
        this._categoryId = categoryId;
    }

    public UUID getUuid() {
        return _UUID;
    }

    public boolean isShowMyPosts() {
        String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)this._request, (String)"mvcRenderCommandName");
        return mvcRenderCommandName.equals("/message_boards/view_my_posts");
    }

    public boolean isShowRecentPosts() {
        String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)this._request, (String)"mvcRenderCommandName");
        if (mvcRenderCommandName.equals("/message_boards/view_recent_posts")) {
            return true;
        }
        String entriesNavigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"entriesNavigation");
        return entriesNavigation.equals("recent");
    }

    public boolean isShowSearch() {
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        return Validator.isNotNull((String)keywords);
    }

    public void populateResultsAndTotal(SearchContainer searchContainer) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (this.isShowSearch()) {
            long searchCategoryId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"searchCategoryId");
            long[] categoryIdsArray = null;
            ArrayList<Long> categoryIds = new ArrayList<Long>();
            categoryIds.add(searchCategoryId);
            MBCategoryServiceUtil.getSubcategoryIds(categoryIds, (long)themeDisplay.getScopeGroupId(), (long)searchCategoryId);
            categoryIdsArray = StringUtil.split((String)StringUtil.merge(categoryIds), (long)0L);
            Indexer indexer = IndexerRegistryUtil.getIndexer(MBMessage.class);
            SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)this._request);
            searchContext.setAttribute("paginationType", (Serializable)((Object)"more"));
            searchContext.setCategoryIds(categoryIdsArray);
            searchContext.setEnd(searchContainer.getEnd());
            searchContext.setIncludeAttachments(true);
            String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
            searchContext.setKeywords(keywords);
            searchContext.setStart(searchContainer.getStart());
            Hits hits = indexer.search(searchContext);
            searchContainer.setResults(SearchResultUtil.getSearchResults((Hits)hits, (Locale)this._request.getLocale()));
            searchContainer.setSearch(true);
            searchContainer.setTotal(hits.getLength());
        } else if (this.isShowRecentPosts()) {
            searchContainer.setEmptyResultsMessage("there-are-no-recent-posts");
            long groupThreadsUserId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"groupThreadsUserId");
            Calendar calendar = Calendar.getInstance();
            MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)themeDisplay.getSiteGroupId());
            int offset = GetterUtil.getInteger((String)mbGroupServiceSettings.getRecentPostsDateOffset());
            calendar.add(5, -offset);
            boolean includeAnonymous = false;
            if (groupThreadsUserId == themeDisplay.getUserId()) {
                includeAnonymous = true;
            }
            searchContainer.setTotal(MBThreadServiceUtil.getGroupThreadsCount((long)themeDisplay.getScopeGroupId(), (long)groupThreadsUserId, (Date)calendar.getTime(), (boolean)includeAnonymous, (int)0));
            searchContainer.setResults(MBThreadServiceUtil.getGroupThreads((long)themeDisplay.getScopeGroupId(), (long)groupThreadsUserId, (Date)calendar.getTime(), (boolean)includeAnonymous, (int)0, (int)searchContainer.getStart(), (int)searchContainer.getEnd()));
        } else if (this.isShowMyPosts()) {
            searchContainer.setEmptyResultsMessage("you-do-not-have-any-posts");
            if (!themeDisplay.isSignedIn()) {
                searchContainer.setTotal(0);
                searchContainer.setResults(Collections.emptyList());
                return;
            }
            int status = -1;
            searchContainer.setTotal(MBThreadServiceUtil.getGroupThreadsCount((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (int)status));
            searchContainer.setResults(MBThreadServiceUtil.getGroupThreads((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (int)status, (int)searchContainer.getStart(), (int)searchContainer.getEnd()));
        } else {
            int status = 0;
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            if (permissionChecker.isContentReviewer(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId())) {
                status = -1;
            }
            QueryDefinition queryDefinition = new QueryDefinition(status, themeDisplay.getUserId(), true, searchContainer.getStart(), searchContainer.getEnd(), searchContainer.getOrderByComparator());
            searchContainer.setTotal(MBCategoryServiceUtil.getCategoriesAndThreadsCount((long)themeDisplay.getScopeGroupId(), (long)this._categoryId, (QueryDefinition)queryDefinition));
            searchContainer.setResults(MBCategoryServiceUtil.getCategoriesAndThreads((long)themeDisplay.getScopeGroupId(), (long)this._categoryId, (QueryDefinition)queryDefinition));
        }
    }
}

