/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.message.boards.kernel.exception.LockedThreadException;
import com.liferay.message.boards.kernel.model.MBCategory;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.message.boards.kernel.service.MBCategoryService;
import com.liferay.message.boards.kernel.service.MBThreadService;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/edit_entry"}, service={MVCActionCommand.class})
public class EditEntryMVCActionCommand
extends BaseMVCActionCommand {
    private MBCategoryService _mbCategoryService;
    private MBThreadService _mbThreadService;

    protected void deleteEntries(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] categoryIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] threadIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsMBThread");
        ArrayList<Object> trashedModels = new ArrayList<Object>();
        for (long threadId : threadIds) {
            if (moveToTrash) {
                MBThread thread = this._mbThreadService.moveThreadToTrash(threadId);
                trashedModels.add(thread);
                continue;
            }
            this._mbThreadService.deleteThread(threadId);
        }
        for (long categoryId : categoryIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsMBCategory")) {
            if (moveToTrash) {
                MBCategory category = this._mbCategoryService.moveCategoryToTrash(categoryId);
                trashedModels.add(category);
                continue;
            }
            this._mbCategoryService.deleteCategory(themeDisplay.getScopeGroupId(), categoryId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteEntries(actionRequest, false);
            } else if (cmd.equals("lock")) {
                this.lockThreads(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteEntries(actionRequest, true);
            } else if (cmd.equals("unlock")) {
                this.unlockThreads(actionRequest);
            }
        }
        catch (LockedThreadException | PrincipalException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcPath", "/message_boards/error.jsp");
        }
    }

    protected void lockThreads(ActionRequest actionRequest) throws Exception {
        long[] threadIds;
        for (long threadId : threadIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsMBThread")) {
            this._mbThreadService.lockThread(threadId);
        }
    }

    @Reference(unbind="-")
    protected void setMBCategoryService(MBCategoryService mbCategoryService) {
        this._mbCategoryService = mbCategoryService;
    }

    @Reference(unbind="-")
    protected void setMBThreadService(MBThreadService mbThreadService) {
        this._mbThreadService = mbThreadService;
    }

    protected void unlockThreads(ActionRequest actionRequest) throws Exception {
        long[] threadIds;
        for (long threadId : threadIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsMBThread")) {
            this._mbThreadService.unlockThread(threadId);
        }
    }
}

