/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.message.boards.kernel.service.MBMessageLocalService;
import com.liferay.message.boards.kernel.service.MBMessageService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/edit_message_attachments"}, service={MVCActionCommand.class})
public class EditMessageAttachmentsMVCActionCommand
extends BaseMVCActionCommand {
    private MBMessageLocalService _mbMessageLocalService;
    private MBMessageService _mbMessageService;

    protected void deleteAttachment(ActionRequest actionRequest) throws PortalException {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        this._mbMessageLocalService.deleteMessageAttachment(messageId, fileName);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteAttachment(actionRequest);
            } else if (cmd.equals("empty_trash")) {
                this.emptyTrash(actionRequest);
            } else if (cmd.equals("restore")) {
                this.restoreEntries(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)pe)).getClass());
            actionResponse.setRenderParameter("mvcPath", "/message_boards/error.jsp");
        }
    }

    protected void emptyTrash(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.emptyMessageAttachments(messageId);
    }

    protected void restoreEntries(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        this._mbMessageLocalService.restoreMessageAttachmentFromTrash(themeDisplay.getUserId(), messageId, fileName);
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageService(MBMessageService mbMessageService) {
        this._mbMessageService = mbMessageService;
    }
}

