/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.BaseJSPSettingsConfigurationAction;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet"}, service={ConfigurationAction.class})
public class MBAdminConfigurationAction
extends BaseJSPSettingsConfigurationAction {
    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.validateEmail(actionRequest, "emailMessageAdded");
        this.validateEmail(actionRequest, "emailMessageUpdated");
        this.validateEmailFrom(actionRequest);
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    protected boolean isValidUserRank(String rank) {
        return StringUtil.count((String)rank, (char)'=') == 1 && !rank.startsWith("=") && !rank.endsWith("=");
    }

    protected void updateMultiValuedKeys(ActionRequest actionRequest) {
        super.updateMultiValuedKeys(actionRequest);
        this.updateThreadPriorities(actionRequest);
        this.updateUserRanks(actionRequest);
    }

    protected void updateThreadPriorities(ActionRequest actionRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        for (Locale locale : LanguageUtil.getAvailableLocales((long)themeDisplay.getSiteGroupId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            ArrayList<String> priorities = new ArrayList<String>();
            for (int j = 0; j < 10; ++j) {
                String name = ParamUtil.getString((PortletRequest)actionRequest, (String)StringBundler.concat((String[])new String[]{"priorityName", String.valueOf(j), "_", languageId}));
                String image = ParamUtil.getString((PortletRequest)actionRequest, (String)StringBundler.concat((String[])new String[]{"priorityImage", String.valueOf(j), "_", languageId}));
                double value = ParamUtil.getDouble((PortletRequest)actionRequest, (String)StringBundler.concat((String[])new String[]{"priorityValue", String.valueOf(j), "_", languageId}));
                if (!Validator.isNotNull((String)name) && !Validator.isNotNull((String)image) && value == 0.0) continue;
                priorities.add(StringBundler.concat((String[])new String[]{name, "|", image, "|", String.valueOf(value)}));
            }
            String preferenceName = LocalizationUtil.getLocalizedName((String)"priorities", (String)languageId);
            this.setPreference((PortletRequest)actionRequest, preferenceName, priorities.toArray(new String[priorities.size()]));
        }
    }

    protected void updateUserRanks(ActionRequest actionRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        for (Locale locale : LanguageUtil.getAvailableLocales((long)themeDisplay.getSiteGroupId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            String[] ranks = StringUtil.splitLines((String)ParamUtil.getString((PortletRequest)actionRequest, (String)("ranks_" + languageId)));
            TreeMap<String, String> map = new TreeMap<String, String>((Comparator<String>)new NaturalOrderStringComparator());
            for (String rank : ranks) {
                if (!this.isValidUserRank(rank)) {
                    SessionErrors.add((PortletRequest)actionRequest, (String)"userRank");
                    return;
                }
                String[] kvp = StringUtil.split((String)rank, (char)'=');
                String kvpName = kvp[0];
                String kvpValue = kvp[1];
                map.put(kvpValue, kvpName);
            }
            ranks = new String[map.size()];
            int count = 0;
            for (Map.Entry entry : map.entrySet()) {
                String kvpValue = (String)entry.getKey();
                String kvpName = (String)entry.getValue();
                ranks[count++] = kvpName + "=" + kvpValue;
            }
            String preferenceName = LocalizationUtil.getLocalizedName((String)"ranks", (String)languageId);
            this.setPreference((PortletRequest)actionRequest, preferenceName, ranks);
        }
    }
}

