/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.message.boards.kernel.service.MBCategoryService;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/move_category"}, service={MVCActionCommand.class})
public class MoveCategoryMVCActionCommand
extends BaseMVCActionCommand {
    private MBCategoryService _mbCategoryService;
    @Reference
    private Portal _portal;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.moveCategory(actionRequest, actionResponse);
            String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (Validator.isNotNull((String)redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)pe)).getClass());
        }
    }

    protected void moveCategory(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        long parentCategoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentCategoryId");
        boolean mergeWithParentCategory = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeWithParentCategory");
        this._mbCategoryService.moveCategory(categoryId, parentCategoryId, mergeWithParentCategory);
    }

    @Reference(unbind="-")
    protected void setMBCategoryService(MBCategoryService mbCategoryService) {
        this._mbCategoryService = mbCategoryService;
    }
}

