/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.message.boards.kernel.exception.MessageBodyException;
import com.liferay.message.boards.kernel.exception.MessageSubjectException;
import com.liferay.message.boards.kernel.exception.NoSuchThreadException;
import com.liferay.message.boards.kernel.exception.RequiredMessageException;
import com.liferay.message.boards.kernel.exception.SplitThreadException;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.message.boards.kernel.service.MBMessageLocalService;
import com.liferay.message.boards.kernel.service.MBMessageService;
import com.liferay.message.boards.kernel.service.MBThreadService;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.messageboards.MBGroupServiceSettings;
import java.util.Collections;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/split_thread"}, service={MVCActionCommand.class})
public class SplitThreadMVCActionCommand
extends BaseMVCActionCommand {
    private MBMessageLocalService _mbMessageLocalService;
    private MBMessageService _mbMessageService;
    private MBThreadService _mbThreadService;
    @Reference
    private Portal _portal;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.splitThread(actionRequest, actionResponse);
        }
        catch (RequiredMessageException | PrincipalException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcPath", "/message_boards/error.jsp");
        }
        catch (MessageBodyException | MessageSubjectException | NoSuchThreadException | SplitThreadException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
        }
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageService(MBMessageService mbMessageService) {
        this._mbMessageService = mbMessageService;
    }

    @Reference(unbind="-")
    protected void setMBThreadService(MBThreadService mbThreadService) {
        this._mbThreadService = mbThreadService;
    }

    protected void splitThread(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        String splitThreadSubject = ParamUtil.getString((PortletRequest)actionRequest, (String)"splitThreadSubject");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBThread.class.getName(), (PortletRequest)actionRequest);
        MBMessage message = this._mbMessageLocalService.getMessage(messageId);
        long oldParentMessageId = message.getParentMessageId();
        MBThread newThread = this._mbThreadService.splitThread(messageId, splitThreadSubject, serviceContext);
        boolean addExplanationPost = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"addExplanationPost");
        if (addExplanationPost) {
            String subject = ParamUtil.getString((PortletRequest)actionRequest, (String)"subject");
            String body = ParamUtil.getString((PortletRequest)actionRequest, (String)"body");
            MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)themeDisplay.getScopeGroupId());
            String layoutFullURL = this._portal.getLayoutFullURL(themeDisplay);
            String newThreadURL = layoutFullURL + "/-/message_boards/view_message/" + message.getMessageId();
            body = StringUtil.replace((String)body, (String)"${newThreadURL}", (String)newThreadURL);
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            this._mbMessageService.addMessage(oldParentMessageId, subject, body, mbGroupServiceSettings.getMessageFormat(), Collections.emptyList(), false, -1.0, message.isAllowPingbacks(), serviceContext);
        }
        PortletURL portletURL = ((ActionResponseImpl)actionResponse).createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(newThread.getRootMessageId()));
        actionResponse.sendRedirect(portletURL.toString());
    }
}

