/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.configuration.icon;

import com.liferay.message.boards.kernel.model.MBCategory;
import com.liferay.message.boards.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.SubscriptionLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portlet.messageboards.MBGroupServiceSettings;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "path=/message_boards/view_category"}, service={PortletConfigurationIcon.class})
public class CategorySubscriptionPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    @Reference
    private Portal _portal;
    private SubscriptionLocalService _subscriptionLocalService;

    public String getMessage(PortletRequest portletRequest) {
        String key = "subscribe";
        try {
            MBCategory category = ActionUtil.getCategory(portletRequest);
            if (this._isSubscribed(portletRequest, category)) {
                key = "unsubscribe";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(this.getLocale(portletRequest)), (String)key);
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        PortletURL portletURL = this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_message_boards_web_portlet_MBAdminPortlet", "ACTION_PHASE");
        portletURL.setParameter("javax.portlet.action", "/message_boards/edit_category");
        MBCategory category = null;
        try {
            category = ActionUtil.getCategory(portletRequest);
        }
        catch (Exception e) {
            return null;
        }
        if (this._isSubscribed(portletRequest, category)) {
            portletURL.setParameter("cmd", "unsubscribe");
        } else {
            portletURL.setParameter("cmd", "subscribe");
        }
        portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
        portletURL.setParameter("mbCategoryId", String.valueOf(category.getCategoryId()));
        return portletURL.toString();
    }

    public double getWeight() {
        return 101.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)themeDisplay.getScopeGroupId());
            if (!mbGroupServiceSettings.isEmailMessageAddedEnabled() && !mbGroupServiceSettings.isEmailMessageUpdatedEnabled()) {
                return false;
            }
            MBCategory category = ActionUtil.getCategory(portletRequest);
            return MBCategoryPermission.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (MBCategory)category, (String)"SUBSCRIBE");
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Reference(unbind="-")
    protected void setSubscriptionLocalService(SubscriptionLocalService subscriptionLocalService) {
        this._subscriptionLocalService = subscriptionLocalService;
    }

    private boolean _isSubscribed(PortletRequest portletRequest, MBCategory category) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._subscriptionLocalService.isSubscribed(themeDisplay.getCompanyId(), themeDisplay.getUserId(), MBCategory.class.getName(), category.getCategoryId());
    }
}

