/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.social;

import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.message.boards.kernel.service.MBMessageLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.social.BaseSocialActivityManager;
import com.liferay.portal.kernel.social.SocialActivityManager;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.kernel.model.MBThread"}, service={SocialActivityManager.class})
public class MBThreadSocialActivityManager
extends BaseSocialActivityManager<MBThread> {
    protected MBMessageLocalService mbMessageLocalService;
    protected SocialActivityLocalService socialActivityLocalService;

    public void addActivity(long userId, MBThread thread, int type, String extraData, long receiverUserId) throws PortalException {
        if (type == 10002) {
            this.addSubscribeSocialActivity(userId, thread.getGroupId(), thread, extraData);
        } else if (type == 10001) {
            this.addViewSocialActivity(userId, thread, type, extraData, receiverUserId);
        } else {
            super.addActivity(userId, (ClassedModel)thread, type, extraData, receiverUserId);
        }
    }

    protected void addSubscribeSocialActivity(long userId, long groupId, MBThread thread, String extraData) throws PortalException {
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)extraData);
        extraDataJSONObject.put("threadId", thread.getThreadId());
        this.socialActivityLocalService.addActivity(userId, groupId, MBMessage.class.getName(), thread.getRootMessageId(), 10002, extraDataJSONObject.toString(), 0L);
    }

    protected void addViewSocialActivity(long userId, MBThread thread, int type, String extraData, long receiverUserId) throws PortalException {
        if (thread.getRootMessageUserId() == userId) {
            return;
        }
        MBMessage rootMessage = this.mbMessageLocalService.getMessage(thread.getRootMessageId());
        this.socialActivityLocalService.addActivity(userId, rootMessage.getGroupId(), MBMessage.class.getName(), rootMessage.getMessageId(), type, extraData, receiverUserId);
    }

    protected SocialActivityLocalService getSocialActivityLocalService() {
        return this.socialActivityLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this.mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setSocialActivityLocalService(SocialActivityLocalService socialActivityLocalService) {
        this.socialActivityLocalService = socialActivityLocalService;
    }
}

