/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.asset;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MBCategoryAssetRenderer
extends BaseJSPAssetRenderer<MBCategory> {
    private final MBCategory _category;
    private final ModelResourcePermission<MBCategory> _categoryModelResourcePermission;

    public MBCategoryAssetRenderer(MBCategory category, ModelResourcePermission<MBCategory> categoryModelResourcePermission) {
        this._category = category;
        this._categoryModelResourcePermission = categoryModelResourcePermission;
    }

    public MBCategory getAssetObject() {
        return this._category;
    }

    public String getClassName() {
        return MBCategory.class.getName();
    }

    public long getClassPK() {
        return this._category.getCategoryId();
    }

    public long getGroupId() {
        return this._category.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/message_boards/asset/" + template + ".jsp";
        }
        return null;
    }

    public int getStatus() {
        return this._category.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return this._category.getDescription();
    }

    public String getTitle(Locale locale) {
        return this._category.getName();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._category.getGroupId());
        if (group.isCompany()) {
            ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = themeDisplay.getScopeGroup();
        }
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (Group)group, (String)"com_liferay_message_boards_web_portlet_MBPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/edit_category");
        portletURL.setParameter("mbCategoryId", String.valueOf(this._category.getCategoryId()));
        return portletURL;
    }

    public String getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, windowState);
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/view_category");
        portletURL.setParameter("mbCategoryId", String.valueOf(this._category.getCategoryId()));
        portletURL.setWindowState(windowState);
        return portletURL.toString();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/message_boards/find_category", "mbCategoryId", this._category.getCategoryId());
    }

    public long getUserId() {
        return this._category.getUserId();
    }

    public String getUserName() {
        return this._category.getUserName();
    }

    public String getUuid() {
        return this._category.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException {
        return this._categoryModelResourcePermission.contains(permissionChecker, (ClassedModel)this._category, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException {
        return this._categoryModelResourcePermission.contains(permissionChecker, (ClassedModel)this._category, "VIEW");
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("MESSAGE_BOARDS_CATEGORY", (Object)this._category);
        return super.include(request, response, template);
    }
}

