/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.util.comparator.CategoryModifiedDateComparator;
import com.liferay.message.boards.util.comparator.CategoryTitleComparator;
import com.liferay.message.boards.util.comparator.MBObjectsModifiedDateComparator;
import com.liferay.message.boards.util.comparator.MBObjectsTitleComparator;
import com.liferay.message.boards.util.comparator.ThreadModifiedDateComparator;
import com.liferay.message.boards.util.comparator.ThreadTitleComparator;
import com.liferay.message.boards.web.internal.security.permission.MBCategoryPermission;
import com.liferay.message.boards.web.internal.util.MBUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class MBEntriesManagementToolbarDisplayContext {
    private final PortletURL _currentURLObj;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _orderByCol;
    private String _orderByType;
    private final PortalPreferences _portalPreferences;
    private final HttpServletRequest _request;
    private final TrashHelper _trashHelper;

    public MBEntriesManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest request, PortletURL currentURLObj, TrashHelper trashHelper) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._request = request;
        this._currentURLObj = currentURLObj;
        this._trashHelper = trashHelper;
        this._portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)liferayPortletRequest);
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                ThemeDisplay themeDisplay = (ThemeDisplay)MBEntriesManagementToolbarDisplayContext.this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.putData("action", "deleteEntries");
                    boolean trashEnabled = MBEntriesManagementToolbarDisplayContext.this._trashHelper.isTrashEnabled(themeDisplay.getScopeGroupId());
                    dropdownItem.setIcon(trashEnabled ? "trash" : "times");
                    String label = "delete";
                    if (trashEnabled) {
                        label = "move-to-recycle-bin";
                    }
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)MBEntriesManagementToolbarDisplayContext.this._request, (String)label));
                    dropdownItem.setQuickAction(true);
                }));
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.putData("action", "lockEntries");
                    dropdownItem.setIcon("lock");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)MBEntriesManagementToolbarDisplayContext.this._request, (String)"lock"));
                    dropdownItem.setQuickAction(true);
                }));
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.putData("action", "unlockEntries");
                    dropdownItem.setIcon("unlock");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)MBEntriesManagementToolbarDisplayContext.this._request, (String)"unlock"));
                    dropdownItem.setQuickAction(true);
                }));
            }
        };
    }

    public CreationMenu getCreationMenu() throws PortalException {
        CreationMenu creationMenu = null;
        MBCategory category = (MBCategory)this._request.getAttribute("MESSAGE_BOARDS_CATEGORY");
        long categoryId = MBUtil.getCategoryId(this._request, category);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (MBCategoryPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), categoryId, "ADD_CATEGORY")) {
            if (creationMenu == null) {
                creationMenu = new CreationMenu();
            }
            creationMenu.addDropdownItem(dropdownItem -> {
                dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/message_boards/edit_category", "redirect", this._currentURLObj.toString(), "parentCategoryId", String.valueOf(categoryId)});
                String label = "category[message-board]";
                if (categoryId != 0L) {
                    label = "subcategory[message-board]";
                }
                dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._request, (String)label));
            });
        }
        if (MBCategoryPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), categoryId, "ADD_MESSAGE")) {
            if (creationMenu == null) {
                creationMenu = new CreationMenu();
            }
            creationMenu.addDropdownItem(dropdownItem -> {
                dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcRenderCommandName", "/message_boards/edit_message", "redirect", this._currentURLObj.toString(), "mbCategoryId", String.valueOf(categoryId)});
                dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._request, (String)"thread"));
            });
        }
        return creationMenu;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(SafeConsumer.ignore(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(MBEntriesManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)MBEntriesManagementToolbarDisplayContext.this._request, (String)"filter-by-navigation"));
                }));
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(MBEntriesManagementToolbarDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)MBEntriesManagementToolbarDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        String orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol");
        if (Validator.isNotNull((String)orderByCol)) {
            this._portalPreferences.setValue("com_liferay_message_boards_web_portlet_MBAdminPortlet", "order-by-col", orderByCol);
        } else {
            orderByCol = this._portalPreferences.getValue("com_liferay_message_boards_web_portlet_MBAdminPortlet", "order-by-col", "modified-date");
        }
        this._orderByCol = orderByCol;
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        String orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType");
        if (Validator.isNotNull((String)orderByType)) {
            this._portalPreferences.setValue("com_liferay_message_boards_web_portlet_MBAdminPortlet", "order-by-type", orderByType);
        } else {
            orderByType = this._portalPreferences.getValue("com_liferay_message_boards_web_portlet_MBAdminPortlet", "order-by-type", "desc");
        }
        this._orderByType = orderByType;
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        MBCategory category = (MBCategory)this._request.getAttribute("MESSAGE_BOARDS_CATEGORY");
        long categoryId = MBUtil.getCategoryId(this._request, category);
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        if (categoryId == 0L) {
            portletURL.setParameter("mvcRenderCommandName", "/message_boards/view");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/message_boards/view_category");
            portletURL.setParameter("mbCategoryId", String.valueOf(categoryId));
        }
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        if (Validator.isNotNull((String)keywords)) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public String getSearchActionURL() {
        PortletURL searchURL = this._liferayPortletResponse.createRenderURL();
        searchURL.setParameter("mvcRenderCommandName", "/message_boards_admin/search");
        searchURL.setParameter("redirect", this._currentURLObj.toString());
        MBCategory category = (MBCategory)this._request.getAttribute("MESSAGE_BOARDS_CATEGORY");
        long categoryId = MBUtil.getCategoryId(this._request, category);
        searchURL.setParameter("breadcrumbsCategoryId", String.valueOf(categoryId));
        searchURL.setParameter("searchCategoryId", String.valueOf(categoryId));
        return searchURL.toString();
    }

    public PortletURL getSortingURL() throws PortletException {
        PortletURL sortingURL = this._getCurrentSortingURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL;
    }

    public void populateOrder(SearchContainer searchContainer) {
        String entriesNavigation;
        MBObjectsModifiedDateComparator orderByComparator = null;
        String orderByCol = this.getOrderByCol();
        boolean orderByAsc = false;
        String orderByType = this.getOrderByType();
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        if ((entriesNavigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"entriesNavigation", (String)"all")).equals("all")) {
            if (orderByCol.equals("modified-date")) {
                orderByComparator = new MBObjectsModifiedDateComparator(orderByAsc);
            } else if (orderByCol.equals("title")) {
                orderByComparator = new MBObjectsTitleComparator(orderByAsc);
            }
        } else if (entriesNavigation.equals("threads")) {
            if (orderByCol.equals("modified-date")) {
                orderByComparator = new ThreadModifiedDateComparator(orderByAsc);
            } else if (orderByCol.equals("title")) {
                orderByComparator = new ThreadTitleComparator(orderByAsc);
            }
        } else if (entriesNavigation.equals("categories")) {
            if (orderByCol.equals("modified-date")) {
                orderByComparator = new CategoryModifiedDateComparator(orderByAsc);
            } else if (orderByCol.equals("title")) {
                orderByComparator = new CategoryTitleComparator(orderByAsc);
            }
        }
        searchContainer.setOrderByCol(orderByCol);
        searchContainer.setOrderByComparator((OrderByComparator)orderByComparator);
        searchContainer.setOrderByType(orderByType);
    }

    private PortletURL _getCurrentSortingURL() throws PortletException {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this._currentURLObj, (LiferayPortletResponse)this._liferayPortletResponse);
        MBCategory category = (MBCategory)this._request.getAttribute("MESSAGE_BOARDS_CATEGORY");
        long categoryId = MBUtil.getCategoryId(this._request, category);
        if (categoryId == 0L) {
            sortingURL.setParameter("mvcRenderCommandName", "/message_boards/view");
        } else {
            sortingURL.setParameter("mvcRenderCommandName", "/message_boards/view_category");
            sortingURL.setParameter("mbCategoryId", String.valueOf(categoryId));
        }
        sortingURL.setParameter("cur", "0");
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        if (Validator.isNotNull((String)keywords)) {
            sortingURL.setParameter("keywords", keywords);
        }
        return sortingURL;
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        final String entriesNavigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"entriesNavigation", (String)"all");
        return new DropdownItemList(){
            {
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive(entriesNavigation.equals("all"));
                    PortletURL navigationPortletURL = PortletURLUtil.clone((PortletURL)MBEntriesManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)MBEntriesManagementToolbarDisplayContext.this._liferayPortletResponse);
                    dropdownItem.setHref(navigationPortletURL, new Object[]{"entriesNavigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)MBEntriesManagementToolbarDisplayContext.this._request, (String)"all"));
                }));
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive(entriesNavigation.equals("threads"));
                    PortletURL navigationPortletURL = PortletURLUtil.clone((PortletURL)MBEntriesManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)MBEntriesManagementToolbarDisplayContext.this._liferayPortletResponse);
                    dropdownItem.setHref(navigationPortletURL, new Object[]{"entriesNavigation", "threads"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)MBEntriesManagementToolbarDisplayContext.this._request, (String)"threads"));
                }));
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive(entriesNavigation.equals("categories"));
                    PortletURL navigationPortletURL = PortletURLUtil.clone((PortletURL)MBEntriesManagementToolbarDisplayContext.this._currentURLObj, (LiferayPortletResponse)MBEntriesManagementToolbarDisplayContext.this._liferayPortletResponse);
                    dropdownItem.setHref(navigationPortletURL, new Object[]{"entriesNavigation", "categories"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)MBEntriesManagementToolbarDisplayContext.this._request, (String)"categories"));
                }));
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive("title".equals(MBEntriesManagementToolbarDisplayContext.this.getOrderByCol()));
                    dropdownItem.setHref(MBEntriesManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", "title"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)MBEntriesManagementToolbarDisplayContext.this._request, (String)"title"));
                }));
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.setActive("modified-date".equals(MBEntriesManagementToolbarDisplayContext.this.getOrderByCol()));
                    dropdownItem.setHref(MBEntriesManagementToolbarDisplayContext.this._getCurrentSortingURL(), new Object[]{"orderByCol", "modified-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)MBEntriesManagementToolbarDisplayContext.this._request, (String)"modified-date"));
                }));
            }
        };
    }
}

