/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryRegistryUtil;
import com.liferay.message.boards.model.MBBan;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThreadFlag;
import com.liferay.message.boards.service.MBBanLocalService;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.service.MBThreadFlagLocalService;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class MBExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private MBBanLocalService _mbBanLocalService;
    private MBCategoryLocalService _mbCategoryLocalService;
    @Reference(target="(javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet)")
    private PortletDataHandler _mbPortletDataHandler;
    private MBThreadFlagLocalService _mbThreadFlagLocalService;

    public List<Capability> getExportCapabilities() {
        return null;
    }

    public List<Capability> getImportCapabilities() {
        return null;
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            portletDataContext.addPortletPermissions("com.liferay.message.boards");
        }
        catch (PortalException pe) {
            PortletDataException pde = new PortletDataException((Throwable)pe);
            pde.setPortletId("com_liferay_message_boards_web_portlet_MBPortlet");
            pde.setType(18);
            throw pde;
        }
        try {
            String namespace = this._mbPortletDataHandler.getNamespace();
            String portletId = portletDataContext.getPortletId();
            if (portletDataContext.getBooleanParameter(namespace, "categories") || portletDataContext.getBooleanParameter(namespace, "messages")) {
                ExportActionableDynamicQuery categoryActionableDynamicQuery = this._mbCategoryLocalService.getExportActionableDynamicQuery(portletDataContext);
                categoryActionableDynamicQuery.setPerformActionMethod(mbCategory -> StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)mbCategory));
                categoryActionableDynamicQuery.performActions();
            }
            if (portletDataContext.getBooleanParameter(namespace, "messages")) {
                StagedModelRepository mbMessageStagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)MBMessage.class.getName());
                ExportActionableDynamicQuery messageActionableDynamicQuery = mbMessageStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
                messageActionableDynamicQuery.setPerformActionMethod(mbMessage -> StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)mbMessage));
                messageActionableDynamicQuery.performActions();
            }
            if (portletDataContext.getBooleanParameter(namespace, "thread-flags")) {
                ExportActionableDynamicQuery threadFlagActionableDynamicQuery = this._mbThreadFlagLocalService.getExportActionableDynamicQuery(portletDataContext);
                threadFlagActionableDynamicQuery.setPerformActionMethod(mbThreadFlag -> StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)mbThreadFlag));
                threadFlagActionableDynamicQuery.performActions();
            }
            if (portletDataContext.getBooleanParameter(namespace, "user-bans")) {
                ExportActionableDynamicQuery banActionableDynamicQuery = this._mbBanLocalService.getExportActionableDynamicQuery(portletDataContext);
                banActionableDynamicQuery.setPerformActionMethod(mbBan -> StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)mbBan));
                banActionableDynamicQuery.performActions();
            }
        }
        catch (PortalException pe) {
            PortletDataException pde = new PortletDataException((Throwable)pe);
            pde.setPortletId("com_liferay_message_boards_web_portlet_MBPortlet");
            pde.setType(11);
            throw pde;
        }
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            portletDataContext.importPortletPermissions("com.liferay.message.boards");
        }
        catch (PortalException pe) {
            PortletDataException pde = new PortletDataException((Throwable)pe);
            pde.setPortletId("com_liferay_message_boards_web_portlet_MBPortlet");
            pde.setType(20);
            throw pde;
        }
        String namespace = this._mbPortletDataHandler.getNamespace();
        if (portletDataContext.getBooleanParameter(namespace, "categories") || portletDataContext.getBooleanParameter(namespace, "messages")) {
            Element categoriesElement = portletDataContext.getImportDataGroupElement(MBCategory.class);
            List categoryElements = categoriesElement.elements();
            for (Element categoryElement : categoryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)categoryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(namespace, "messages")) {
            Element messagesElement = portletDataContext.getImportDataGroupElement(MBMessage.class);
            List messageElements = messagesElement.elements();
            for (Element messageElement : messageElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)messageElement);
            }
        }
        if (portletDataContext.getBooleanParameter(namespace, "thread-flags")) {
            Element threadFlagsElement = portletDataContext.getImportDataGroupElement(MBThreadFlag.class);
            List threadFlagElements = threadFlagsElement.elements();
            for (Element threadFlagElement : threadFlagElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)threadFlagElement);
            }
        }
        if (portletDataContext.getBooleanParameter(namespace, "user-bans")) {
            Element userBansElement = portletDataContext.getImportDataGroupElement(MBBan.class);
            List userBanElements = userBansElement.elements();
            for (Element userBanElement : userBanElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)userBanElement);
            }
        }
        return portletPreferences;
    }

    @Reference(unbind="-")
    protected void setMBBanLocalService(MBBanLocalService mbBanLocalService) {
        this._mbBanLocalService = mbBanLocalService;
    }

    @Reference(unbind="-")
    protected void setMBCategoryLocalService(MBCategoryLocalService mbCategoryLocalService) {
        this._mbCategoryLocalService = mbCategoryLocalService;
    }

    @Reference(unbind="-")
    protected void setMBThreadFlagLocalService(MBThreadFlagLocalService mbThreadFlagLocalService) {
        this._mbThreadFlagLocalService = mbThreadFlagLocalService;
    }
}

