/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.message.boards.exception.NoSuchCategoryException;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/edit_category"}, service={MVCRenderCommand.class})
public class EditCategoryMVCRenderCommand
implements MVCRenderCommand {
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBCategory)")
    private volatile ModelResourcePermission<MBCategory> _mbCategoryModelResourcePermission;

    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            MBCategory category = ActionUtil.getCategory((PortletRequest)renderRequest);
            if (category != null) {
                ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                this._mbCategoryModelResourcePermission.check(themeDisplay.getPermissionChecker(), (ClassedModel)category, "UPDATE");
            }
            renderRequest.setAttribute("MESSAGE_BOARDS_CATEGORY", (Object)category);
        }
        catch (NoSuchCategoryException | PrincipalException e) {
            SessionErrors.add((PortletRequest)renderRequest, e.getClass());
            return "/message_boards/error.jsp";
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return "/message_boards/edit_category.jsp";
    }
}

