/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.message.boards.service.MBMessageService;
import com.liferay.message.boards.web.internal.upload.TempAttachmentMBUploadFileEntryHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.upload.UploadFileEntryHandler;
import com.liferay.upload.UploadHandler;
import com.liferay.upload.UploadResponseHandler;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/edit_message_attachments"}, service={MVCActionCommand.class})
public class EditMessageAttachmentsMVCActionCommand
extends BaseMVCActionCommand {
    private MBMessageService _mbMessageService;
    @Reference(target="(upload.response.handler=multiple)")
    private UploadResponseHandler _multipleUploadResponseHandler;
    @Reference
    private Portal _portal;
    @Reference
    private TempAttachmentMBUploadFileEntryHandler _tempAttachmentMBUploadFileEntryHandler;
    @Reference
    private UploadHandler _uploadHandler;

    protected void addTempAttachment(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this._uploadHandler.upload((UploadFileEntryHandler)this._tempAttachmentMBUploadFileEntryHandler, this._multipleUploadResponseHandler, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
    }

    protected void deleteAttachment(ActionRequest actionRequest, boolean moveToTrash) throws PortalException {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        if (moveToTrash) {
            this._mbMessageService.moveMessageAttachmentToTrash(messageId, fileName);
        } else {
            this._mbMessageService.deleteMessageAttachment(messageId, fileName);
        }
    }

    protected void deleteTempAttachment(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long categoryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"categoryId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            this._mbMessageService.deleteTempAttachment(themeDisplay.getScopeGroupId(), categoryId, "com.liferay.message.boards", fileName);
            jsonObject.put("deleted", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            jsonObject.put("deleted", (Object)Boolean.FALSE);
            String errorMessage = themeDisplay.translate("an-unexpected-error-occurred-while-deleting-the-file");
            jsonObject.put("errorMessage", errorMessage);
        }
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add_temp")) {
                this.addTempAttachment(actionRequest, actionResponse);
            } else if (cmd.equals("delete")) {
                this.deleteAttachment(actionRequest, false);
            } else if (cmd.equals("delete_temp")) {
                this.deleteTempAttachment(actionRequest, actionResponse);
            } else if (cmd.equals("empty_trash")) {
                this.emptyTrash(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteAttachment(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreEntries(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (PrincipalException pe) {
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)pe)).getClass());
            actionResponse.setRenderParameter("mvcPath", "/message_boards/error.jsp");
        }
    }

    protected void emptyTrash(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.emptyMessageAttachments(messageId);
    }

    protected void restoreEntries(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        this._mbMessageService.restoreMessageAttachmentFromTrash(messageId, fileName);
    }

    @Reference(unbind="-")
    protected void setMBMessageService(MBMessageService mbMessageService) {
        this._mbMessageService = mbMessageService;
    }
}

