/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.captcha.configuration.CaptchaConfiguration;
import com.liferay.captcha.util.CaptchaUtil;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileNameException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.message.boards.exception.LockedThreadException;
import com.liferay.message.boards.exception.MessageBodyException;
import com.liferay.message.boards.exception.MessageSubjectException;
import com.liferay.message.boards.exception.NoSuchMessageException;
import com.liferay.message.boards.exception.RequiredMessageException;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBCategoryService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.message.boards.service.MBThreadService;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.message.boards.web.internal.upload.format.MBMessageFormatUploadHandler;
import com.liferay.message.boards.web.internal.upload.format.MBMessageFormatUploadHandlerProvider;
import com.liferay.message.boards.web.internal.util.MBAttachmentFileEntryReference;
import com.liferay.message.boards.web.internal.util.MBAttachmentFileEntryUtil;
import com.liferay.portal.kernel.captcha.CaptchaConfigurationException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.LiferayActionResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/edit_message"}, service={MVCActionCommand.class})
public class EditMessageMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditMessageMVCActionCommand.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private MBMessageFormatUploadHandlerProvider _formatHandlerProvider;
    @Reference
    private MBCategoryService _mbCategoryService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBMessageService _mbMessageService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private MBThreadService _mbThreadService;
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBMessage)")
    private ModelResourcePermission<MBMessage> _messageModelResourcePermission;
    @Reference
    private Portal _portal;

    protected void addAnswer(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.updateAnswer(messageId, true, false);
    }

    protected void deleteAnswer(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.updateAnswer(messageId, false, false);
    }

    protected void deleteMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.deleteMessage(messageId);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        MBMessage message = null;
        try {
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                Throwable cause = uploadException.getCause();
                if (uploadException.isExceededFileSizeLimit()) {
                    throw new FileSizeException(cause);
                }
                if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                    throw new LiferayFileItemException(cause);
                }
                if (uploadException.isExceededUploadRequestSizeLimit()) {
                    throw new UploadRequestSizeException(cause);
                }
                throw new PortalException(cause);
            }
            if (cmd.equals("add") || cmd.equals("update")) {
                message = (MBMessage)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> this.updateMessage(actionRequest, actionResponse));
            } else if (cmd.equals("add_answer")) {
                this.addAnswer(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteMessage(actionRequest);
            } else if (cmd.equals("delete_answer")) {
                this.deleteAnswer(actionRequest);
            } else if (cmd.equals("lock")) {
                this.lockThreads(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeMessage(actionRequest);
            } else if (cmd.equals("unlock")) {
                this.unlockThreads(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeMessage(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                WindowState windowState = actionRequest.getWindowState();
                if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    String redirect = this.getRedirect(actionRequest, actionResponse, message);
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                } else {
                    String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                    if (Validator.isNotNull((String)redirect)) {
                        actionResponse.sendRedirect(redirect);
                    }
                }
            }
        }
        catch (NoSuchMessageException | RequiredMessageException | PrincipalException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcPath", "/message_boards/error.jsp");
        }
        catch (AntivirusScannerException | DuplicateFileEntryException | FileExtensionException | FileNameException | FileSizeException | LockedThreadException | MessageBodyException | MessageSubjectException | CaptchaConfigurationException | CaptchaTextException | SanitizerException | LiferayFileItemException | UploadRequestSizeException e) {
            if (e instanceof AntivirusScannerException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
        }
        catch (AssetCategoryException | AssetTagException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof SanitizerException) {
                SessionErrors.add((PortletRequest)actionRequest, SanitizerException.class);
            }
            throw e;
        }
        catch (Throwable t) {
            _log.error((Object)"Unable to process action", t);
            actionResponse.setRenderParameter("mvcPath", "/message_boards/error.jsp");
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected CaptchaConfiguration getCaptchaConfiguration() throws CaptchaConfigurationException {
        try {
            return (CaptchaConfiguration)this._configurationProvider.getSystemConfiguration(CaptchaConfiguration.class);
        }
        catch (Exception e) {
            throw new CaptchaConfigurationException((Throwable)e);
        }
    }

    protected String getRedirect(ActionRequest actionRequest, ActionResponse actionResponse, MBMessage message) {
        if (message == null) {
            return ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        }
        int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)1);
        if (workflowAction == 2) {
            return this.getSaveAndContinueRedirect(actionRequest, actionResponse, message);
        }
        LiferayActionResponse liferayActionResponse = (LiferayActionResponse)actionResponse;
        PortletURL portletURL = liferayActionResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        return portletURL.toString();
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, ActionResponse actionResponse, MBMessage message) {
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        boolean preview = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"preview");
        LiferayActionResponse liferayActionResponse = (LiferayActionResponse)actionResponse;
        PortletURL portletURL = liferayActionResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/edit_message");
        portletURL.setParameter("redirect", redirect);
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        portletURL.setParameter("preview", String.valueOf(preview));
        return portletURL.toString();
    }

    protected void lockThreads(ActionRequest actionRequest) throws Exception {
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        if (threadId > 0L) {
            this._mbThreadService.lockThread(threadId);
        } else {
            long[] threadIds;
            for (long curThreadId : threadIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"threadIds"), (long)0L)) {
                this._mbThreadService.lockThread(curThreadId);
            }
        }
    }

    protected void subscribeMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.subscribeMessage(messageId);
    }

    protected void unlockThreads(ActionRequest actionRequest) throws Exception {
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        if (threadId > 0L) {
            this._mbThreadService.unlockThread(threadId);
        } else {
            long[] threadIds;
            for (long curThreadId : threadIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"threadIds"), (long)0L)) {
                this._mbThreadService.unlockThread(curThreadId);
            }
        }
    }

    protected void unsubscribeMessage(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        this._mbMessageService.unsubscribeMessage(messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBMessage updateMessage(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        long parentMessageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentMessageId");
        String subject = ParamUtil.getString((PortletRequest)actionRequest, (String)"subject");
        String body = ParamUtil.getString((PortletRequest)actionRequest, (String)"body");
        MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)themeDisplay.getSiteGroupId());
        ArrayList<ObjectValuePair<String, InputStream>> inputStreamOVPs = new ArrayList<ObjectValuePair<String, InputStream>>(5);
        try {
            MBCategory category;
            String displayStyle;
            List<FileEntry> tempFileEntries = this._populateInputStreamOVPs(actionRequest, messageId, inputStreamOVPs);
            boolean question = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"question");
            if (categoryId != 0L && (displayStyle = (category = this._mbCategoryService.getCategory(categoryId)).getDisplayStyle()).equals("question")) {
                question = true;
            }
            double priority = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"priority");
            boolean allowPingbacks = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"allowPingbacks");
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBMessage.class.getName(), (PortletRequest)actionRequest);
            boolean preview = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"preview");
            serviceContext.setAttribute("preview", (Serializable)Boolean.valueOf(preview));
            MBMessage message = null;
            if (messageId <= 0L) {
                MBMessageFormatUploadHandler formatHandler;
                CaptchaConfiguration captchaConfiguration = this.getCaptchaConfiguration();
                if (captchaConfiguration.messageBoardsEditMessageCaptchaEnabled()) {
                    CaptchaUtil.check((PortletRequest)actionRequest);
                }
                boolean anonymous = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"anonymous");
                if (threadId <= 0L) {
                    message = this._mbMessageService.addMessage(themeDisplay.getScopeGroupId(), categoryId, subject, body, mbGroupServiceSettings.getMessageFormat(), inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
                    if (question) {
                        this._mbThreadLocalService.updateQuestion(message.getThreadId(), true);
                    }
                } else {
                    message = this._mbMessageService.addMessage(parentMessageId, subject, body, mbGroupServiceSettings.getMessageFormat(), inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
                }
                if ((formatHandler = this._formatHandlerProvider.provide(message.getFormat())) != null) {
                    body = this._addBodyAttachmentTempFiles(themeDisplay, message.getBody(), message, formatHandler);
                    message.setBody(body);
                    this._mbMessageLocalService.updateMBMessage(message);
                }
            } else {
                message = this._mbMessageService.getMessage(messageId);
                MBMessageFormatUploadHandler formatHandler = this._formatHandlerProvider.provide(message.getFormat());
                if (formatHandler != null) {
                    body = this._addBodyAttachmentTempFiles(themeDisplay, body, message, formatHandler);
                }
                if ((message = this._mbMessageService.updateMessage(messageId, subject, body, inputStreamOVPs, priority, allowPingbacks, serviceContext)).isRoot()) {
                    this._mbThreadLocalService.updateQuestion(message.getThreadId(), question);
                }
            }
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            boolean subscribe = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"subscribe");
            if (!preview && subscribe && this._messageModelResourcePermission.contains(permissionChecker, (ClassedModel)message, "SUBSCRIBE")) {
                this._mbMessageService.subscribeMessage(message.getMessageId());
            }
            for (FileEntry tempFileEntry : tempFileEntries) {
                TempFileEntryUtil.deleteTempFileEntry((long)tempFileEntry.getFileEntryId());
            }
            MBMessage mBMessage = message;
            return mBMessage;
        }
        finally {
            for (ObjectValuePair objectValuePair : inputStreamOVPs) {
                try {
                    InputStream inputStream = (InputStream)objectValuePair.getValue();
                    Throwable throwable = null;
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    inputStream.close();
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)ioe, (Throwable)ioe);
                }
            }
        }
    }

    private String _addBodyAttachmentTempFiles(ThemeDisplay themeDisplay, String body, MBMessage message, MBMessageFormatUploadHandler formatHandler) throws PortalException {
        List<FileEntry> tempMBAttachmentFileEntries = MBAttachmentFileEntryUtil.getTempMBAttachmentFileEntries(body);
        if (tempMBAttachmentFileEntries.isEmpty()) {
            return body;
        }
        Folder folder = message.addAttachmentsFolder();
        List<MBAttachmentFileEntryReference> mbAttachmentFileEntryReferences = MBAttachmentFileEntryUtil.addMBAttachmentFileEntries(message.getGroupId(), themeDisplay.getUserId(), message.getMessageId(), folder.getFolderId(), tempMBAttachmentFileEntries);
        for (FileEntry tempMBAttachment : tempMBAttachmentFileEntries) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)tempMBAttachment.getFileEntryId());
        }
        return formatHandler.replaceImageReferences(body, mbAttachmentFileEntryReferences);
    }

    private List<FileEntry> _populateInputStreamOVPs(ActionRequest actionRequest, long messageId, List<ObjectValuePair<String, InputStream>> inputStreamOVPs) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String[] selectedFileNames = ParamUtil.getParameterValues((PortletRequest)actionRequest, (String)"selectedFileName");
        ArrayList<FileEntry> tempFileEntries = new ArrayList<FileEntry>(selectedFileNames.length);
        for (String selectedFileName : selectedFileNames) {
            String originalSelectedFileName;
            FileEntry tempFileEntry = TempFileEntryUtil.getTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)"com.liferay.message.boards", (String)selectedFileName);
            tempFileEntries.add(tempFileEntry);
            String uniqueFileName = originalSelectedFileName = TempFileEntryUtil.getOriginalTempFileName((String)tempFileEntry.getFileName());
            if (messageId > 0L) {
                MBMessage message = this._mbMessageService.getMessage(messageId);
                uniqueFileName = DLUtil.getUniqueFileName((long)tempFileEntry.getGroupId(), (long)message.getAttachmentsFolderId(), (String)originalSelectedFileName);
            }
            ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)uniqueFileName, (Object)tempFileEntry.getContentStream());
            inputStreamOVPs.add((ObjectValuePair<String, InputStream>)inputStreamOVP);
        }
        return tempFileEntries;
    }
}

