/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.action;

import com.liferay.message.boards.exception.LockedThreadException;
import com.liferay.message.boards.exception.MessageBodyException;
import com.liferay.message.boards.exception.MessageSubjectException;
import com.liferay.message.boards.exception.NoSuchThreadException;
import com.liferay.message.boards.exception.RequiredMessageException;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.message.boards.service.MBThreadService;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.portal.kernel.portlet.LiferayActionResponse;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.Collections;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBPortlet", "javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "mvc.command.name=/message_boards/move_thread"}, service={MVCActionCommand.class})
public class MoveThreadMVCActionCommand
extends BaseMVCActionCommand {
    private MBMessageService _mbMessageService;
    private MBThreadLocalService _mbThreadLocalService;
    private MBThreadService _mbThreadService;

    public void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.moveThread(actionRequest, actionResponse);
        }
        catch (LockedThreadException | RequiredMessageException | PrincipalException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcPath", "/message_boards/error.jsp");
        }
        catch (MessageBodyException | MessageSubjectException | NoSuchThreadException e) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
        }
    }

    protected void moveThread(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"mbCategoryId");
        long threadId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"threadId");
        MBThread thread = this._mbThreadLocalService.getThread(threadId);
        this._mbThreadService.moveThread(categoryId, threadId);
        boolean addExplanationPost = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"addExplanationPost");
        if (addExplanationPost) {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String subject = ParamUtil.getString((PortletRequest)actionRequest, (String)"subject");
            String body = ParamUtil.getString((PortletRequest)actionRequest, (String)"body");
            MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)themeDisplay.getScopeGroupId());
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)MBMessage.class.getName(), (PortletRequest)actionRequest);
            this._mbMessageService.addMessage(thread.getRootMessageId(), subject, body, mbGroupServiceSettings.getMessageFormat(), Collections.emptyList(), false, -1.0, false, serviceContext);
        }
        LiferayActionResponse liferayActionResponse = (LiferayActionResponse)actionResponse;
        PortletURL portletURL = liferayActionResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(thread.getRootMessageId()));
        actionResponse.sendRedirect(portletURL.toString());
    }

    @Reference(unbind="-")
    protected void setMBMessageService(MBMessageService mbMessageService) {
        this._mbMessageService = mbMessageService;
    }

    @Reference(unbind="-")
    protected void setMBThreadLocalService(MBThreadLocalService mbThreadLocalService) {
        this._mbThreadLocalService = mbThreadLocalService;
    }

    @Reference(unbind="-")
    protected void setMBThreadService(MBThreadService mbThreadService) {
        this._mbThreadService = mbThreadService;
    }
}

