/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.configuration.icon;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.taglib.security.PermissionsURLTag;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "path=/message_boards/view_message"}, service={PortletConfigurationIcon.class})
public class ThreadPermissionsPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    private MBMessageLocalService _mbMessageLocalService;
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBMessage)")
    private ModelResourcePermission<MBMessage> _messageModelResourcePermission;

    public String getMessage(PortletRequest portletRequest) {
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(this.getLocale(portletRequest)), (String)"permissions");
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        String url = "";
        try {
            MBMessage rootMessage = null;
            MBMessage message = ActionUtil.getMessage(portletRequest);
            rootMessage = message.isRoot() ? message : this._mbMessageLocalService.getMessage(message.getRootMessageId());
            String modelResource = MBMessage.class.getName();
            String modelResourceDescription = rootMessage.getSubject();
            String resourcePrimKey = String.valueOf(rootMessage.getMessageId());
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            url = PermissionsURLTag.doTag((String)"", (String)modelResource, (String)modelResourceDescription, null, (String)resourcePrimKey, (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)themeDisplay.getRequest());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public double getWeight() {
        return 102.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        if (user.isDefaultUser()) {
            return false;
        }
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        try {
            MBMessage message = ActionUtil.getMessage(portletRequest);
            MBThread thread = message.getThread();
            if (thread.isLocked()) {
                return false;
            }
            if (!this._messageModelResourcePermission.contains(permissionChecker, (ClassedModel)message, "PERMISSIONS")) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isToolTip() {
        return false;
    }

    public boolean isUseDialog() {
        return true;
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }
}

