/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.portlet.configuration.icon;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.message.boards.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_message_boards_web_portlet_MBAdminPortlet", "path=/message_boards/view_message"}, service={PortletConfigurationIcon.class})
public class ThreadSubscriptionPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBMessage)")
    private ModelResourcePermission<MBMessage> _messageModelResourcePermission;
    @Reference
    private Portal _portal;
    private SubscriptionLocalService _subscriptionLocalService;

    public String getMessage(PortletRequest portletRequest) {
        String key = "subscribe";
        try {
            MBMessage message = ActionUtil.getMessage(portletRequest);
            if (this._isSubscribed(portletRequest, message.getThreadId())) {
                key = "unsubscribe";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(this.getLocale(portletRequest)), (String)key);
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        PortletURL portletURL = this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_message_boards_web_portlet_MBAdminPortlet", "ACTION_PHASE");
        portletURL.setParameter("javax.portlet.action", "/message_boards/edit_message");
        MBMessage message = null;
        try {
            message = ActionUtil.getMessage(portletRequest);
        }
        catch (Exception e) {
            return null;
        }
        if (this._isSubscribed(portletRequest, message.getThreadId())) {
            portletURL.setParameter("cmd", "unsubscribe");
        } else {
            portletURL.setParameter("cmd", "subscribe");
        }
        portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        return portletURL.toString();
    }

    public double getWeight() {
        return 101.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)themeDisplay.getScopeGroupId());
            if (!mbGroupServiceSettings.isEmailMessageAddedEnabled() && !mbGroupServiceSettings.isEmailMessageUpdatedEnabled()) {
                return false;
            }
            MBMessage message = ActionUtil.getMessage(portletRequest);
            return this._messageModelResourcePermission.contains(themeDisplay.getPermissionChecker(), (ClassedModel)message, "SUBSCRIBE");
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Reference(unbind="-")
    protected void setSubscriptionLocalService(SubscriptionLocalService subscriptionLocalService) {
        this._subscriptionLocalService = subscriptionLocalService;
    }

    private boolean _isSubscribed(PortletRequest portletRequest, long threadId) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._subscriptionLocalService.isSubscribed(themeDisplay.getCompanyId(), themeDisplay.getUserId(), MBThread.class.getName(), threadId);
    }
}

