/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.social;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.social.BaseSocialActivityManager;
import com.liferay.portal.kernel.social.SocialActivityManager;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBThread"}, service={SocialActivityManager.class})
public class MBThreadSocialActivityManager
extends BaseSocialActivityManager<MBThread> {
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private SocialActivityLocalService _socialActivityLocalService;

    public void addActivity(long userId, MBThread thread, int type, String extraData, long receiverUserId) throws PortalException {
        if (type == 10002) {
            this.addSubscribeSocialActivity(userId, thread.getGroupId(), thread, extraData);
        } else if (type == 10001) {
            this.addViewSocialActivity(userId, thread, type, extraData, receiverUserId);
        } else {
            super.addActivity(userId, (ClassedModel)thread, type, extraData, receiverUserId);
        }
    }

    protected void addSubscribeSocialActivity(long userId, long groupId, MBThread thread, String extraData) throws PortalException {
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)extraData);
        extraDataJSONObject.put("threadId", thread.getThreadId());
        this._socialActivityLocalService.addActivity(userId, groupId, MBMessage.class.getName(), thread.getRootMessageId(), 10002, extraDataJSONObject.toString(), 0L);
    }

    protected void addViewSocialActivity(long userId, MBThread thread, int type, String extraData, long receiverUserId) throws PortalException {
        if (thread.getRootMessageUserId() == userId) {
            return;
        }
        MBMessage rootMessage = this._mbMessageLocalService.getMessage(thread.getRootMessageId());
        this._socialActivityLocalService.addActivity(userId, rootMessage.getGroupId(), MBMessage.class.getName(), rootMessage.getMessageId(), type, extraData, receiverUserId);
    }

    protected SocialActivityLocalService getSocialActivityLocalService() {
        return this._socialActivityLocalService;
    }
}

