/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.upload;

import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.upload.UploadFileEntryHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseMBUploadFileEntryHandler
implements UploadFileEntryHandler {
    @Reference
    protected DLValidator dlValidator;
    @Reference
    protected MBMessageService mbMessageService;

    public FileEntry upload(UploadPortletRequest uploadPortletRequest) throws IOException, PortalException {
        this.dlValidator.validateFileSize(uploadPortletRequest.getFileName(this.getParameterName()), uploadPortletRequest.getSize(this.getParameterName()).longValue());
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long categoryId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"categoryId");
        try (InputStream inputStream = this.getFileAsStream(uploadPortletRequest);){
            String tempFileName = TempFileEntryUtil.getTempFileName((String)this.getFileName(uploadPortletRequest));
            FileEntry fileEntry = this.mbMessageService.addTempAttachment(themeDisplay.getScopeGroupId(), categoryId, "com.liferay.message.boards", tempFileName, inputStream, this.getContentType(uploadPortletRequest));
            return fileEntry;
        }
    }

    protected String getContentType(UploadPortletRequest uploadPortletRequest) {
        return uploadPortletRequest.getContentType(this.getParameterName());
    }

    protected InputStream getFileAsStream(UploadPortletRequest uploadPortletRequest) throws IOException {
        return uploadPortletRequest.getFileAsStream(this.getParameterName());
    }

    protected String getFileName(UploadPortletRequest uploadPortletRequest) {
        return uploadPortletRequest.getFileName(this.getParameterName());
    }

    protected abstract String getParameterName();
}

