/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.util;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.web.internal.util.MBAttachmentFileEntryReference;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MBAttachmentFileEntryUtil {
    private static final int _UNIQUE_FILE_NAME_TRIES = 50;
    private static final Log _log = LogFactoryUtil.getLog(MBAttachmentFileEntryUtil.class);

    public static List<MBAttachmentFileEntryReference> addMBAttachmentFileEntries(long groupId, long userId, long messageId, long folderId, List<FileEntry> tempFileEntries) throws PortalException {
        ArrayList<MBAttachmentFileEntryReference> mbAttachmentFileEntryReferences = new ArrayList<MBAttachmentFileEntryReference>(tempFileEntries.size());
        for (FileEntry tempFileEntry : tempFileEntries) {
            String uniqueFileName = MBAttachmentFileEntryUtil._getUniqueFileName(groupId, tempFileEntry.getTitle(), folderId);
            FileEntry mbFileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)MBMessage.class.getName(), (long)messageId, (String)"com.liferay.message.boards", (long)folderId, (InputStream)tempFileEntry.getContentStream(), (String)uniqueFileName, (String)tempFileEntry.getMimeType(), (boolean)true);
            mbAttachmentFileEntryReferences.add(new MBAttachmentFileEntryReference(tempFileEntry.getFileEntryId(), mbFileEntry));
        }
        return mbAttachmentFileEntryReferences;
    }

    public static List<FileEntry> getTempMBAttachmentFileEntries(String content) throws PortalException {
        ArrayList<FileEntry> tempMBAttachmentFileEntries = new ArrayList<FileEntry>();
        Pattern pattern = Pattern.compile("data-image-id=.(\\d+)");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            long fileEntryId = GetterUtil.getLong((String)matcher.group(1));
            FileEntry tempFileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)fileEntryId);
            tempMBAttachmentFileEntries.add(tempFileEntry);
        }
        return tempMBAttachmentFileEntries;
    }

    private static FileEntry _fetchPortletFileEntry(long groupId, String fileName, long folderId) {
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)groupId, (long)folderId, (String)fileName);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
    }

    private static String _getUniqueFileName(long groupId, String fileName, long folderId) throws PortalException {
        FileEntry fileEntry = MBAttachmentFileEntryUtil._fetchPortletFileEntry(groupId, fileName = FileUtil.stripParentheticalSuffix((String)fileName), folderId);
        if (fileEntry == null) {
            return fileName;
        }
        int suffix = 1;
        for (int i = 0; i < 50; ++i) {
            String curFileName = FileUtil.appendParentheticalSuffix((String)fileName, (String)String.valueOf(suffix));
            fileEntry = MBAttachmentFileEntryUtil._fetchPortletFileEntry(groupId, curFileName, folderId);
            if (fileEntry == null) {
                return curFileName;
            }
            ++suffix;
        }
        throw new PortalException(StringBundler.concat((Object[])new Object[]{"Unable to get a unique file name for ", fileName, " in folder ", folderId}));
    }
}

