/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.web.internal.util;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.message.boards.web.internal.security.permission.MBMessagePermission;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class MBUtil {
    private static final Log _log = LogFactoryUtil.getLog(MBUtil.class);

    public static String getBBCodeQuoteBody(HttpServletRequest request, MBMessage parentMessage) {
        String parentAuthor = null;
        parentAuthor = parentMessage.isAnonymous() ? LanguageUtil.get((HttpServletRequest)request, (String)"anonymous") : HtmlUtil.escape((String)PortalUtil.getUserName((BaseModel)parentMessage));
        StringBundler sb = new StringBundler(5);
        sb.append("[quote=");
        sb.append(StringUtil.replace((String)parentAuthor, (String[])new String[]{"[", "]", "(", ")"}, (String[])new String[]{"&#91;", "&#93;", "&#40;", "&#41;"}));
        sb.append("]\n");
        sb.append(parentMessage.getBody(false));
        sb.append("[/quote]\n\n\n");
        return sb.toString();
    }

    public static String getBBCodeSplitThreadBody(HttpServletRequest request) {
        StringBundler sb = new StringBundler(5);
        sb.append("[url=");
        sb.append("${newThreadURL}");
        sb.append("]");
        sb.append("${newThreadURL}");
        sb.append("[/url]");
        return LanguageUtil.format((HttpServletRequest)request, (String)"the-new-thread-can-be-found-at-x", (Object)sb.toString(), (boolean)false);
    }

    public static long getCategoryId(HttpServletRequest request, MBCategory category) {
        long categoryId = 0L;
        if (category != null) {
            categoryId = category.getCategoryId();
        }
        categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId", (long)categoryId);
        return categoryId;
    }

    public static long getCategoryId(HttpServletRequest request, MBMessage message) {
        long categoryId = 0L;
        if (message != null) {
            categoryId = message.getCategoryId();
        }
        categoryId = ParamUtil.getLong((HttpServletRequest)request, (String)"mbCategoryId", (long)categoryId);
        return categoryId;
    }

    public static String getHtmlQuoteBody(HttpServletRequest request, MBMessage parentMessage) {
        String parentAuthor = null;
        parentAuthor = parentMessage.isAnonymous() ? LanguageUtil.get((HttpServletRequest)request, (String)"anonymous") : HtmlUtil.escape((String)PortalUtil.getUserName((BaseModel)parentMessage));
        StringBundler sb = new StringBundler(5);
        sb.append("<blockquote><div class=\"quote-title\">");
        sb.append(parentAuthor);
        sb.append(": </div><div class=\"quote\"><div class=\"quote-content\">");
        sb.append(parentMessage.getBody(false));
        sb.append("</div></blockquote><br /><br /><br />");
        return sb.toString();
    }

    public static String getHtmlSplitThreadBody(HttpServletRequest request) {
        StringBundler sb = new StringBundler(5);
        sb.append("<a href=");
        sb.append("${newThreadURL}");
        sb.append(">");
        sb.append("${newThreadURL}");
        sb.append("</a>");
        return LanguageUtil.format((HttpServletRequest)request, (String)"the-new-thread-can-be-found-at-x", (Object)sb.toString(), (boolean)false);
    }

    public static String[] getThreadPriority(MBGroupServiceSettings mbGroupServiceSettings, String languageId, double value) throws Exception {
        String[] priorities = mbGroupServiceSettings.getPriorities(languageId);
        String[] priorityPair = MBUtil._findThreadPriority(value, priorities);
        if (priorityPair == null) {
            String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            priorities = mbGroupServiceSettings.getPriorities(defaultLanguageId);
            priorityPair = MBUtil._findThreadPriority(value, priorities);
        }
        return priorityPair;
    }

    public static boolean isViewableMessage(ThemeDisplay themeDisplay, MBMessage message) throws Exception {
        return MBUtil.isViewableMessage(themeDisplay, message, message);
    }

    public static boolean isViewableMessage(ThemeDisplay themeDisplay, MBMessage message, MBMessage parentMessage) throws Exception {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!MBMessagePermission.contains(permissionChecker, parentMessage, "VIEW")) {
            return false;
        }
        if (message.getMessageId() != parentMessage.getMessageId() && !MBMessagePermission.contains(permissionChecker, message, "VIEW")) {
            return false;
        }
        return message.isApproved() || message.getUserId() == themeDisplay.getUserId() || permissionChecker.isContentReviewer(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId());
    }

    private static String[] _findThreadPriority(double value, String[] priorities) {
        for (String priority : priorities) {
            String[] priorityArray = StringUtil.split((String)priority, (String)"|");
            try {
                String priorityName = priorityArray[0];
                String priorityImage = priorityArray[1];
                double priorityValue = GetterUtil.getDouble((String)priorityArray[2]);
                if (value != priorityValue) continue;
                return new String[]{priorityName, priorityImage};
            }
            catch (Exception e) {
                _log.error((Object)"Unable to determine thread priority", (Throwable)e);
            }
        }
        return null;
    }
}

