Liferay.Loader.define("message-boards-web@4.0.39/message_boards/js/MBPortlet.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-events'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    var _metal = _interopRequireDefault(require("frontend-js-metal-web$metal"));

    var _metalEvents = require("frontend-js-metal-web$metal-events");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _get(target, property, receiver) {
      if (typeof Reflect !== "undefined" && Reflect.get) {
        _get = Reflect.get;
      } else {
        _get = function _get(target, property, receiver) {
          var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
            return desc.get.call(receiver);
          }return desc.value;
        };
      }return _get(target, property, receiver || target);
    }

    function _superPropBase(object, property) {
      while (!Object.prototype.hasOwnProperty.call(object, property)) {
        object = _getPrototypeOf(object);if (object === null) break;
      }return object;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var RECENTLY_REMOVED_ATTACHMENTS = {
      multiple: Liferay.Language.get('x-recently-removed-attachments'),
      single: Liferay.Language.get('x-recently-removed-attachment')
    };
    /**
     * MBPortlet handles the actions of replying or editing a
     * message board.
     *
     * @abstract
     * @extends {PortletBase}
     */

    var MBPortlet = /*#__PURE__*/function (_PortletBase) {
      _inherits(MBPortlet, _PortletBase);

      function MBPortlet() {
        _classCallCheck(this, MBPortlet);

        return _possibleConstructorReturn(this, _getPrototypeOf(MBPortlet).apply(this, arguments));
      }

      _createClass(MBPortlet, [{
        key: "created",

        /**
         * @inheritDoc
         */
        value: function created() {
          this.eventHandler_ = new _metalEvents.EventHandler();
        }
        /**
         * @inheritDoc
         */

      }, {
        key: "attached",
        value: function attached() {
          var _this = this;

          var publishButton = this.one('.button-holder button[type="submit"]');

          if (publishButton) {
            this.eventHandler_.add(publishButton.addEventListener('click', function (e) {
              _this.publish_(e);
            }));
          }

          var saveButton = this.one('#saveButton');

          if (saveButton) {
            this.eventHandler_.add(saveButton.addEventListener('click', function (e) {
              _this.saveDraft_(e);
            }));
          }

          var advancedReplyLink = this.one('.advanced-reply');

          if (advancedReplyLink) {
            this.eventHandler_.add(advancedReplyLink.addEventListener('click', function (e) {
              _this.openAdvancedReply_(e);
            }));
          }

          var searchContainerId = this.ns('messageAttachments');
          Liferay.componentReady(searchContainerId).then(function (searchContainer) {
            _this.eventHandler_.add(searchContainer.get('contentBox').delegate('click', _this.removeAttachment_.bind(_this), '.delete-attachment'));

            _this.searchContainer_ = searchContainer;
          });
          var viewRemovedAttachmentsLink = document.getElementById('view-removed-attachments-link');

          if (viewRemovedAttachmentsLink) {
            viewRemovedAttachmentsLink.addEventListener('click', function () {
              Liferay.Util.openWindow({
                dialog: {
                  on: {
                    visibleChange: function visibleChange(event) {
                      if (!event.newVal) {
                        _this.updateRemovedAttachments_();
                      }
                    }
                  }
                },
                id: _this.namespace + 'openRemovedPageAttachments',
                title: Liferay.Language.get('removed-attachments'),
                uri: _this.viewTrashAttachmentsURL
              });
            });
          }
        }
        /**
         * @inheritDoc
         */

      }, {
        key: "detached",
        value: function detached() {
          _get(_getPrototypeOf(MBPortlet.prototype), "detached", this).call(this);

          this.eventHandler_.removeAllListeners();
        }
        /**
         * Redirects to the advanced reply page
         * keeping the current message.
         *
         * @protected
         */

      }, {
        key: "openAdvancedReply_",
        value: function openAdvancedReply_() {
          var inputNode = this.one('#body');
          inputNode.value = window[this.ns('replyMessageBody' + this.replyToMessageId)].getHTML();
          var form = this.one("[name=\"".concat(this.ns('advancedReplyFm' + this.replyToMessageId), "\"]"));
          var advancedReplyInputNode = form.querySelector("[name=\"".concat(this.ns('body'), "\"]"));
          advancedReplyInputNode.value = inputNode.value;
          submitForm(form);
        }
        /**
         * Publish the message.
         *
         * @protected
         */

      }, {
        key: "publish_",
        value: function publish_() {
          this.one('#workflowAction').value = this.constants.ACTION_PUBLISH;
          this.save_();
        }
        /**
         * Save the message. Before doing that, checks if there are
         * images that have not been uploaded yet. In that case,
         * it removes them after asking confirmation to the user.
         *
         * @protected
         */

      }, {
        key: "save_",
        value: function save_() {
          var tempImages = this.all('img[data-random-id]');

          if (tempImages.length > 0) {
            if (confirm(this.strings.confirmDiscardImages)) {
              tempImages.forEach(function (node) {
                node.parentElement.remove();
              });
              this.submitForm_();
            }
          } else {
            this.submitForm_();
          }
        }
        /**
         * Sends a request to remove the selected attachment.
         *
         * @protected
         * @param {Event} event The click event that triggered the remove action
         */

      }, {
        key: "removeAttachment_",
        value: function removeAttachment_(event) {
          var _this2 = this;

          var link = event.currentTarget;
          var deleteURL = link.getAttribute('data-url');
          (0, _frontendJsWeb.fetch)(deleteURL).then(function () {
            var searchContainer = _this2.searchContainer_;
            searchContainer.deleteRow(link.ancestor('tr'), link.getAttribute('data-rowid'));
            searchContainer.updateDataStore();

            _this2.updateRemovedAttachments_();
          });
        }
        /**
         * Sends a request to retrieve the deleted attachments
         *
         * @protected
         */

      }, {
        key: "updateRemovedAttachments_",
        value: function updateRemovedAttachments_() {
          var _this3 = this;

          (0, _frontendJsWeb.fetch)(this.getAttachmentsURL).then(function (res) {
            return res.json();
          }).then(function (attachments) {
            if (attachments.active.length > 0) {
              var searchContainer = _this3.searchContainer_;
              var searchContainerData = searchContainer.getData();
              document.getElementById(_this3.namespace + 'fileAttachments').classList.remove('hide');
              attachments.active.forEach(function (attachment) {
                if (searchContainerData.indexOf(attachment.id) == -1) {
                  searchContainer.addRow([attachment.title, attachment.size, "<a class=\"delete-attachment\" data-rowId=\"".concat(attachment.id, "\" data-url=\"").concat(attachment.deleteURL, "\" href=\"javascript:;\">").concat(Liferay.Language.get('move-to-recycle-bin'), "</a>")], attachment.id.toString());
                  searchContainer.updateDataStore();
                }
              });
            }

            var deletedAttachmentsElement = document.getElementById('view-removed-attachments-link');

            if (attachments.deleted.length > 0) {
              deletedAttachmentsElement.style.display = 'initial';
              deletedAttachmentsElement.innerHTML = Liferay.Util.sub(attachments.deleted.length > 1 ? RECENTLY_REMOVED_ATTACHMENTS.multiple : RECENTLY_REMOVED_ATTACHMENTS.single, attachments.deleted.length) + ' &raquo';
            } else {
              deletedAttachmentsElement.style.display = 'none';
            }
          });
        }
        /**
         * Updates the attachments to include the checked attachments.
         *
         * @protected
         */

      }, {
        key: "updateMultipleMBMessageAttachments_",
        value: function updateMultipleMBMessageAttachments_() {
          var _this4 = this;

          var selectedFileNameContainer = this.one('#selectedFileNameContainer');

          if (selectedFileNameContainer) {
            var inputName = this.ns('selectUploadedFile');
            var input = [].slice.call(this.all("input[name=".concat(inputName, "]:checked")));
            var data = input.map(function (item, index) {
              var namespace = _this4.namespace;
              var value = item.value;
              return "<input id=\"".concat(namespace, "selectedFileName").concat(index, "\" name=\"").concat(namespace, "selectedFileName\" type=\"hidden\" value=\"").concat(value, "\" />");
            }).join('');
            selectedFileNameContainer.innerHTML = data;
          }
        }
        /**
         * Submits the message.
         *
         * @protected
         */

      }, {
        key: "submitForm_",
        value: function submitForm_() {
          this.one('#' + this.constants.CMD).value = this.currentAction;
          this.updateMultipleMBMessageAttachments_();

          if (this.replyToMessageId) {
            this.one('#body').value = window[this.ns('replyMessageBody' + this.replyToMessageId)].getHTML();
            submitForm(document[this.ns('addQuickReplyFm' + this.replyToMessageId)]);
          } else {
            this.one('#body').value = window[this.ns('bodyEditor')].getHTML();
            submitForm(document[this.ns('fm')]);
          }
        }
        /**
         * Saves the message as a draft.
         *
         * @protected
         */

      }, {
        key: "saveDraft_",
        value: function saveDraft_() {
          this.one('#workflowAction').value = this.constants.ACTION_SAVE_DRAFT;
          this.save_();
        }
      }]);

      return MBPortlet;
    }(_frontendJsWeb.PortletBase);
    /**
     * MBPortlet State definition.
     * @ignore
     * @static
     * @type {!Object}
     */

    MBPortlet.STATE = {
      /**
       * Portlet's constants
       * @instance
       * @memberof MBPortlet
       * @type {!Object}
       */
      constants: {
        validator: _metal.default.isObject
      },

      /**
       * The current action (CMD.ADD, CMD.UPDATE, ...)
       * for the message
       * @instance
       * @memberof MBPortlet
       * @type {String}
       */
      currentAction: {
        validator: _metal.default.isString
      },

      /**
       * The URL to get deleted attachments from
       * @instance
       * @memberof MBPortlet
       * @type {String}
       */
      getAttachmentsURL: {
        validator: _metal.default.isString
      },

      /**
       * The id of the message that
       * you are replying to
       * @instance
       * @memberof MBPortlet
       * @type {String}
       */
      replyToMessageId: {
        validator: _metal.default.isString
      },

      /**
       * Portlet's messages
       * @instance
       * @memberof WikiPortlet
       * @type {Object}
       */
      strings: {
        validator: _metal.default.isObject,
        value: {
          confirmDiscardImages: Liferay.Language.get('uploads-are-in-progress-confirmation')
        }
      },

      /**
       * The URL to edit deleted attachments
       * @instance
       * @memberof MBPortlet
       * @type {String}
       */
      viewTrashAttachmentsURL: {
        validator: _metal.default.isString
      }
    };
    var _default = MBPortlet;
    exports.default = _default;
    //# sourceMappingURL=MBPortlet.es.js.map
  }
});
//# sourceMappingURL=MBPortlet.es.js.map