/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.modules.compat.internal;

import com.liferay.modules.compat.internal.adapter.ServiceAdapter;
import com.liferay.modules.compat.internal.configuration.ModuleCompatExtenderConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.BundleTracker;

@Component(configurationPid={"com.liferay.modules.compat.internal.configuration.ModuleCompatExtenderConfiguration"}, immediate=true)
public class ModuleCompatExtender {
    private static final Log _log = LogFactoryUtil.getLog((String)ModuleCompatExtender.class.getName());
    private BundleTracker<List<ServiceAdapter<?, ?>>> _bundleTracker;
    private Set<String> _modulesCompatHostBundleSymbolicNames;
    private Set<String> _modulesCompatInstallSymbolicNames;

    @Activate
    protected void activate(final BundleContext bundleContext, Map<String, String> properties) throws IOException {
        final Bundle modulesCompatBundle = bundleContext.getBundle();
        URL url = modulesCompatBundle.getEntry("META-INF/modules-compat-fragment.properties");
        final Properties modulesCompatFragmentProperties = new Properties();
        try (InputStream inputStream = url.openStream();){
            modulesCompatFragmentProperties.load(inputStream);
        }
        this._modulesCompatHostBundleSymbolicNames = modulesCompatFragmentProperties.stringPropertyNames();
        url = modulesCompatBundle.getEntry("META-INF/modules-compat-install.properties");
        Properties modulesCompatInstallProperties = new Properties();
        try (InputStream inputStream = url.openStream();){
            modulesCompatInstallProperties.load(inputStream);
        }
        this._modulesCompatInstallSymbolicNames = modulesCompatInstallProperties.stringPropertyNames();
        this._uninstallBundles(bundleContext);
        ModuleCompatExtenderConfiguration moduleCompatExtenderConfiguration = (ModuleCompatExtenderConfiguration)ConfigurableUtil.createConfigurable(ModuleCompatExtenderConfiguration.class, properties);
        if (!moduleCompatExtenderConfiguration.enabled()) {
            return;
        }
        final Pattern pattern = Pattern.compile(moduleCompatExtenderConfiguration.modulesWhitelist());
        Matcher matcher = pattern.matcher("");
        for (String compatInstallSymbolicName : this._modulesCompatInstallSymbolicNames) {
            matcher.reset(compatInstallSymbolicName);
            if (!matcher.matches()) continue;
            url = modulesCompatBundle.getEntry(modulesCompatInstallProperties.getProperty(compatInstallSymbolicName));
            InputStream inputStream = url.openStream();
            Throwable throwable = null;
            try {
                String location = url.toString();
                try {
                    Bundle bundle = bundleContext.installBundle(location.concat("-compat"), inputStream);
                    bundle.start();
                }
                catch (BundleException be) {
                    _log.error((Object)("Unable to install comapt bundle " + compatInstallSymbolicName), (Throwable)be);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        this._bundleTracker = new BundleTracker<List<ServiceAdapter<?, ?>>>(bundleContext, -2, null){

            public List<ServiceAdapter<?, ?>> addingBundle(Bundle bundle, BundleEvent bundleEvent) {
                String location = bundle.getLocation();
                Bundle compatBundle = bundleContext.getBundle(location.concat("-compat"));
                if (compatBundle != null) {
                    return null;
                }
                String symbolicName = bundle.getSymbolicName();
                Matcher matcher = pattern.matcher(symbolicName);
                if (matcher.matches()) {
                    String exportedPackages = modulesCompatFragmentProperties.getProperty(symbolicName);
                    if (Validator.isNull((String)exportedPackages)) {
                        return null;
                    }
                    try {
                        return ModuleCompatExtender.this._installCompatBundle(bundle, bundleContext, ModuleCompatExtender.this._generateExportString(modulesCompatBundle, exportedPackages));
                    }
                    catch (Exception e) {
                        _log.error((Object)("Unable to install compat fragment bundle for " + bundle), (Throwable)e);
                    }
                }
                return null;
            }

            public void removedBundle(Bundle bundle, BundleEvent event, List<ServiceAdapter<?, ?>> serviceAdapters) {
                for (ServiceAdapter<?, ?> serviceAdapter : serviceAdapters) {
                    serviceAdapter.close();
                }
            }
        };
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        if (this._bundleTracker != null) {
            this._bundleTracker.close();
        }
        this._uninstallBundles(bundleContext);
    }

    private String _generateExportString(Bundle bundle, String exportedPackages) throws IOException {
        String[] exports = StringUtil.split((String)exportedPackages);
        if (exports.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(exports.length * 4);
        for (String export : exports) {
            export = export.trim();
            sb.append(export);
            sb.append(";version=\"");
            String packageInfoPath = export.replace(".", "/");
            URL url = bundle.getEntry(packageInfoPath.concat("/packageinfo"));
            try (InputStream inputStream = url.openStream();
                 InputStreamReader reader = new InputStreamReader(inputStream);
                 BufferedReader bufferedReader = new BufferedReader(reader);){
                String versionLine = bufferedReader.readLine();
                sb.append(versionLine.substring(8));
            }
            sb.append("\",");
        }
        sb.setStringAt("\"", sb.index() - 1);
        return sb.toString();
    }

    private List<ServiceAdapter<?, ?>> _installCompatBundle(Bundle bundle, BundleContext bundleContext, String exportBundles) throws Exception {
        String[] adapterLines;
        String symbolicName = bundle.getSymbolicName();
        try (UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();){
            String[] stringArray = null;
            try (JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)unsyncByteArrayOutputStream);){
                Manifest manifest = new Manifest();
                Attributes attributes = manifest.getMainAttributes();
                attributes.putValue("Bundle-ManifestVersion", "2");
                attributes.putValue("Bundle-SymbolicName", symbolicName.concat(".compat"));
                attributes.putValue("Bundle-Version", "1.0.0");
                attributes.putValue("Export-Package", exportBundles);
                attributes.putValue("Fragment-Host", symbolicName);
                attributes.putValue("Manifest-Version", "2");
                jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                manifest.write(jarOutputStream);
                jarOutputStream.closeEntry();
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
            String location = bundle.getLocation();
            Bundle compatBundle = bundleContext.installBundle(location.concat("-compat"), (InputStream)new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.unsafeGetByteArray(), 0, unsyncByteArrayOutputStream.size()));
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Compat fragment " + compatBundle + " installed"));
            }
            this._refreshBundles(bundleContext, Collections.singleton(compatBundle));
        }
        Dictionary headers = bundle.getHeaders();
        ArrayList serviceAdapters = new ArrayList();
        for (String adapterLine : adapterLines = StringUtil.split((String)((String)headers.get("Liferay-Modules-Compat-Adapters")))) {
            String[] classNames = StringUtil.split((String)adapterLine, (char)':');
            if (classNames.length != 2) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Invalid format in bundle: ", String.valueOf(bundle), "'s Liferay-Modules-Compat-Adapters line : ", adapterLine}));
            }
            try {
                Class fromClass = bundle.loadClass(StringUtil.trim((String)classNames[0]));
                Class toClass = bundle.loadClass(StringUtil.trim((String)classNames[1]));
                serviceAdapters.add(new ServiceAdapter(bundleContext, fromClass, toClass));
            }
            catch (ClassNotFoundException cnfe) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Invalid class name in bundle: ", String.valueOf(bundle), "'s Liferay-Modules-Compat-Adapters line : ", adapterLine}), (Throwable)cnfe);
            }
        }
        if (serviceAdapters.isEmpty()) {
            return null;
        }
        return serviceAdapters;
    }

    private void _refreshBundles(BundleContext bundleContext, Collection<Bundle> bundles) {
        Bundle systemBundle = bundleContext.getBundle(0L);
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        frameworkWiring.refreshBundles(bundles, new FrameworkListener[0]);
    }

    private void _uninstallBundles(BundleContext bundleContext) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Set<String> modulesCompatHostBundleSymbolicNames = this._modulesCompatHostBundleSymbolicNames;
        Set<String> modulesCompatInstallSymbolicNames = this._modulesCompatInstallSymbolicNames;
        for (Bundle bundle : bundleContext.getBundles()) {
            String symbolicName = bundle.getSymbolicName();
            if (modulesCompatHostBundleSymbolicNames.contains(symbolicName)) {
                bundles.add(bundle);
                continue;
            }
            String location = bundle.getLocation();
            if ((!symbolicName.endsWith(".compat") || !modulesCompatHostBundleSymbolicNames.contains(symbolicName.substring(0, symbolicName.length() - 7))) && (!location.endsWith("-compat") || !modulesCompatInstallSymbolicNames.contains(symbolicName))) continue;
            try {
                bundle.uninstall();
            }
            catch (BundleException be) {
                _log.error((Object)("Unable to uninstall " + bundle), (Throwable)be);
            }
        }
        this._refreshBundles(bundleContext, bundles);
    }
}

