/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.modules.compat.internal.adapter;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceAdapter<F, T>
implements Closeable {
    private static final Log _log = LogFactoryUtil.getLog(ServiceAdapter.class);
    private final BundleContext _bundleContext;
    private final ServiceTracker<F, ServiceRegistration<T>> _fromServiceTracker;
    private final ServiceTracker<T, ServiceRegistration<F>> _toServiceTracker;

    public ServiceAdapter(BundleContext bundleContext, Class<F> fromClass, Class<T> toClass) {
        this._bundleContext = bundleContext;
        this._fromServiceTracker = new ServiceTracker(this._bundleContext, fromClass, new AdaptorServiceTrackerCustomizer(this._bundleContext, toClass));
        this._fromServiceTracker.open();
        this._toServiceTracker = new ServiceTracker(this._bundleContext, toClass, new AdaptorServiceTrackerCustomizer(this._bundleContext, fromClass));
        this._toServiceTracker.open();
    }

    @Override
    public void close() {
        this._fromServiceTracker.close();
        this._toServiceTracker.close();
    }

    private static class DelegateInvocationHandler
    implements InvocationHandler {
        private final Object _delegateObject;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws ReflectiveOperationException {
            Class<?> delegateClass = this._delegateObject.getClass();
            try {
                method = delegateClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException nsme) {
                _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to delegate ", String.valueOf(method), " on class ", String.valueOf(delegateClass)}));
                Class<?> returnType = method.getReturnType();
                if (returnType.isPrimitive()) {
                    if (returnType.equals(Boolean.TYPE)) {
                        return false;
                    }
                    return 0;
                }
                return null;
            }
            return method.invoke(this._delegateObject, args);
        }

        private DelegateInvocationHandler(Object delegateObject) {
            this._delegateObject = delegateObject;
        }
    }

    private static class AdaptorServiceTrackerCustomizer<F, T>
    implements ServiceTrackerCustomizer<F, ServiceRegistration<T>> {
        private static final ThreadLocal<Boolean> _adaptingInProcess = new CentralizedThreadLocal(AdaptorServiceTrackerCustomizer.class.getName() + "._adaptingInProcess", () -> false);
        private final BundleContext _bundleContext;
        private final Class<T> _clazz;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceRegistration<T> addingService(ServiceReference<F> serviceReference) {
            Object fromService = this._bundleContext.getService(serviceReference);
            if (fromService == null || _adaptingInProcess.get().booleanValue()) {
                return null;
            }
            _adaptingInProcess.set(true);
            Bundle bundle = FrameworkUtil.getBundle(this._clazz);
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            ClassLoader classLoader = bundleWiring.getClassLoader();
            try {
                ServiceRegistration serviceRegistration = this._bundleContext.registerService(this._clazz, ProxyUtil.newProxyInstance((ClassLoader)classLoader, (Class[])new Class[]{classLoader.loadClass(this._clazz.getName())}, (InvocationHandler)new DelegateInvocationHandler(fromService)), this._getProperties(serviceReference));
                return serviceRegistration;
            }
            catch (ClassNotFoundException cnfe) {
                _log.error((Object)("Unable to refresh class " + this._clazz), (Throwable)cnfe);
                ServiceRegistration<T> serviceRegistration = null;
                return serviceRegistration;
            }
            finally {
                _adaptingInProcess.set(false);
            }
        }

        public void modifiedService(ServiceReference<F> serviceReference, ServiceRegistration<T> service) {
            service.setProperties(this._getProperties(serviceReference));
        }

        public void removedService(ServiceReference<F> serviceReference, ServiceRegistration<T> serviceRegistration) {
            this._bundleContext.ungetService(serviceReference);
            if (_adaptingInProcess.get().booleanValue()) {
                return;
            }
            _adaptingInProcess.set(true);
            serviceRegistration.unregister();
            _adaptingInProcess.set(false);
        }

        private AdaptorServiceTrackerCustomizer(BundleContext bundleContext, Class<T> clazz) {
            this._bundleContext = bundleContext;
            this._clazz = clazz;
        }

        private Dictionary<String, Object> _getProperties(ServiceReference<?> serviceReference) {
            HashMapDictionary dictionary = new HashMapDictionary();
            for (String key : serviceReference.getPropertyKeys()) {
                if (key.startsWith("component.") || key.equals("objectClass") || key.startsWith("service.")) continue;
                dictionary.put(key, serviceReference.getProperty(key));
            }
            return dictionary;
        }
    }
}

