/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.type;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.exception.NotificationTemplateAttachmentObjectFieldIdException;
import com.liferay.notification.exception.NotificationTemplateNameException;
import com.liferay.notification.exception.NotificationTemplateObjectDefinitionIdException;
import com.liferay.notification.type.NotificationType;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectDefinitionLocalServiceUtil;
import com.liferay.object.service.ObjectFieldLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;

public abstract class BaseNotificationType
implements NotificationType {
    @Override
    public String getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sendNotification(NotificationContext notificationContext) throws PortalException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validateNotificationTemplate(NotificationContext notificationContext) throws PortalException {
        ObjectDefinition objectDefinition;
        if (Validator.isNull((String)notificationContext.getNotificationTemplateName())) {
            throw new NotificationTemplateNameException("Name is null");
        }
        if (notificationContext.getObjectDefinitionId() > 0L && (objectDefinition = ObjectDefinitionLocalServiceUtil.fetchObjectDefinition((long)notificationContext.getObjectDefinitionId())) == null) {
            throw new NotificationTemplateObjectDefinitionIdException();
        }
        for (long attachmentObjectFieldId : notificationContext.getAttachmentObjectFieldIds()) {
            ObjectField objectField = ObjectFieldLocalServiceUtil.fetchObjectField((long)attachmentObjectFieldId);
            if (objectField != null && Objects.equals(objectField.getBusinessType(), "Attachment") && Objects.equals(objectField.getObjectDefinitionId(), notificationContext.getObjectDefinitionId())) continue;
            throw new NotificationTemplateAttachmentObjectFieldIdException();
        }
    }
}

