var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __reExport = (target, mod, secondTarget) => (__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));

// ../../../../../../../../../$/bridge/for/main/classnames
var classnames_exports = {};
__export(classnames_exports, {
  default: () => classnames_default
});
__reExport(classnames_exports, classnames_star);
import * as classnames_star from "../../frontend-js-react-web/__liferay__/exports/classnames.js";
import __default__ from "../../frontend-js-react-web/__liferay__/exports/classnames.js";
var classnames_default = __default__;

// ../../../../../../../../../$/bridge/for/main/react
var react_exports = {};
__export(react_exports, {
  default: () => react_default
});
__reExport(react_exports, react_star);
import * as react_star from "../../frontend-js-react-web/__liferay__/exports/react.js";
import __default__2 from "../../frontend-js-react-web/__liferay__/exports/react.js";
var react_default = __default__2;

// src/main/resources/META-INF/resources/js/components/FDSPropsTransformer/NotificationQueueEntryStatusDataRenderer.tsx
var statusMap = /* @__PURE__ */ new Map([
  [0, { className: "label-danger", label: Liferay.Language.get("failed") }],
  [1, { className: "label-success", label: Liferay.Language.get("sent") }],
  [2, { className: "label-warning", label: Liferay.Language.get("unsent") }]
]);
function NotificationQueueEntryStatusDataRenderer({
  value
}) {
  const statusInfo = typeof value === "number" ? statusMap.get(value) : null;
  return statusInfo ? /* @__PURE__ */ react_default.createElement("strong", { className: `label ${statusInfo.className}` }, statusInfo.label) : /* @__PURE__ */ react_default.createElement(
    "strong",
    {
      className: classnames_default("label", {
        "label-danger": !value,
        "label-success": value
      })
    },
    value ? Liferay.Language.get("sent") : Liferay.Language.get("unsent")
  );
}

// ../../../../../../../../../$/bridge/for/main/@clayui/popover
var popover_exports = {};
__export(popover_exports, {
  default: () => popover_default
});
__reExport(popover_exports, clayui_popover_star);
import * as clayui_popover_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$popover.js";
import __default__3 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$popover.js";
var popover_default = __default__3;

// src/main/resources/META-INF/resources/js/components/FDSPropsTransformer/NotificationQueueEntryToDataRenderer.tsx
var getToTooltipText = (value) => {
  const toArray = value.split(",");
  const lastItem = toArray.length > 1 ? toArray.pop() : null;
  return toArray.length > 1 ? `${toArray.join(",")} ${Liferay.Language.get(
    "and"
  ).toLocaleLowerCase()} ${lastItem}.` : value;
};
function NotificationQueueEntryToDataRenderer({ value }) {
  const [isPopoverVisible, setPopoverVisible] = (0, react_exports.useState)(false);
  return /* @__PURE__ */ react_default.createElement(
    popover_default,
    {
      "data-testid": "clayPopover",
      disableScroll: true,
      header: Liferay.Language.get("to"),
      onShowChange: setPopoverVisible,
      show: isPopoverVisible,
      style: { width: 256 },
      trigger: /* @__PURE__ */ react_default.createElement(
        "span",
        {
          className: "ddm-tooltip",
          onMouseOut: () => setPopoverVisible(false),
          onMouseOver: () => setPopoverVisible(true)
        },
        value.length > 25 ? value.slice(0, 25).trim() + "..." : value
      )
    },
    getToTooltipText(value)
  );
}

// src/main/resources/META-INF/resources/js/components/FDSPropsTransformer/NotificationQueueEntryFDSPropsTransformer.tsx
function propsTransformer({ ...otherProps }) {
  return {
    ...otherProps,
    customDataRenderers: {
      notificationQueueEntryStatusDataRenderer: NotificationQueueEntryStatusDataRenderer,
      notificationQueueEntryToDataRenderer: NotificationQueueEntryToDataRenderer
    }
  };
}

// ../../../../../../../../../$/bridge/for/main/@clayui/form
var form_exports = {};
__export(form_exports, {
  default: () => form_default
});
__reExport(form_exports, clayui_form_star);
import * as clayui_form_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$form.js";
import __default__4 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$form.js";
var form_default = __default__4;

// ../../../../../../../../../$/bridge/for/main/@liferay/object-js-components-web
var object_js_components_web_exports = {};
__reExport(object_js_components_web_exports, liferay_star);
import * as liferay_star from "../../object-js-components-web/__liferay__/index.js";

// ../../../../../../../../../$/bridge/for/main/frontend-js-web
var frontend_js_web_exports = {};
__reExport(frontend_js_web_exports, liferay_star2);
import * as liferay_star2 from "../../frontend-js-web/__liferay__/index.js";

// src/main/resources/META-INF/resources/js/util/constants.ts
var defaultLanguageId = Liferay.ThemeDisplay.getDefaultLanguageId();
var HEADERS = new Headers({
  "Accept": "application/json",
  "Content-Type": "application/json"
});

// src/main/resources/META-INF/resources/js/components/BasicInfoContainer/BasicInfoContainer.tsx
function BasicInfoContainer({
  errors,
  setValues,
  values
}) {
  return /* @__PURE__ */ react_default.createElement(object_js_components_web_exports.Card, { title: Liferay.Language.get("basic-info") }, /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.Input,
    {
      disabled: values.system,
      error: errors.name,
      id: "name",
      label: Liferay.Language.get("name"),
      name: "name",
      onChange: ({ target }) => setValues({
        ...values,
        name: target.value
      }),
      required: true,
      value: values.name
    }
  ), /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.Input,
    {
      component: "textarea",
      disabled: values.system,
      id: "description",
      label: Liferay.Language.get("description"),
      name: "description",
      onChange: ({ target }) => setValues({
        ...values,
        description: target.value
      }),
      type: "text",
      value: values.description
    }
  ));
}

// ../../../../../../../../../$/bridge/for/main/@clayui/core
var core_exports = {};
__reExport(core_exports, clayui_core_star);
import * as clayui_core_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$core.js";

// ../../../../../../../../../$/bridge/for/main/frontend-js-components-web
var frontend_js_components_web_exports = {};
__reExport(frontend_js_components_web_exports, liferay_star3);
import * as liferay_star3 from "../../frontend-js-components-web/__liferay__/index.js";

// ../../../../../../../../../$/bridge/for/main/@clayui/panel
var panel_exports = {};
__export(panel_exports, {
  default: () => panel_default
});
__reExport(panel_exports, clayui_panel_star);
import * as clayui_panel_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$panel.js";
import __default__5 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$panel.js";
var panel_default = __default__5;

// src/main/resources/META-INF/resources/js/components/ContentContainer/Attachments.scss
var link = document.createElement("link");
link.setAttribute("rel", "stylesheet");
link.setAttribute("type", "text/css");
link.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/notification-web/js/components/ContentContainer/Attachments.css"
);
document.querySelector("head").appendChild(link);

// src/main/resources/META-INF/resources/js/components/ContentContainer/Attachments.tsx
function Attachments({
  objectDefinitions,
  setValues,
  values
}) {
  const [attachmentsFields, setAttachmentsFields] = (0, react_exports.useState)([]);
  const [objectDefinitionItems, setObjectDefinitionItems] = (0, react_exports.useState)([]);
  const [selectedEntityValue, setSelectedEntityValue] = (0, react_exports.useState)();
  const parseFields = (fields) => {
    const attachmentObjectFieldIds = new Set(
      values?.attachmentObjectFieldIds
    );
    const selectedObjectDefinitionItem = objectDefinitions.find(
      (objectDefinition) => objectDefinition.externalReferenceCode === selectedEntityValue
    );
    const parsedField = {
      children: fields.map(({ id, label, name }) => {
        return {
          checked: attachmentObjectFieldIds.has(id),
          label: object_js_components_web_exports.stringUtils.getLocalizableLabel(
            selectedObjectDefinitionItem?.defaultLanguageId,
            label,
            name
          ),
          value: id?.toString()
        };
      }),
      label: "",
      value: "attachmentsFields"
    };
    return [parsedField];
  };
  const getAttachmentFields = async function fetchObjectFields(objectDefinitionExternalReferenceCode) {
    const items = await object_js_components_web_exports.API.getObjectDefinitionByExternalReferenceCodeObjectFields(
      objectDefinitionExternalReferenceCode
    );
    const fields = items?.filter(
      (field) => field.businessType === "Attachment"
    );
    setAttachmentsFields(parseFields(fields));
  };
  (0, react_exports.useEffect)(() => {
    const currentObjectDefinition = objectDefinitions?.find(
      (objectDefinition) => objectDefinition.externalReferenceCode === values.objectDefinitionExternalReferenceCode
    );
    const newObjectDefinitionItems = [];
    objectDefinitions.forEach(
      ({
        defaultLanguageId: defaultLanguageId2,
        externalReferenceCode,
        id,
        label,
        name,
        system
      }) => {
        if (!system) {
          newObjectDefinitionItems.push({
            id,
            label: object_js_components_web_exports.stringUtils.getLocalizableLabel(
              defaultLanguageId2,
              label,
              name
            ),
            value: externalReferenceCode
          });
        }
      }
    );
    if (!currentObjectDefinition) {
      setValues({
        ...values,
        attachmentObjectFieldIds: [],
        objectDefinitionId: null
      });
    }
    if (values.objectDefinitionId) {
      getAttachmentFields(
        values.objectDefinitionExternalReferenceCode
      );
    }
    setObjectDefinitionItems(newObjectDefinitionItems);
    setSelectedEntityValue(currentObjectDefinition?.externalReferenceCode);
  }, [objectDefinitions, values.objectDefinitionId]);
  (0, react_exports.useEffect)(() => {
    if (attachmentsFields.length) {
      setValues({
        ...values,
        attachmentObjectFieldIds: attachmentsFields[0].children.filter((field) => field.checked).map((field) => field.value)
      });
    }
  }, [attachmentsFields]);
  return /* @__PURE__ */ react_default.createElement(
    panel_default,
    {
      collapsable: true,
      defaultExpanded: true,
      displayTitle: Liferay.Language.get("attachments"),
      displayType: "secondary",
      showCollapseIcon: true
    },
    /* @__PURE__ */ react_default.createElement(panel_default.Body, null, /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-attachments" }, /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-attachments-fields" }, /* @__PURE__ */ react_default.createElement(
      object_js_components_web_exports.SingleSelect,
      {
        disabled: values.system,
        items: objectDefinitionItems,
        label: Liferay.Language.get("data-source"),
        onSelectionChange: (externalReferenceCode) => {
          getAttachmentFields(
            externalReferenceCode
          );
          setSelectedEntityValue(
            externalReferenceCode
          );
          const selectedObjectDefinitionItem = objectDefinitionItems.find(
            (objectDefinitionItem) => objectDefinitionItem.value === externalReferenceCode
          );
          setValues({
            ...values,
            objectDefinitionExternalReferenceCode: externalReferenceCode,
            objectDefinitionId: selectedObjectDefinitionItem?.id
          });
        },
        placeholder: Liferay.Language.get(
          "select-a-data-source"
        ),
        selectedKey: selectedEntityValue
      }
    )), /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-attachments-fields" }, /* @__PURE__ */ react_default.createElement(
      object_js_components_web_exports.MultipleSelect,
      {
        disabled: !selectedEntityValue || values.system,
        label: Liferay.Language.get("field"),
        options: attachmentsFields,
        placeholder: Liferay.Language.get("select-a-field"),
        setOptions: setAttachmentsFields
      }
    ))))
  );
}

// src/main/resources/META-INF/resources/js/components/ContentContainer/FreeMarkerTemplateEditor.tsx
function FreeMarkerTemplateEditor({
  baseResourceURL,
  objectDefinitions,
  selectedLocale,
  setSelectedLocale,
  setValues,
  values
}) {
  const [selectedEntityValue, setSelectedEntityValue] = (0, react_exports.useState)();
  const [entityFields, setEntityFields] = (0, react_exports.useState)([]);
  const objectDefinitionItems = (0, react_exports.useMemo)(() => {
    const availableObjectDefinitions = objectDefinitions.filter(
      (objectDefinition) => {
        const { label: statusLabel } = objectDefinition.status;
        if (objectDefinition.system) {
          return objectDefinition.name !== "Address" && objectDefinition.name !== "User" && objectDefinition.name !== "AccountEntry" && objectDefinition.name !== "CommercePricingClass";
        }
        return statusLabel === "approved";
      }
    );
    return availableObjectDefinitions.map(
      ({ defaultLanguageId: defaultLanguageId2, id, label, name }) => ({
        label: object_js_components_web_exports.stringUtils.getLocalizableLabel(
          defaultLanguageId2,
          label,
          name
        ),
        value: id
      })
    );
  }, [objectDefinitions]);
  const getEntityFields = async (objectDefinitionId) => {
    const response = await (0, frontend_js_web_exports.fetch)(
      (0, frontend_js_web_exports.createResourceURL)(baseResourceURL, {
        objectDefinitionId,
        p_p_resource_id: "/notification_templates/notification_template_ftl_elements"
      }).toString()
    );
    setEntityFields(await response.json());
  };
  return /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.CodeEditorLocalized,
    {
      CustomSidebarContent: /* @__PURE__ */ react_default.createElement(
        object_js_components_web_exports.SingleSelect,
        {
          disabled: values.system,
          items: objectDefinitionItems ?? [],
          label: Liferay.Language.get("entity"),
          onSelectionChange: (value) => {
            setSelectedEntityValue(value);
            getEntityFields(value);
          },
          selectedKey: selectedEntityValue
        }
      ),
      mode: "freemarker",
      onSelectedLocaleChange: ({ label }) => {
        setSelectedLocale(label);
      },
      onTranslationsChange: (translations) => {
        setValues({
          ...values,
          body: translations
        });
      },
      placeholder: `<#--${Liferay.Language.get(
        "add-elements-from-the-sidebar-to-define-your-template"
      )}-->`,
      readOnly: values.system,
      selectedLocale,
      sidebarElements: entityFields,
      sidebarElementsDisabled: values.system,
      translations: values.body
    }
  );
}

// src/main/resources/META-INF/resources/js/components/ContentContainer/ContentContainer.tsx
var EDITOR_TYPES = [
  {
    label: Liferay.Language.get("freemarker-template"),
    value: "freeMarker"
  },
  {
    label: Liferay.Language.get("rich-text"),
    value: "richText"
  }
];
function ContentContainer({
  baseResourceURL,
  editorConfig,
  errors,
  objectDefinitions,
  selectedLocale,
  setSelectedLocale,
  setValues,
  values
}) {
  return /* @__PURE__ */ react_default.createElement(object_js_components_web_exports.Card, { title: Liferay.Language.get("content") }, /* @__PURE__ */ react_default.createElement(core_exports.Text, { as: "span", color: "secondary" }, Liferay.Language.get(
    "use-terms-to-populate-fields-dynamically-with-the-exception-of-the-freemarker-template-editor"
  )), /* @__PURE__ */ react_default.createElement(
    frontend_js_components_web_exports.InputLocalized,
    {
      ...values.type === "userNotification" && {
        component: "textarea"
      },
      disabled: values.system,
      error: errors.subject,
      id: "subject",
      label: Liferay.Language.get("subject"),
      name: "subject",
      onChange: (translation) => {
        setValues({
          ...values,
          subject: translation
        });
      },
      placeholder: "",
      required: true,
      selectedLocale,
      translations: values.subject
    }
  ), values.type === "email" && /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.SingleSelect,
    {
      disabled: values.system,
      items: EDITOR_TYPES,
      label: Liferay.Language.get("editor-type"),
      onSelectionChange: (value) => {
        setValues({
          ...values,
          editorType: value
        });
      },
      required: true,
      selectedKey: values.editorType
    }
  ), values.editorType === "richText" ? /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.RichTextLocalized,
    {
      editorConfig,
      label: Liferay.Language.get("template"),
      name: "template",
      onSelectedLocaleChange: ({ label }) => setSelectedLocale(label),
      onTranslationsChange: (translation) => {
        setValues({
          ...values,
          body: translation
        });
      },
      readOnly: values.system,
      selectedLocale,
      translations: values.body
    }
  ) : /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
    FreeMarkerTemplateEditor,
    {
      baseResourceURL,
      objectDefinitions,
      selectedLocale,
      setSelectedLocale,
      setValues,
      values
    }
  ), /* @__PURE__ */ react_default.createElement(core_exports.Text, { as: "span", color: "secondary", size: 3 }, Liferay.Language.get(
    "object-terms-cannot-be-used-in-freemarker-templates"
  )))), values.type === "email" && /* @__PURE__ */ react_default.createElement(
    Attachments,
    {
      objectDefinitions,
      setValues,
      values
    }
  ));
}

// ../../../../../../../../../$/bridge/for/main/@liferay/frontend-data-set-web
var frontend_data_set_web_exports = {};
__reExport(frontend_data_set_web_exports, liferay_star4);
import * as liferay_star4 from "../../frontend-data-set-web/__liferay__/index.js";

// ../../../../../../../../../$/bridge/for/main/@clayui/loading-indicator
var loading_indicator_exports = {};
__export(loading_indicator_exports, {
  default: () => loading_indicator_default
});
__reExport(loading_indicator_exports, clayui_loading_indicator_star);
import * as clayui_loading_indicator_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$loading-indicator.js";
import __default__6 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$loading-indicator.js";
var loading_indicator_default = __default__6;

// src/main/resources/META-INF/resources/js/components/DefinitionOfTermsContainer/RelationshipSection.tsx
function RelationshipSection({
  baseResourceURL,
  currentRelationshipSectionIndex,
  relationshipSection,
  relationshipSections,
  setRelationshipSections
}) {
  const [loading, setLoading] = (0, react_exports.useState)(false);
  const [panelExpanded, setPanelExpanded] = (0, react_exports.useState)(false);
  const [showFDS, setShowFDS] = (0, react_exports.useState)(false);
  const getObjectFieldRelatedTerms = async (relationshipSections2, currentRelationshipSectionIndex2) => {
    const response = await (0, frontend_js_web_exports.fetch)(
      (0, frontend_js_web_exports.createResourceURL)(baseResourceURL, {
        objectRelationshipId: relationshipSection.objectRelationshipId,
        p_p_resource_id: "/notification_templates/get_parent_object_field_notification_template_terms"
      }).toString()
    );
    const terms = await response.json();
    const newRelationshipSections = relationshipSections2;
    newRelationshipSections[currentRelationshipSectionIndex2].terms = terms;
    setRelationshipSections(newRelationshipSections);
  };
  (0, react_exports.useEffect)(() => {
    const makeFetch = async () => {
      setShowFDS(false);
      if (panelExpanded) {
        setLoading(true);
        await getObjectFieldRelatedTerms(
          relationshipSections,
          currentRelationshipSectionIndex
        );
        setLoading(false);
        setShowFDS(true);
      }
    };
    makeFetch();
  }, [panelExpanded]);
  return /* @__PURE__ */ react_default.createElement(
    panel_default,
    {
      collapsable: true,
      defaultExpanded: false,
      displayTitle: relationshipSection.sectionLabel,
      displayType: "unstyled",
      expanded: panelExpanded,
      key: relationshipSection.objectRelationshipId,
      onExpandedChange: () => setPanelExpanded(!panelExpanded),
      showCollapseIcon: true
    },
    loading && /* @__PURE__ */ react_default.createElement(loading_indicator_default, { displayType: "secondary", size: "sm" }),
    showFDS && /* @__PURE__ */ react_default.createElement(
      frontend_data_set_web_exports.FrontendDataSet,
      {
        id: "DefinitionOfTermsTable",
        items: relationshipSection.terms ?? [],
        itemsActions: [
          {
            href: "copyObjectFieldTerm",
            id: "copyObjectFieldTerm",
            label: Liferay.Language.get("copy"),
            target: "event"
          }
        ],
        onActionDropdownItemClick: object_js_components_web_exports.onActionDropdownItemClick,
        selectedItemsKey: "id",
        showManagementBar: false,
        showPagination: false,
        showSearch: false,
        views: [
          {
            contentRenderer: "table",
            label: "Table",
            name: "table",
            schema: {
              fields: [
                {
                  fieldName: "termLabel",
                  label: Liferay.Language.get("label")
                },
                {
                  fieldName: "termName",
                  label: Liferay.Language.get("term")
                }
              ]
            },
            thumbnail: "table"
          }
        ]
      }
    )
  );
}

// src/main/resources/META-INF/resources/js/components/DefinitionOfTermsContainer/DefinitionOfTerms.tsx
function DefinitionOfTerms({
  baseResourceURL,
  objectDefinitions
}) {
  const [selectedEntityId, setSelectedEntityId] = (0, react_exports.useState)();
  const [entityFields, setObjectFieldTerms] = (0, react_exports.useState)([]);
  const [relationshipSections, setRelationshipSections] = (0, react_exports.useState)([]);
  const objectDefinitionItems = (0, react_exports.useMemo)(() => {
    return objectDefinitions.map(
      ({ defaultLanguageId: defaultLanguageId2, id, label, name }) => ({
        label: object_js_components_web_exports.stringUtils.getLocalizableLabel(
          defaultLanguageId2,
          label,
          name
        ),
        value: id
      })
    );
  }, [objectDefinitions]);
  const getObjectFieldTerms = async (objectDefinitionId) => {
    const response = await (0, frontend_js_web_exports.fetch)(
      (0, frontend_js_web_exports.createResourceURL)(baseResourceURL, {
        objectDefinitionId,
        p_p_resource_id: "/notification_templates/get_object_field_notification_template_terms"
      }).toString()
    );
    const { relationshipSections: relationshipSections2, terms } = await response.json();
    setObjectFieldTerms(terms);
    setRelationshipSections(relationshipSections2);
  };
  const copyObjectFieldTerm = ({ itemData }) => {
    navigator.clipboard.writeText(itemData.termName);
    (0, object_js_components_web_exports.openToast)({
      message: Liferay.Language.get("term-copied-successfully"),
      type: "success"
    });
  };
  (0, react_exports.useEffect)(() => {
    Liferay.on("copyObjectFieldTerm", copyObjectFieldTerm);
    return () => {
      Liferay.detach("copyObjectFieldTerm");
    };
  }, []);
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.SingleSelect,
    {
      items: objectDefinitionItems,
      label: Liferay.Language.get("entity"),
      onSelectionChange: (value) => {
        getObjectFieldTerms(value);
        setSelectedEntityId(value);
      },
      selectedKey: selectedEntityId
    }
  ), /* @__PURE__ */ react_default.createElement("div", { id: "lfr-notification-web__definition-of-terms-table" }, /* @__PURE__ */ react_default.createElement(
    frontend_data_set_web_exports.FrontendDataSet,
    {
      id: "DefinitionOfTermsTable",
      items: entityFields,
      itemsActions: [
        {
          href: "copyObjectFieldTerm",
          id: "copyObjectFieldTerm",
          label: Liferay.Language.get("copy"),
          target: "event"
        }
      ],
      onActionDropdownItemClick: object_js_components_web_exports.onActionDropdownItemClick,
      selectedItemsKey: "termName",
      showManagementBar: false,
      showPagination: false,
      showSearch: false,
      views: [
        {
          contentRenderer: "table",
          label: "Table",
          name: "table",
          schema: {
            fields: [
              {
                fieldName: "termLabel",
                label: Liferay.Language.get(
                  "label"
                )
              },
              {
                fieldName: "termName",
                label: Liferay.Language.get("term")
              }
            ]
          },
          thumbnail: "table"
        }
      ]
    }
  ))), relationshipSections?.map((relationshipSection, index) => /* @__PURE__ */ react_default.createElement(
    RelationshipSection,
    {
      baseResourceURL,
      currentRelationshipSectionIndex: index,
      key: relationshipSection.objectRelationshipId,
      relationshipSection,
      relationshipSections,
      setRelationshipSections
    }
  )));
}

// src/main/resources/META-INF/resources/js/components/DefinitionOfTermsContainer/GeneralTerms.tsx
function GeneralTerms({ baseResourceURL }) {
  const [generalTermsItems, setGeneralTermsItems] = (0, react_exports.useState)([]);
  const copyGeneralTerm = ({ itemData }) => {
    navigator.clipboard.writeText(itemData.termName);
    (0, object_js_components_web_exports.openToast)({
      message: Liferay.Language.get("term-copied-successfully"),
      type: "success"
    });
  };
  (0, react_exports.useEffect)(() => {
    Liferay.on("copyGeneralTerm", copyGeneralTerm);
    return () => {
      Liferay.detach("copyGeneralTerm");
    };
  }, []);
  (0, react_exports.useEffect)(() => {
    const makeFetch = async () => {
      const response = await (0, frontend_js_web_exports.fetch)(
        (0, frontend_js_web_exports.createResourceURL)(baseResourceURL, {
          p_p_resource_id: "/notification_templates/get_general_notification_template_terms"
        }).toString()
      );
      const responseJSON = await response.json();
      setGeneralTermsItems(responseJSON);
    };
    makeFetch();
  }, [baseResourceURL]);
  return /* @__PURE__ */ react_default.createElement(
    panel_default,
    {
      collapsable: true,
      defaultExpanded: true,
      displayTitle: Liferay.Language.get("general-terms"),
      displayType: "unstyled",
      showCollapseIcon: true
    },
    /* @__PURE__ */ react_default.createElement(panel_default.Body, null, /* @__PURE__ */ react_default.createElement(
      frontend_data_set_web_exports.FrontendDataSet,
      {
        id: "GeneralTermsTable",
        items: generalTermsItems ?? [],
        itemsActions: [
          {
            href: "copyGeneralTerm",
            id: "copyGeneralTerm",
            label: Liferay.Language.get("copy"),
            target: "event"
          }
        ],
        onActionDropdownItemClick: object_js_components_web_exports.onActionDropdownItemClick,
        selectedItemsKey: "termName",
        showManagementBar: false,
        showPagination: false,
        showSearch: false,
        views: [
          {
            contentRenderer: "table",
            label: "Table",
            name: "table",
            schema: {
              fields: [
                {
                  fieldName: "termLabel",
                  label: Liferay.Language.get("label")
                },
                {
                  fieldName: "termName",
                  label: Liferay.Language.get("term")
                }
              ]
            }
          }
        ]
      }
    ))
  );
}

// src/main/resources/META-INF/resources/js/components/DefinitionOfTermsContainer/DefinitionOfTermsContainer.tsx
function DefinitionOfTermsContainer({
  baseResourceURL,
  objectDefinitions
}) {
  return /* @__PURE__ */ react_default.createElement(object_js_components_web_exports.Card, { title: Liferay.Language.get("definition-of-terms") }, /* @__PURE__ */ react_default.createElement(core_exports.Text, { as: "span", color: "secondary" }, Liferay.Language.get(
    "use-terms-to-populate-fields-dynamically-with-the-exception-of-the-freemarker-template-editor"
  )), /* @__PURE__ */ react_default.createElement(GeneralTerms, { baseResourceURL }), /* @__PURE__ */ react_default.createElement(
    DefinitionOfTerms,
    {
      baseResourceURL,
      objectDefinitions
    }
  ));
}

// ../../../../../../../../../$/bridge/for/main/@clayui/icon
var icon_exports = {};
__export(icon_exports, {
  default: () => icon_default
});
__reExport(icon_exports, clayui_icon_star);
import * as clayui_icon_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$icon.js";
import __default__7 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$icon.js";
var icon_default = __default__7;

// ../../../../../../../../../$/bridge/for/main/@clayui/tooltip
var tooltip_exports = {};
__export(tooltip_exports, {
  default: () => tooltip_default
});
__reExport(tooltip_exports, clayui_tooltip_star);
import * as clayui_tooltip_star from "../../frontend-taglib-clay/__liferay__/exports/@clayui$tooltip.js";
import __default__8 from "../../frontend-taglib-clay/__liferay__/exports/@clayui$tooltip.js";
var tooltip_default = __default__8;

// src/main/resources/META-INF/resources/js/components/SettingsContainer/rolesUtil.ts
var roleGroupLabels = {
  accountRoles: Liferay.Language.get("account-roles"),
  organizationRoles: Liferay.Language.get("organization-roles"),
  regularRoles: Liferay.Language.get("regular-roles")
};
async function getEmailNotificationRoles(baseResourceURL) {
  const response = await (0, frontend_js_web_exports.fetch)(
    (0, frontend_js_web_exports.createResourceURL)(baseResourceURL, {
      p_p_resource_id: "/notification_templates/get_email_notification_roles"
    }).toString()
  );
  const rolesResponse = await response.json();
  const roles = [];
  Object.entries(rolesResponse).forEach(([roleGroupKey, roleValues]) => {
    roles.push({
      children: roleValues.map(({ label, name }) => {
        return {
          checked: false,
          label,
          value: name
        };
      }),
      label: roleGroupLabels[roleGroupKey],
      value: roleGroupKey
    });
  });
  return roles;
}
async function getRoles() {
  const apiURL = `/o/headless-admin-user/v1.0/roles`;
  const query = `${apiURL}?page=-1&restrictFields=rolePermissions`;
  const response = await (0, frontend_js_web_exports.fetch)(query, {
    headers: HEADERS,
    method: "GET"
  });
  return (await response.json()).items;
}
function getUserNotificationRoles(rolesItems, recipients) {
  const roles = {
    children: rolesItems.filter(({ name }) => name !== "Guest").map(({ externalReferenceCode, name }) => {
      const selectedRole = !!recipients.find(
        ({ roleName }) => roleName === externalReferenceCode
      );
      return {
        checked: selectedRole,
        label: name,
        value: externalReferenceCode
      };
    }),
    label: "",
    value: "rolesList"
  };
  return roles;
}
function getCheckedChildren(rolesNamesList, children) {
  const rolesNames = rolesNamesList.map(({ roleName }) => roleName);
  return children.map((child) => {
    return {
      ...child,
      checked: rolesNames.includes(child.value)
    };
  });
}
function handleMultiSelectRoleItemsChange(itemsGroup) {
  const newRecipients = [];
  if (itemsGroup.length) {
    itemsGroup.forEach((itemGroup) => {
      itemGroup.children.forEach((child) => {
        if (child.checked) {
          newRecipients.push({ ["roleName"]: child.value });
        }
      });
    });
  }
  return newRecipients;
}

// src/main/resources/META-INF/resources/js/components/SettingsContainer/PrimaryRecipients.tsx
function PrimaryRecipient({
  emailNotificationRoles,
  errors,
  learnResources,
  recipientOptions,
  selectedLocale,
  setValues,
  values
}) {
  const [recipient] = values.recipients;
  const [toRolesList, setToRolesList] = (0, react_exports.useState)([]);
  (0, react_exports.useEffect)(() => {
    if (emailNotificationRoles.length && !toRolesList.length) {
      setToRolesList(emailNotificationRoles);
    }
    if (recipient.toType === "role" && Array.isArray(recipient.to) && !!recipient.to.length && (!!toRolesList.length || !!emailNotificationRoles.length)) {
      const baseRoleList = toRolesList.length ? toRolesList : emailNotificationRoles;
      setToRolesList(
        baseRoleList.map((baseRoleElement) => {
          return {
            ...baseRoleElement,
            children: getCheckedChildren(
              recipient.to,
              baseRoleElement.children
            )
          };
        })
      );
      return;
    }
  }, [emailNotificationRoles, recipient.to]);
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.SingleSelect,
    {
      disabled: values.system,
      id: "primaryRecipientType",
      items: recipientOptions,
      label: Liferay.Language.get("type"),
      onSelectionChange: (value) => {
        setValues({
          ...values,
          recipients: [
            {
              ...recipient,
              to: [],
              toType: value
            }
          ]
        });
      },
      required: true,
      selectedKey: recipient.toType
    }
  ), recipient.toType === "email" && /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-email-notification-settings-primary-recipient-input-localized" }, /* @__PURE__ */ react_default.createElement(
    frontend_js_components_web_exports.InputLocalized,
    {
      disabled: values.system,
      error: errors.to,
      helpMessage: Liferay.Language.get(
        "you-can-use-a-comma-to-enter-multiple-users"
      ),
      id: "primaryRecipients",
      label: Liferay.Language.get("recipients"),
      name: "recipients",
      onChange: (translation) => {
        setValues({
          ...values,
          recipients: [
            {
              ...recipient,
              to: translation
            }
          ]
        });
      },
      placeholder: Liferay.Language.get("type-email-address"),
      required: true,
      selectedLocale,
      translations: recipient.to
    }
  )), recipient.toType === "role" && /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-email-notification-settings-multiple-select" }, /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.MultipleSelect,
    {
      disabled: values.system,
      error: errors.to,
      id: "primaryRecipientRoles",
      label: Liferay.Language.get("role"),
      options: toRolesList,
      placeholder: Liferay.Language.get("select-role"),
      required: true,
      search: true,
      searchPlaceholder: Liferay.Language.get(
        "search-for-a-role"
      ),
      selectAllOption: true,
      setOptions: (items) => {
        const newRecipients = handleMultiSelectRoleItemsChange(items);
        setValues({
          ...values,
          recipients: [
            {
              ...recipient,
              to: newRecipients
            }
          ]
        });
        setToRolesList(items);
      }
    }
  ), /* @__PURE__ */ react_default.createElement(frontend_js_components_web_exports.LearnResourcesContext.Provider, { value: learnResources }, /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-email-notification-settings-multiple-select-help-text" }, /* @__PURE__ */ react_default.createElement("span", null, Liferay.Language.get(
    "account-roles-are-subject-to-account-restrictions"
  )), "\xA0", /* @__PURE__ */ react_default.createElement(
    frontend_js_components_web_exports.LearnMessage,
    {
      className: "alert-link",
      resource: "notification-web",
      resourceKey: "general"
    }
  )))), /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(form_default.Group, { className: "ml-1 row" }, /* @__PURE__ */ react_default.createElement("div", { className: "mr-2" }, /* @__PURE__ */ react_default.createElement(
    form_exports.ClayCheckbox,
    {
      checked: recipient.singleRecipient,
      disabled: values.system,
      label: Liferay.Language.get(
        "send-emails-separately"
      ),
      onChange: ({ target: { checked } }) => {
        setValues({
          ...values,
          recipients: [
            {
              ...recipient,
              singleRecipient: checked
            }
          ]
        });
      }
    }
  )), /* @__PURE__ */ react_default.createElement(tooltip_exports.ClayTooltipProvider, null, /* @__PURE__ */ react_default.createElement(
    "span",
    {
      title: Liferay.Language.get(
        "each-to-recipient-will-receive-separate-emails"
      )
    },
    /* @__PURE__ */ react_default.createElement(
      icon_default,
      {
        className: "lfr__notification-template-email-notification-settings-tooltip-icon",
        symbol: "question-circle-full"
      }
    )
  )))));
}

// src/main/resources/META-INF/resources/js/components/SettingsContainer/SecondaryRecipients.tsx
function SecondaryRecipient({
  emailNotificationRoles,
  learnResources,
  recipientOptions,
  setValues,
  values
}) {
  const [bccRolesList, setBCCRolesList] = (0, react_exports.useState)([]);
  const [ccRolesList, setCCRolesList] = (0, react_exports.useState)([]);
  const [recipient] = values.recipients;
  (0, react_exports.useEffect)(() => {
    if (emailNotificationRoles.length && !ccRolesList.length) {
      setCCRolesList(emailNotificationRoles);
    }
    if (recipient.ccType === "role" && Array.isArray(recipient.cc) && !!recipient.cc.length && (!!ccRolesList.length || !!emailNotificationRoles.length)) {
      const baseRoleList = ccRolesList.length ? ccRolesList : emailNotificationRoles;
      setCCRolesList(
        baseRoleList.map((baseRoleElement) => {
          return {
            ...baseRoleElement,
            children: getCheckedChildren(
              recipient.cc,
              baseRoleElement.children
            )
          };
        })
      );
      return;
    }
  }, [emailNotificationRoles, recipient.cc]);
  (0, react_exports.useEffect)(() => {
    if (emailNotificationRoles.length && !bccRolesList.length) {
      setBCCRolesList(emailNotificationRoles);
    }
    if (recipient.bccType === "role" && Array.isArray(recipient.bcc) && !!recipient.bcc.length && (!!bccRolesList.length || !!emailNotificationRoles.length)) {
      const baseRoleList = bccRolesList.length ? bccRolesList : emailNotificationRoles;
      setBCCRolesList(
        baseRoleList.map((baseRoleElement) => {
          return {
            ...baseRoleElement,
            children: getCheckedChildren(
              recipient.bcc,
              baseRoleElement.children
            )
          };
        })
      );
      return;
    }
  }, [emailNotificationRoles, recipient.bcc]);
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
    panel_default,
    {
      displayTitle: Liferay.Language.get("cc"),
      displayType: "unstyled"
    },
    /* @__PURE__ */ react_default.createElement(panel_default.Body, null, /* @__PURE__ */ react_default.createElement("div", { className: "row" }, /* @__PURE__ */ react_default.createElement("div", { className: "col-lg-6" }, /* @__PURE__ */ react_default.createElement(
      object_js_components_web_exports.SingleSelect,
      {
        disabled: values.system,
        id: "secondaryRecipientTypeCC",
        items: recipientOptions,
        label: Liferay.Language.get("type"),
        onSelectionChange: (value) => {
          setValues({
            ...values,
            recipients: [
              {
                ...recipient,
                cc: [],
                ccType: value
              }
            ]
          });
        },
        selectedKey: recipient.ccType
      }
    )), /* @__PURE__ */ react_default.createElement("div", { className: "col-lg-6" }, recipient.ccType === "email" && /* @__PURE__ */ react_default.createElement(
      object_js_components_web_exports.Input,
      {
        disabled: values.system,
        feedbackMessage: Liferay.Language.get(
          "you-can-use-a-comma-to-enter-multiple-users"
        ),
        id: "secondaryRecipientsCC",
        label: Liferay.Language.get("recipients"),
        name: "secondaryRecipientsCC",
        onChange: ({ target }) => setValues({
          ...values,
          recipients: [
            {
              ...values.recipients[0],
              cc: target.value
            }
          ]
        }),
        placeholder: Liferay.Language.get(
          "type-email-address"
        ),
        value: values.recipients[0].cc
      }
    ), recipient.ccType === "role" && /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-email-notification-settings-multiple-select" }, /* @__PURE__ */ react_default.createElement(
      object_js_components_web_exports.MultipleSelect,
      {
        disabled: values.system,
        id: "secondaryRecipientRolesCC",
        label: Liferay.Language.get("role"),
        options: ccRolesList,
        placeholder: Liferay.Language.get(
          "select-role"
        ),
        search: true,
        searchPlaceholder: Liferay.Language.get(
          "search-for-a-role"
        ),
        selectAllOption: true,
        setOptions: (items) => {
          const newRecipients = handleMultiSelectRoleItemsChange(
            items
          );
          setValues({
            ...values,
            recipients: [
              {
                ...values.recipients[0],
                cc: newRecipients
              }
            ]
          });
          setCCRolesList(items);
        }
      }
    ), /* @__PURE__ */ react_default.createElement(
      frontend_js_components_web_exports.LearnResourcesContext.Provider,
      {
        value: learnResources
      },
      /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-email-notification-settings-multiple-select-help-text" }, /* @__PURE__ */ react_default.createElement("span", null, Liferay.Language.get(
        "account-roles-are-subject-to-account-restrictions"
      )), "\xA0", /* @__PURE__ */ react_default.createElement(
        frontend_js_components_web_exports.LearnMessage,
        {
          className: "alert-link",
          resource: "notification-web",
          resourceKey: "general"
        }
      ))
    )))))
  ), /* @__PURE__ */ react_default.createElement(
    panel_default,
    {
      displayTitle: Liferay.Language.get("bcc"),
      displayType: "unstyled"
    },
    /* @__PURE__ */ react_default.createElement(panel_default.Body, null, /* @__PURE__ */ react_default.createElement("div", { className: "row" }, /* @__PURE__ */ react_default.createElement("div", { className: "col-lg-6" }, /* @__PURE__ */ react_default.createElement(
      object_js_components_web_exports.SingleSelect,
      {
        disabled: values.system,
        id: "secondaryRecipientTypeBCC",
        items: recipientOptions,
        label: Liferay.Language.get("type"),
        onSelectionChange: (value) => {
          setValues({
            ...values,
            recipients: [
              {
                ...recipient,
                bcc: [],
                bccType: value
              }
            ]
          });
        },
        selectedKey: recipient.bccType
      }
    )), /* @__PURE__ */ react_default.createElement("div", { className: "col-lg-6" }, recipient.bccType === "email" && /* @__PURE__ */ react_default.createElement(
      object_js_components_web_exports.Input,
      {
        disabled: values.system,
        feedbackMessage: Liferay.Language.get(
          "you-can-use-a-comma-to-enter-multiple-users"
        ),
        id: "secondaryRecipientsBCC",
        label: Liferay.Language.get("recipients"),
        name: "secondaryRecipientsBCC",
        onChange: ({ target }) => setValues({
          ...values,
          recipients: [
            {
              ...values.recipients[0],
              bcc: target.value
            }
          ]
        }),
        placeholder: Liferay.Language.get(
          "type-email-address"
        ),
        value: values.recipients[0].bcc
      }
    ), recipient.bccType === "role" && /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-email-notification-settings-multiple-select" }, /* @__PURE__ */ react_default.createElement(
      object_js_components_web_exports.MultipleSelect,
      {
        disabled: values.system,
        id: "secondaryRecipientRolesBCC",
        label: Liferay.Language.get("role"),
        options: bccRolesList,
        placeholder: Liferay.Language.get(
          "select-role"
        ),
        search: true,
        searchPlaceholder: Liferay.Language.get(
          "search-for-a-role"
        ),
        selectAllOption: true,
        setOptions: (items) => {
          const newRecipients = handleMultiSelectRoleItemsChange(
            items
          );
          setValues({
            ...values,
            recipients: [
              {
                ...values.recipients[0],
                bcc: newRecipients
              }
            ]
          });
          setBCCRolesList(items);
        }
      }
    ), /* @__PURE__ */ react_default.createElement(
      frontend_js_components_web_exports.LearnResourcesContext.Provider,
      {
        value: learnResources
      },
      /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-email-notification-settings-multiple-select-help-text" }, /* @__PURE__ */ react_default.createElement("span", null, Liferay.Language.get(
        "account-roles-are-subject-to-account-restrictions"
      )), "\xA0", /* @__PURE__ */ react_default.createElement(
        frontend_js_components_web_exports.LearnMessage,
        {
          className: "alert-link",
          resource: "notification-web",
          resourceKey: "general"
        }
      ))
    )))))
  ));
}

// src/main/resources/META-INF/resources/js/components/SettingsContainer/Sender.tsx
function Sender({
  errors,
  selectedLocale,
  setValues,
  values
}) {
  const [recipient] = values.recipients;
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement("div", { className: "row" }, /* @__PURE__ */ react_default.createElement("div", { className: "col-lg-6" }, /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.Input,
    {
      disabled: values.system,
      error: errors.from,
      id: "fromAddress",
      label: Liferay.Language.get("email-address"),
      name: "fromAddress",
      onChange: ({ target }) => setValues({
        ...values,
        recipients: [
          {
            ...recipient,
            from: target.value
          }
        ]
      }),
      required: true,
      value: recipient.from
    }
  )), /* @__PURE__ */ react_default.createElement("div", { className: "col-lg-6" }, /* @__PURE__ */ react_default.createElement(
    frontend_js_components_web_exports.InputLocalized,
    {
      disabled: values.system,
      error: errors.fromName,
      id: "fromName",
      label: Liferay.Language.get("name"),
      name: "fromName",
      onChange: (translation) => {
        setValues({
          ...values,
          recipients: [
            {
              ...recipient,
              fromName: translation
            }
          ]
        });
      },
      placeholder: "",
      required: true,
      selectedLocale,
      translations: recipient.fromName
    }
  ))), Liferay.FeatureFlags["LPD-21580"] && /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(form_default.Group, { className: "ml-1 row" }, /* @__PURE__ */ react_default.createElement("div", { className: "mr-2" }, /* @__PURE__ */ react_default.createElement(
    form_exports.ClayCheckbox,
    {
      checked: recipient.usePreferredLocaleForGuestUsers,
      disabled: values.system,
      label: Liferay.Language.get(
        "enable-sending-email-notifications-in-the-preferred-language-for-guest-users"
      ),
      onChange: ({ target: { checked } }) => {
        setValues({
          ...values,
          recipients: [
            {
              ...recipient,
              usePreferredLocaleForGuestUsers: checked
            }
          ]
        });
      }
    }
  )))));
}

// src/main/resources/META-INF/resources/js/components/SettingsContainer/EmailNotificationSettings.scss
var link2 = document.createElement("link");
link2.setAttribute("rel", "stylesheet");
link2.setAttribute("type", "text/css");
link2.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/notification-web/js/components/SettingsContainer/EmailNotificationSettings.css"
);
document.querySelector("head").appendChild(link2);

// src/main/resources/META-INF/resources/js/components/SettingsContainer/EmailNotificationSettings.tsx
var RECIPIENT_OPTIONS = [
  {
    label: Liferay.Language.get("user-email-address"),
    value: "email"
  },
  {
    label: Liferay.Language.get("roles"),
    value: "role"
  }
];
function EmailNotificationSettings({
  emailNotificationRoles,
  errors,
  learnResources,
  selectedLocale,
  setValues,
  values
}) {
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, Liferay.FeatureFlags["LPD-11165"] ? /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-email-notification-settings" }, /* @__PURE__ */ react_default.createElement(
    panel_default,
    {
      displayTitle: Liferay.Language.get("sender"),
      displayType: "unstyled"
    },
    /* @__PURE__ */ react_default.createElement(panel_default.Body, null, /* @__PURE__ */ react_default.createElement(
      Sender,
      {
        errors,
        selectedLocale,
        setValues,
        values
      }
    ))
  ), /* @__PURE__ */ react_default.createElement(
    panel_default,
    {
      displayTitle: Liferay.Language.get(
        "primary-recipients"
      ),
      displayType: "unstyled"
    },
    /* @__PURE__ */ react_default.createElement(panel_default.Body, null, /* @__PURE__ */ react_default.createElement(
      PrimaryRecipient,
      {
        emailNotificationRoles,
        errors,
        learnResources,
        recipientOptions: RECIPIENT_OPTIONS,
        selectedLocale,
        setValues,
        values
      }
    ))
  ), /* @__PURE__ */ react_default.createElement(
    panel_default,
    {
      displayTitle: Liferay.Language.get(
        "secondary-recipients"
      ),
      displayType: "unstyled"
    },
    /* @__PURE__ */ react_default.createElement(panel_default.Body, null, /* @__PURE__ */ react_default.createElement(
      SecondaryRecipient,
      {
        emailNotificationRoles,
        learnResources,
        recipientOptions: RECIPIENT_OPTIONS,
        setValues,
        values
      }
    ))
  )) : /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
    frontend_js_components_web_exports.InputLocalized,
    {
      disabled: values.system,
      error: errors.to,
      label: Liferay.Language.get("to"),
      name: "to",
      onChange: (translation) => {
        setValues({
          ...values,
          recipients: [
            {
              ...values.recipients[0],
              to: translation
            }
          ]
        });
      },
      placeholder: "",
      required: true,
      selectedLocale,
      translations: values.recipients[0].to
    }
  ), /* @__PURE__ */ react_default.createElement(form_default.Group, { className: "ml-1 row" }, /* @__PURE__ */ react_default.createElement("div", { className: "mr-2" }, /* @__PURE__ */ react_default.createElement(
    form_exports.ClayCheckbox,
    {
      checked: values.recipients[0].singleRecipient,
      disabled: values.system,
      label: Liferay.Language.get(
        "send-emails-separately"
      ),
      onChange: ({ target: { checked } }) => {
        setValues({
          ...values,
          recipients: [
            {
              ...values.recipients[0],
              singleRecipient: checked
            }
          ]
        });
      }
    }
  )), /* @__PURE__ */ react_default.createElement(tooltip_exports.ClayTooltipProvider, null, /* @__PURE__ */ react_default.createElement(
    "span",
    {
      title: Liferay.Language.get(
        "each-to-recipient-will-receive-separate-emails"
      )
    },
    /* @__PURE__ */ react_default.createElement(
      icon_default,
      {
        className: "lfr__notification-template-email-notification-settings-tooltip-icon",
        symbol: "question-circle-full"
      }
    )
  ))), /* @__PURE__ */ react_default.createElement("div", { className: "row" }, /* @__PURE__ */ react_default.createElement("div", { className: "col-lg-6" }, /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.Input,
    {
      disabled: values.system,
      label: Liferay.Language.get("cc"),
      name: "cc",
      onChange: ({ target }) => setValues({
        ...values,
        recipients: [
          {
            ...values.recipients[0],
            cc: target.value
          }
        ]
      }),
      value: values.recipients[0].cc
    }
  )), /* @__PURE__ */ react_default.createElement("div", { className: "col-lg-6" }, /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.Input,
    {
      disabled: values.system,
      label: Liferay.Language.get("bcc"),
      name: "bcc",
      onChange: ({ target }) => setValues({
        ...values,
        recipients: [
          {
            ...values.recipients[0],
            bcc: target.value
          }
        ]
      }),
      value: values.recipients[0].bcc
    }
  ))), /* @__PURE__ */ react_default.createElement("div", { className: "row" }, /* @__PURE__ */ react_default.createElement("div", { className: "col-lg-6" }, /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.Input,
    {
      disabled: values.system,
      error: errors.from,
      label: Liferay.Language.get("from-address"),
      name: "fromAddress",
      onChange: ({ target }) => setValues({
        ...values,
        recipients: [
          {
            ...values.recipients[0],
            from: target.value
          }
        ]
      }),
      required: true,
      value: values.recipients[0].from
    }
  )), /* @__PURE__ */ react_default.createElement("div", { className: "col-lg-6" }, /* @__PURE__ */ react_default.createElement(
    frontend_js_components_web_exports.InputLocalized,
    {
      disabled: values.system,
      error: errors.fromName,
      label: Liferay.Language.get("from-name"),
      name: "fromName",
      onChange: (translation) => {
        setValues({
          ...values,
          recipients: [
            {
              ...values.recipients[0],
              fromName: translation
            }
          ]
        });
      },
      placeholder: "",
      required: true,
      selectedLocale,
      translations: values.recipients[0].fromName
    }
  )))));
}

// src/main/resources/META-INF/resources/js/components/SettingsContainer/UserNotificationSettings.tsx
var RECIPIENT_OPTIONS2 = [
  {
    label: Liferay.Language.get("definition-of-terms"),
    value: "term"
  },
  {
    label: Liferay.Language.get("user"),
    value: "user"
  },
  {
    label: Liferay.Language.get("role"),
    value: "role"
  }
];
function UserNotificationSettings({
  setValues,
  values
}) {
  const [rolesList, setRolesList] = (0, react_exports.useState)([]);
  const [toTerms, setToTerms] = (0, react_exports.useState)("");
  const [userList, setUserList] = (0, react_exports.useState)([]);
  const getUserRoles = async () => {
    const roles = getUserNotificationRoles(
      await getRoles(),
      values.recipients
    );
    setRolesList([roles]);
    setUserList([]);
  };
  const getTerms = async () => {
    const recipientList = values.recipients;
    setToTerms(recipientList.map(({ term }) => term).join());
  };
  const getUserAccounts = async () => {
    const apiURL = "/o/headless-admin-user/v1.0/user-accounts";
    const query = `${apiURL}?page=-1&sort=givenName:asc`;
    const response = await (0, frontend_js_web_exports.fetch)(query, {
      headers: HEADERS,
      method: "GET"
    });
    const { items } = await response.json();
    const users = {
      children: items.map(({ alternateName, givenName }) => {
        const selectedUser = !!values.recipients.find(
          (recipient) => recipient["userScreenName"] === alternateName
        );
        return {
          checked: selectedUser,
          label: givenName,
          value: alternateName
        };
      }),
      label: "",
      value: "usersList"
    };
    setUserList([users]);
    setRolesList([]);
  };
  const handleMultiSelectItemsChange = (items) => {
    const key = values.recipientType === "role" ? "roleName" : "userScreenName";
    const newRecipients = [];
    if (items.length) {
      const [itemsGroup] = items;
      itemsGroup.children.forEach((child) => {
        if (child.checked) {
          newRecipients.push({ [key]: child.value });
        }
      });
    }
    setValues({
      ...values,
      recipients: newRecipients
    });
  };
  (0, react_exports.useEffect)(() => {
    const makeFetch = async () => {
      if (values.recipientType === "role") {
        await getUserRoles();
        return;
      }
      if (values.recipientType === "term") {
        await getTerms();
        return;
      }
      if (values.recipientType === "user") {
        await getUserAccounts();
        return;
      }
    };
    makeFetch();
  }, [values.recipientType]);
  (0, react_exports.useEffect)(() => {
    const regex = /,/g;
    const toItems = toTerms.replace(regex, " ").split(" ").filter((item) => {
      if (item !== "") {
        return item;
      }
    });
    if (toItems.length) {
      const toRecipients = toItems.map((item) => {
        return { term: item };
      });
      setValues({
        ...values,
        recipients: toRecipients
      });
    }
  }, [toTerms]);
  return /* @__PURE__ */ react_default.createElement(react_default.Fragment, null, /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.SingleSelect,
    {
      disabled: values.system,
      items: RECIPIENT_OPTIONS2,
      label: Liferay.Language.get("recipients"),
      onSelectionChange: (value) => {
        setValues({
          ...values,
          recipientType: value,
          recipients: []
        });
        if (value === "role") {
          getUserRoles();
        }
      },
      selectedKey: values.recipientType
    }
  ), values.recipientType === "term" && /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.Input,
    {
      component: "textarea",
      label: Liferay.Language.get("to"),
      onChange: ({ target }) => {
        setToTerms(target.value);
      },
      placeholder: Liferay.Util.sub(
        Liferay.Language.get(
          "use-terms-to-configure-recipients-for-this-notification-x"
        ),
        "[%OBJECT_AUTHOR_ID%]",
        "."
      ),
      type: "text",
      value: toTerms
    }
  ), values.recipientType === "role" && /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.MultipleSelect,
    {
      disabled: values.system,
      label: Liferay.Language.get("role"),
      options: rolesList,
      placeholder: Liferay.Language.get("enter-a-role"),
      setOptions: (items) => {
        handleMultiSelectItemsChange(items);
        setRolesList(items);
      }
    }
  ), values.recipientType === "user" && /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.MultipleSelect,
    {
      disabled: values.system,
      label: Liferay.Language.get("users"),
      options: userList,
      placeholder: Liferay.Language.get("enter-user-name"),
      setOptions: (items) => {
        handleMultiSelectItemsChange(items);
        setUserList(items);
      }
    }
  ));
}

// src/main/resources/META-INF/resources/js/components/SettingsContainer/SettingsContainer.tsx
function SettingsContainer({
  emailNotificationRoles,
  errors,
  learnResources,
  selectedLocale,
  setValues,
  values
}) {
  return /* @__PURE__ */ react_default.createElement(object_js_components_web_exports.Card, { title: Liferay.Language.get("settings") }, /* @__PURE__ */ react_default.createElement(core_exports.Text, { as: "span", color: "secondary" }, Liferay.Language.get(
    "use-terms-to-populate-fields-dynamically"
  )), values.type === "userNotification" ? /* @__PURE__ */ react_default.createElement(
    UserNotificationSettings,
    {
      setValues,
      values
    }
  ) : /* @__PURE__ */ react_default.createElement(
    EmailNotificationSettings,
    {
      emailNotificationRoles,
      errors,
      learnResources,
      selectedLocale,
      setValues,
      values
    }
  ));
}

// src/main/resources/META-INF/resources/js/components/EditNotificationTemplate.scss
var link3 = document.createElement("link");
link3.setAttribute("rel", "stylesheet");
link3.setAttribute("type", "text/css");
link3.setAttribute(
  "href",
  Liferay.ThemeDisplay.getPathContext() + "/o/notification-web/js/components/EditNotificationTemplate.css"
);
document.querySelector("head").appendChild(link3);

// src/main/resources/META-INF/resources/js/components/EditNotificationTemplate.tsx
var HEADERS2 = new Headers({
  "Accept": "application/json",
  "Content-Type": "application/json"
});
function validate(values) {
  const errors = {};
  if (!values.name) {
    errors.name = object_js_components_web_exports.constantsUtils.REQUIRED_MSG;
  }
  if (!values.subject[defaultLanguageId]) {
    errors.subject = Liferay.Language.get("required");
  }
  if (values.type === "email") {
    const [recipient] = values.recipients;
    if (!recipient.from) {
      errors.from = object_js_components_web_exports.constantsUtils.REQUIRED_MSG;
    }
    if (!recipient.fromName[defaultLanguageId]) {
      errors.fromName = object_js_components_web_exports.constantsUtils.REQUIRED_MSG;
    }
    if (!Array.isArray(recipient.to) && !recipient.to[defaultLanguageId]) {
      errors.to = object_js_components_web_exports.constantsUtils.REQUIRED_MSG;
    }
    if (Liferay.FeatureFlags["LPD-11165"] && Array.isArray(recipient.to) && !recipient.to.length) {
      errors.to = object_js_components_web_exports.constantsUtils.REQUIRED_MSG;
    }
  }
  return errors;
}
function EditNotificationTemplate({
  backURL,
  baseResourceURL,
  editorConfig,
  externalReferenceCode,
  learnResources,
  notificationTemplateId = 0,
  notificationTemplateType,
  portletNamespace
}) {
  notificationTemplateId = Number(notificationTemplateId);
  const [isSubmitted, setIsSubmitted] = (0, react_exports.useState)(false);
  const [objectDefinitions, setObjectDefinitions] = (0, react_exports.useState)([]);
  const [selectedLocale, setSelectedLocale] = (0, react_exports.useState)(
    Liferay.ThemeDisplay.getDefaultLanguageId
  );
  const [templateTitle, setTemplateTitle] = (0, react_exports.useState)("");
  const [emailNotificationRoles, setEmailNotificationRoles] = (0, react_exports.useState)([]);
  const onSubmit = async (notification) => {
    if (isSubmitted) {
      return;
    }
    let notificationValue = { ...notification };
    if (!Liferay.FeatureFlags["LPD-11165"] && notification.type === "email") {
      const recipient = notification.recipients[0];
      let newRecipient = {
        bcc: recipient.bcc,
        cc: recipient.cc,
        from: recipient.from,
        fromName: recipient.fromName,
        singleRecipient: recipient.singleRecipient,
        to: recipient.to
      };
      if (Liferay.FeatureFlags["LPD-21580"]) {
        newRecipient = {
          ...newRecipient,
          usePreferredLocaleForGuestUsers: recipient.usePreferredLocaleForGuestUsers
        };
      }
      notificationValue = {
        ...notification,
        recipients: [newRecipient]
      };
    }
    setIsSubmitted(true);
    const response = await (0, frontend_js_web_exports.fetch)(
      notificationTemplateId !== 0 ? `/o/notification/v1.0/notification-templates/${notificationTemplateId}` : "/o/notification/v1.0/notification-templates",
      {
        body: JSON.stringify(notificationValue),
        headers: HEADERS2,
        method: notificationTemplateId !== 0 ? "PUT" : "POST"
      }
    );
    if (response.ok) {
      (0, object_js_components_web_exports.openToast)({
        message: Liferay.Language.get(
          "notification-template-was-saved-successfully"
        ),
        type: "success"
      });
      window.location.assign(document.referrer);
    } else if (response.status === 400) {
      const { title } = await response.json();
      (0, object_js_components_web_exports.openToast)({
        message: title,
        type: "danger"
      });
    } else {
      (0, object_js_components_web_exports.openToast)({
        message: Liferay.Language.get("an-error-occurred"),
        type: "danger"
      });
    }
  };
  let recipientInitialValue;
  if (notificationTemplateType === "" || notificationTemplateType === "email") {
    let recipient = {
      bcc: "",
      bccType: "email",
      cc: "",
      ccType: "email",
      from: "",
      fromName: {
        [defaultLanguageId]: ""
      },
      singleRecipient: false,
      to: {
        [defaultLanguageId]: ""
      },
      toType: "email"
    };
    if (Liferay.FeatureFlags["LPD-21580"]) {
      recipient = {
        ...recipient,
        usePreferredLocaleForGuestUsers: true
      };
    }
    recipientInitialValue = [recipient];
  } else {
    recipientInitialValue = [];
  }
  const initialValues = {
    attachmentObjectFieldIds: [],
    body: {
      [defaultLanguageId]: ""
    },
    description: "",
    editorType: "richText",
    externalReferenceCode: "",
    name: "",
    objectDefinitionExternalReferenceCode: "",
    objectDefinitionId: 0,
    recipientType: notificationTemplateType === "userNotification" ? "term" : "email",
    recipients: recipientInitialValue,
    subject: {
      [defaultLanguageId]: ""
    },
    system: false,
    type: notificationTemplateType
  };
  const { errors, setValues, validateSubmit, values } = (0, object_js_components_web_exports.useForm)({
    initialValues,
    onSubmit,
    validate
  });
  (0, react_exports.useEffect)(() => {
    const makeFetch = async () => {
      if (notificationTemplateId !== 0) {
        const {
          attachmentObjectFieldIds,
          body,
          description,
          editorType,
          externalReferenceCode: externalReferenceCode2,
          name,
          objectDefinitionExternalReferenceCode,
          objectDefinitionId,
          recipientType,
          recipients,
          subject,
          system,
          type
        } = await object_js_components_web_exports.API.getNotificationTemplateById(
          notificationTemplateId
        );
        setValues({
          ...values,
          attachmentObjectFieldIds,
          body,
          description,
          editorType,
          externalReferenceCode: externalReferenceCode2,
          name,
          objectDefinitionExternalReferenceCode,
          objectDefinitionId,
          recipientType,
          recipients,
          subject,
          system,
          type
        });
        setTemplateTitle(name);
      } else {
        setTemplateTitle(
          Liferay.Language.get("untitled-notification-template")
        );
      }
      if (notificationTemplateType === "" || notificationTemplateType === "email") {
        setEmailNotificationRoles(
          await getEmailNotificationRoles(baseResourceURL)
        );
      }
      const objectDefinitionsItems = await object_js_components_web_exports.API.getObjectDefinitions();
      setObjectDefinitions(objectDefinitionsItems);
    };
    makeFetch();
  }, [notificationTemplateId]);
  return /* @__PURE__ */ react_default.createElement(form_default, null, /* @__PURE__ */ react_default.createElement(
    object_js_components_web_exports.ManagementToolbar,
    {
      backURL,
      badgeClassName: values.type === "email" ? "label-success" : "label-info",
      badgeLabel: values.type === "email" ? Liferay.Language.get("email") : Liferay.Language.get("user-notification"),
      entityId: notificationTemplateId,
      hasPublishPermission: true,
      hasUpdatePermission: true,
      helpMessage: Liferay.Language.get(
        "internal-key-to-reference-the-notification-template"
      ),
      label: templateTitle,
      objectDefinitionExternalReferenceCode: (0, object_js_components_web_exports.invalidateRequired)(values.externalReferenceCode) ? externalReferenceCode : values.externalReferenceCode,
      objectDefinitionExternalReferenceCodeSaveURL: `/o/notification/v1.0/notification-templates/${notificationTemplateId}`,
      onExternalReferenceCodeChange: (value) => {
        setValues({
          externalReferenceCode: value
        });
      },
      onGetEntity: () => object_js_components_web_exports.API.getNotificationTemplateById(notificationTemplateId),
      onSubmit: validateSubmit,
      portletNamespace,
      showEntityDetails: notificationTemplateId !== 0
    }
  ), /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-container" }, /* @__PURE__ */ react_default.createElement("div", { className: "lfr__notification-template-cards" }, /* @__PURE__ */ react_default.createElement(
    "div",
    {
      className: classnames_default(
        {
          row: !(Liferay.FeatureFlags["LPD-11165"] && values.type === "email")
        },
        {
          "lfr__notification-template-basic-info": Liferay.FeatureFlags["LPD-11165"] && values.type === "email"
        }
      )
    },
    /* @__PURE__ */ react_default.createElement(
      "div",
      {
        className: classnames_default(
          {
            "col-lg-6": !(Liferay.FeatureFlags["LPD-11165"] && values.type === "email")
          },
          "lfr__notification-template-card"
        )
      },
      /* @__PURE__ */ react_default.createElement(
        BasicInfoContainer,
        {
          errors,
          setValues,
          values
        }
      )
    ),
    /* @__PURE__ */ react_default.createElement(
      "div",
      {
        className: classnames_default({
          "col-lg-6 lfr__notification-template-card": !(Liferay.FeatureFlags["LPD-11165"] && values.type === "email")
        })
      },
      /* @__PURE__ */ react_default.createElement(
        SettingsContainer,
        {
          emailNotificationRoles,
          errors,
          learnResources,
          selectedLocale,
          setValues,
          values
        }
      )
    )
  ), /* @__PURE__ */ react_default.createElement(
    ContentContainer,
    {
      baseResourceURL,
      editorConfig,
      errors,
      objectDefinitions,
      selectedLocale,
      setSelectedLocale,
      setValues,
      values
    }
  ), /* @__PURE__ */ react_default.createElement(
    DefinitionOfTermsContainer,
    {
      baseResourceURL,
      objectDefinitions
    }
  ))));
}

// src/main/resources/META-INF/resources/js/components/FDSPropsTransformer/NotificationTemplateSourceDataRenderer.tsx
function NotificationTemplateSourceDataRenderer({
  itemData
}) {
  return /* @__PURE__ */ react_default.createElement(
    "strong",
    {
      className: classnames_default(
        itemData.system ? "label-info" : "label-warning",
        "label"
      )
    },
    itemData.system ? Liferay.Language.get("system") : Liferay.Language.get("custom")
  );
}

// src/main/resources/META-INF/resources/js/components/FDSPropsTransformer/NotificationTemplateFDSPropsTransformer.tsx
function propsTransformer2({ ...otherProps }) {
  return {
    ...otherProps,
    customDataRenderers: {
      notificationTemplateSourceDataRenderer: NotificationTemplateSourceDataRenderer
    }
  };
}
export {
  EditNotificationTemplate,
  propsTransformer as NotificationQueueEntryFDSPropsTransformer,
  propsTransformer2 as NotificationTemplateFDSPropsTransformer
};
//# sourceMappingURL=index.js.map
