/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.util;

import com.liferay.oauth.configuration.OAuthConfigurationValues;
import com.liferay.oauth.constants.OAuthConstants;
import com.liferay.oauth.util.DefaultOAuthValidator;
import com.liferay.oauth.util.OAuth;
import com.liferay.oauth.util.OAuthAccessor;
import com.liferay.oauth.util.OAuthConsumer;
import com.liferay.oauth.util.OAuthMessage;
import com.liferay.oauth.util.OAuthValidator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.oauth.OAuthException;
import com.liferay.portal.kernel.service.ServiceContext;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Deprecated
public class OAuthUtil {
    private static String _accessTokenURI;
    private static String _authorizeURI;
    private static OAuth _oAuth;
    private static String _requestTokenURI;

    public static String addParameters(String url, String ... parameters) throws OAuthException {
        return OAuthUtil.getOAuth().addParameters(url, parameters);
    }

    public static void authorize(OAuthAccessor oAuthAccessor, long userId, ServiceContext serviceContext) throws PortalException {
        OAuthUtil.getOAuth().authorize(oAuthAccessor, userId, serviceContext);
    }

    public static void formEncode(String token, String tokenSecret, OutputStream outputStream) throws OAuthException {
        OAuthUtil.getOAuth().formEncode(token, tokenSecret, outputStream);
    }

    public static void generateAccessToken(OAuthAccessor oAuthAccessor, long userId, ServiceContext serviceContext) throws PortalException {
        OAuthUtil.getOAuth().generateAccessToken(oAuthAccessor, userId, serviceContext);
    }

    public static void generateRequestToken(OAuthAccessor oAuthAccessor) {
        OAuthUtil.getOAuth().generateRequestToken(oAuthAccessor);
    }

    public static String getAccessTokenURI() {
        if (_accessTokenURI == null) {
            _accessTokenURI = OAuthUtil._getOAuthURI("access_token");
        }
        return _accessTokenURI;
    }

    public static String getAuthorizeURI() {
        if (_authorizeURI == null) {
            _authorizeURI = OAuthUtil._getOAuthURI("authorize");
        }
        return _authorizeURI;
    }

    public static OAuth getOAuth() {
        if (_oAuth == null) {
            try {
                Class<?> clazz = Class.forName(OAuthConfigurationValues.OAUTH_CLASS_NAME);
                Constructor<?> oauthConstructor = clazz.getConstructor(OAuthValidator.class);
                _oAuth = (OAuth)oauthConstructor.newInstance(new DefaultOAuthValidator());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return _oAuth;
    }

    public static OAuthAccessor getOAuthAccessor(OAuthMessage oAuthMessage) throws PortalException {
        return OAuthUtil.getOAuth().getOAuthAccessor(oAuthMessage);
    }

    public static OAuthConsumer getOAuthConsumer(OAuthMessage oAuthMessage) throws PortalException {
        return OAuthUtil.getOAuth().getOAuthConsumer(oAuthMessage);
    }

    public static OAuthMessage getOAuthMessage(HttpServletRequest httpServletRequest) {
        return OAuthUtil.getOAuth().getOAuthMessage(httpServletRequest);
    }

    public static OAuthMessage getOAuthMessage(HttpServletRequest httpServletRequest, String url) {
        return OAuthUtil.getOAuth().getOAuthMessage(httpServletRequest, url);
    }

    public static OAuthMessage getOAuthMessage(PortletRequest portletRequest) {
        return OAuthUtil.getOAuth().getOAuthMessage(portletRequest);
    }

    public static OAuthMessage getOAuthMessage(PortletRequest portletRequest, String url) {
        return OAuthUtil.getOAuth().getOAuthMessage(portletRequest, url);
    }

    public static String getRequestTokenURI() {
        if (_requestTokenURI == null) {
            _requestTokenURI = OAuthUtil._getOAuthURI("request_token");
        }
        return _requestTokenURI;
    }

    public static void handleException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception, boolean sendBody) throws OAuthException {
        OAuthUtil.getOAuth().handleException(httpServletRequest, httpServletResponse, exception, sendBody);
    }

    public static String randomizeToken(String token) {
        return OAuthUtil.getOAuth().randomizeToken(token);
    }

    public static void validateOAuthMessage(OAuthMessage message, OAuthAccessor oAuthAccessor) throws OAuthException {
        OAuthUtil.getOAuth().validateOAuthMessage(message, oAuthAccessor);
    }

    private static String _getOAuthURI(String uriSuffix) {
        String oauthPublicPath = null;
        for (String publicPath : OAuthConstants.PUBLIC_PATHS) {
            if (!publicPath.endsWith(uriSuffix)) continue;
            oauthPublicPath = publicPath;
            break;
        }
        oauthPublicPath = oauthPublicPath != null ? "/c" + oauthPublicPath : "";
        return oauthPublicPath;
    }
}

