/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.URI;
import java.net.URISyntaxException;

public class WebServerUtil {
    public static String getWebServerURL(StringBuffer requestURL) throws URISyntaxException {
        int webServerHttpPort = GetterUtil.getInteger((String)PropsUtil.get((String)"web.server.http.port"));
        int webServerHttpsPort = GetterUtil.getInteger((String)PropsUtil.get((String)"web.server.https.port"));
        if (webServerHttpPort == -1 && webServerHttpsPort == -1) {
            return null;
        }
        int webServerPort = webServerHttpPort;
        String webServerProtocol = PropsUtil.get((String)"web.server.protocol");
        if (Validator.isNull((String)webServerProtocol)) {
            if (webServerHttpPort != -1) {
                webServerProtocol = "http";
            } else {
                return null;
            }
        }
        if (StringUtil.equalsIgnoreCase((String)webServerProtocol, (String)"https")) {
            if (webServerHttpsPort != -1) {
                webServerPort = webServerHttpsPort;
            } else {
                return null;
            }
        }
        StringBundler sb = new StringBundler(7);
        sb.append(webServerProtocol);
        sb.append(":");
        sb.append("//");
        URI uri = new URI(requestURL.toString());
        sb.append(WebServerUtil._getAuthority(uri));
        if (webServerProtocol.equals("http") && webServerPort != 80 || webServerProtocol.equals("https") && webServerPort != 443) {
            sb.append(":");
            sb.append(webServerPort);
        }
        sb.append(WebServerUtil._getPath(uri));
        return sb.toString();
    }

    private static String _getAuthority(URI uri) {
        String authority = StringUtil.toLowerCase((String)uri.getAuthority());
        int index = authority.lastIndexOf(":");
        if (index >= 0) {
            authority = authority.substring(0, index);
        }
        return authority;
    }

    private static String _getPath(URI uri) {
        String path = uri.getRawPath();
        if (path == null || path.length() == 0) {
            path = "/";
        }
        return path;
    }
}

