/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.upgrade;

import com.liferay.oauth2.provider.internal.upgrade.v1_1_0.UpgradeOAuth2ScopeGrant;
import com.liferay.oauth2.provider.internal.upgrade.v1_2_0.util.OAuth2AuthorizationTable;
import com.liferay.oauth2.provider.internal.upgrade.v2_0_0.UpgradeOAuth2ApplicationScopeAliases;
import com.liferay.oauth2.provider.internal.upgrade.v2_0_0.util.OAuth2ApplicationScopeAliasesTable;
import com.liferay.oauth2.provider.internal.upgrade.v2_0_0.util.OAuth2ScopeGrantTable;
import com.liferay.oauth2.provider.scope.liferay.ScopeLocator;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import java.util.Arrays;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UpgradeStepRegistrator.class})
public class OAuth2ServiceUpgrade
implements UpgradeStepRegistrator {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ScopeLocator _scopeLocator;

    public void register(UpgradeStepRegistrator.Registry registry) {
        registry.register("1.0.0", "1.1.0", new UpgradeStep[]{new UpgradeOAuth2ScopeGrant()});
        registry.register("1.1.0", "1.2.0", new UpgradeStep[]{this.getAddColumnsUpgradeProcess(OAuth2AuthorizationTable.class, "remoteHostInfo VARCHAR(255) null")});
        registry.register("1.2.0", "1.3.0", new UpgradeStep[]{this.getAddColumnsUpgradeProcess(OAuth2ScopeGrantTable.class, "scopeAliases TEXT null")});
        registry.register("1.3.0", "2.0.0", new UpgradeStep[]{new UpgradeOAuth2ApplicationScopeAliases(this._companyLocalService, this._scopeLocator), this.getDropColumnsUpgradeProcess(OAuth2ApplicationScopeAliasesTable.class, "scopeAliases", "scopeAliasesHash")});
    }

    protected UpgradeProcess getAddColumnsUpgradeProcess(final Class<?> tableClass, final String ... columnDefinitions) {
        return new UpgradeProcess(){

            protected void doUpgrade() throws Exception {
                this.alter(tableClass, OAuth2ServiceUpgrade.this._getAlterables(x$0 -> new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, x$0), columnDefinitions));
            }
        };
    }

    protected UpgradeProcess getDropColumnsUpgradeProcess(final Class<?> tableClass, final String ... tableNames) {
        return new UpgradeProcess(){

            protected void doUpgrade() throws Exception {
                this.alter(tableClass, OAuth2ServiceUpgrade.this._getAlterables(x$0 -> new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, x$0), tableNames));
            }
        };
    }

    private UpgradeProcess.Alterable[] _getAlterables(Function<String, UpgradeProcess.Alterable> alterableFunction, String ... alterableStrings) {
        return (UpgradeProcess.Alterable[])Arrays.stream(alterableStrings).map(alterableFunction).toArray(UpgradeProcess.Alterable[]::new);
    }
}

