/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.exception.DuplicateOAuth2ApplicationClientIdException;
import com.liferay.oauth2.provider.exception.NoSuchOAuth2ApplicationException;
import com.liferay.oauth2.provider.exception.OAuth2ApplicationClientGrantTypeException;
import com.liferay.oauth2.provider.exception.OAuth2ApplicationHomePageURLException;
import com.liferay.oauth2.provider.exception.OAuth2ApplicationHomePageURLSchemeException;
import com.liferay.oauth2.provider.exception.OAuth2ApplicationNameException;
import com.liferay.oauth2.provider.exception.OAuth2ApplicationPrivacyPolicyURLException;
import com.liferay.oauth2.provider.exception.OAuth2ApplicationPrivacyPolicyURLSchemeException;
import com.liferay.oauth2.provider.exception.OAuth2ApplicationRedirectURIException;
import com.liferay.oauth2.provider.exception.OAuth2ApplicationRedirectURIFragmentException;
import com.liferay.oauth2.provider.exception.OAuth2ApplicationRedirectURIMissingException;
import com.liferay.oauth2.provider.exception.OAuth2ApplicationRedirectURIPathException;
import com.liferay.oauth2.provider.exception.OAuth2ApplicationRedirectURISchemeException;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2ApplicationScopeAliases;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.service.OAuth2ApplicationScopeAliasesLocalService;
import com.liferay.oauth2.provider.service.OAuth2AuthorizationLocalService;
import com.liferay.oauth2.provider.service.base.OAuth2ApplicationLocalServiceBaseImpl;
import com.liferay.oauth2.provider.util.OAuth2SecureRandomGenerator;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.ImageTypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.oauth2.provider.model.OAuth2Application"}, service={AopService.class})
public class OAuth2ApplicationLocalServiceImpl
extends OAuth2ApplicationLocalServiceBaseImpl {
    private static Set<String> _ianaRegisteredUriSchemes = SetUtil.fromArray((Object[])new String[]{"aaa", "aaas", "about", "acap", "acct", "acr", "adiumxtra", "afp", "afs", "aim", "appdata", "apt", "attachment", "aw", "barion", "beshare", "bitcoin", "blob", "bolo", "browserext", "callto", "cap", "chrome", "chrome-extension", "cid", "coap", "coap+tcp", "coap+ws", "coaps", "coaps+tcp", "coaps+ws", "com-eventbrite-attendee", "content", "conti", "crid", "cvs", "data", "dav", "diaspora", "dict", "dis", "dlna-playcontainer", "dlna-playsingle", "dns", "dntp", "dtn", "dvb", "ed2k", "example", "facetime", "fax", "feed", "feedready", "file", "filesystem", "finger", "fish", "ftp", "geo", "gg", "git", "gizmoproject", "go", "gopher", "graph", "gtalk", "h323", "ham", "hcp", "http", "https", "hxxp", "hxxps", "hydrazone", "iax", "icap", "icon", "im", "imap", "info", "iotdisco", "ipn", "ipp", "ipps", "irc", "irc6", "ircs", "iris", "iris.beep", "iris.lwz", "iris.xpc", "iris.xpcs", "isostore", "itms", "jabber", "jar", "jms", "keyparc", "lastfm", "ldap", "ldaps", "lvlt", "magnet", "mailserver", "mailto", "maps", "market", "message", "mid", "mms", "modem", "mongodb", "moz", "ms-access", "ms-browser-extension", "ms-drive-to", "ms-enrollment", "ms-excel", "ms-gamebarservices", "ms-gamingoverlay", "ms-getoffice", "ms-help", "ms-infopath", "ms-inputapp", "ms-lockscreencomponent-config", "ms-media-stream-id", "ms-mixedrealitycapture", "ms-officeapp", "ms-people", "ms-project", "ms-powerpoint", "ms-publisher", "ms-restoretabcompanion", "ms-search-repair", "ms-secondary-screen-controller", "ms-secondary-screen-setup", "ms-settings", "ms-settings-airplanemode", "ms-settings-bluetooth", "ms-settings-camera", "ms-settings-cellular", "ms-settings-cloudstorage", "ms-settings-connectabledevices", "ms-settings-displays-topology", "ms-settings-emailandaccounts", "ms-settings-language", "ms-settings-location", "ms-settings-lock", "ms-settings-nfctransactions", "ms-settings-notifications", "ms-settings-power", "ms-settings-privacy", "ms-settings-proximity", "ms-settings-screenrotation", "ms-settings-wifi", "ms-settings-workplace", "ms-spd", "ms-sttoverlay", "ms-transit-to", "ms-useractivityset", "ms-virtualtouchpad", "ms-visio", "ms-walk-to", "ms-whiteboard", "ms-whiteboard-cmd", "ms-word", "msnim", "msrp", "msrps", "mtqp", "mumble", "mupdate", "mvn", "news", "nfs", "ni", "nih", "nntp", "notes", "ocf", "oid", "onenote", "onenote-cmd", "opaquelocktoken", "pack", "palm", "paparazzi", "pkcs11", "platform", "pop", "pres", "prospero", "proxy", "pwid", "psyc", "qb", "query", "redis", "rediss", "reload", "res", "resource", "rmi", "rsync", "rtmfp", "rtmp", "rtsp", "rtsps", "rtspu", "secondlife", "service", "session", "sftp", "sgn", "shttp", "sieve", "sip", "sips", "skype", "smb", "sms", "smtp", "snews", "snmp", "soap.beep", "soap.beeps", "soldat", "spiffe", "spotify", "ssh", "steam", "stun", "stuns", "submit", "svn", "tag", "teamspeak", "tel", "teliaeid", "telnet", "tftp", "things", "thismessage", "tip", "tn3270", "tool", "turn", "turns", "tv", "udp", "unreal", "urn", "ut2004", "v-event", "vemmi", "ventrilo", "videotex", "vnc", "view-source", "wais", "webcal", "wpid", "ws", "wss", "wtai", "wyciwyg", "xcon", "xcon-userid", "xfire", "xmlrpc.beep", "xmlrpc.beeps", "xmpp", "xri", "ymsgr", "z39.50", "z39.50r", "z39.50s"});
    @Reference
    private Http _http;
    @Reference(target="(indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry)")
    private Indexer<DLFileEntry> _indexer;
    @Reference
    private OAuth2ApplicationScopeAliasesLocalService _oAuth2ApplicationScopeAliasesLocalService;
    @Reference
    private OAuth2AuthorizationLocalService _oAuth2AuthorizationLocalService;
    @Reference(target="(class.name=com.liferay.portal.repository.portletrepository.PortletRepository)")
    private RepositoryFactory _repositoryFactory;
    @Reference(target="(current.store=true)")
    private Store _store;

    @Activate
    public void activate() {
        String ianaRegisteredSchemes = PropsUtil.get((String)"iana.registered.uri.schemes");
        if (!Validator.isBlank((String)ianaRegisteredSchemes)) {
            _ianaRegisteredUriSchemes = new HashSet<String>(Arrays.asList(StringUtil.split((String)ianaRegisteredSchemes)));
        }
    }

    public OAuth2Application addOAuth2Application(long companyId, long userId, String userName, List<GrantType> allowedGrantTypesList, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String name, String privacyPolicyURL, List<String> redirectURIsList, List<String> scopeAliasesList, ServiceContext serviceContext) throws PortalException {
        if (allowedGrantTypesList == null) {
            allowedGrantTypesList = new ArrayList<GrantType>();
        }
        clientId = Validator.isBlank((String)clientId) ? OAuth2SecureRandomGenerator.generateClientId() : StringUtil.trim((String)clientId);
        homePageURL = StringUtil.trim((String)homePageURL);
        name = StringUtil.trim((String)name);
        privacyPolicyURL = StringUtil.trim((String)privacyPolicyURL);
        if (redirectURIsList == null) {
            redirectURIsList = new ArrayList<String>();
        }
        if (scopeAliasesList == null) {
            scopeAliasesList = new ArrayList<String>();
        }
        this.validate(companyId, allowedGrantTypesList, clientId, clientProfile, clientSecret, homePageURL, name, privacyPolicyURL, redirectURIsList);
        long oAuth2ApplicationId = this.counterLocalService.increment(OAuth2Application.class.getName());
        OAuth2Application oAuth2Application = this.oAuth2ApplicationPersistence.create(oAuth2ApplicationId);
        oAuth2Application.setCompanyId(companyId);
        oAuth2Application.setUserId(userId);
        oAuth2Application.setUserName(userName);
        oAuth2Application.setCreateDate(new Date());
        oAuth2Application.setModifiedDate(new Date());
        oAuth2Application.setAllowedGrantTypesList(allowedGrantTypesList);
        oAuth2Application.setClientId(clientId);
        oAuth2Application.setClientProfile(clientProfile);
        oAuth2Application.setClientSecret(clientSecret);
        oAuth2Application.setDescription(description);
        oAuth2Application.setFeaturesList(featuresList);
        oAuth2Application.setHomePageURL(homePageURL);
        oAuth2Application.setIconFileEntryId(iconFileEntryId);
        oAuth2Application.setName(name);
        oAuth2Application.setPrivacyPolicyURL(privacyPolicyURL);
        oAuth2Application.setRedirectURIsList(redirectURIsList);
        if (ListUtil.isNotEmpty(scopeAliasesList)) {
            OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases = this._oAuth2ApplicationScopeAliasesLocalService.addOAuth2ApplicationScopeAliases(companyId, userId, userName, oAuth2ApplicationId, scopeAliasesList);
            oAuth2Application.setOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliases.getOAuth2ApplicationScopeAliasesId());
        }
        this.resourceLocalService.addResources(oAuth2Application.getCompanyId(), 0L, oAuth2Application.getUserId(), OAuth2Application.class.getName(), oAuth2Application.getOAuth2ApplicationId(), false, false, false);
        return (OAuth2Application)this.oAuth2ApplicationPersistence.update((BaseModel)oAuth2Application);
    }

    @Override
    public OAuth2Application deleteOAuth2Application(long oAuth2ApplicationId) throws PortalException {
        List oAuth2Authorizations = this._oAuth2AuthorizationLocalService.getOAuth2Authorizations(oAuth2ApplicationId, -1, -1, null);
        for (OAuth2Authorization oAuth2Authorization : oAuth2Authorizations) {
            this._oAuth2AuthorizationLocalService.deleteOAuth2Authorization(oAuth2Authorization.getOAuth2AuthorizationId());
        }
        List oAuth2ApplicationScopeAliaseses = this._oAuth2ApplicationScopeAliasesLocalService.getOAuth2ApplicationScopeAliaseses(oAuth2ApplicationId, -1, -1, null);
        for (OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases : oAuth2ApplicationScopeAliaseses) {
            this._oAuth2ApplicationScopeAliasesLocalService.deleteOAuth2ApplicationScopeAliases(oAuth2ApplicationScopeAliases.getOAuth2ApplicationScopeAliasesId());
        }
        return this.oAuth2ApplicationPersistence.remove(oAuth2ApplicationId);
    }

    public void deleteOAuth2Applications(long companyId) throws PortalException {
        for (OAuth2Application oAuth2Application : this.oAuth2ApplicationPersistence.findByC(companyId)) {
            this.deleteOAuth2Application(oAuth2Application.getOAuth2ApplicationId());
        }
    }

    public OAuth2Application fetchOAuth2Application(long companyId, String clientId) {
        return this.oAuth2ApplicationPersistence.fetchByC_C(companyId, clientId);
    }

    public OAuth2Application getOAuth2Application(long companyId, String clientId) throws NoSuchOAuth2ApplicationException {
        return this.oAuth2ApplicationPersistence.findByC_C(companyId, clientId);
    }

    public List<OAuth2Application> getOAuth2Applications(long companyId) {
        return this.oAuth2ApplicationPersistence.findByC(companyId);
    }

    public OAuth2Application updateIcon(long oAuth2ApplicationId, InputStream inputStream) throws PortalException {
        OAuth2Application oAuth2Application = this.getOAuth2Application(oAuth2ApplicationId);
        long oldIconFileEntryId = oAuth2Application.getIconFileEntryId();
        if (inputStream == null) {
            if (oldIconFileEntryId > 0L) {
                PortletFileRepositoryUtil.deletePortletFileEntry((long)oldIconFileEntryId);
                oAuth2Application.setIconFileEntryId(-1L);
                oAuth2Application = this.updateOAuth2Application(oAuth2Application);
            }
            return oAuth2Application;
        }
        Group group = this.groupLocalService.getCompanyGroup(oAuth2Application.getCompanyId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)group.getGroupId(), (String)"com.liferay.oauth2.provider", (ServiceContext)serviceContext);
        Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)this.userLocalService.getDefaultUserId(oAuth2Application.getCompanyId()), (long)repository.getRepositoryId(), (long)0L, (String)"icons", (ServiceContext)serviceContext);
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try {
            ImageBag imageBag = ImageToolUtil.read((InputStream)inputStream);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            if (renderedImage == null) {
                throw new ImageTypeException("Unable to read icon");
            }
            renderedImage = ImageToolUtil.scale((RenderedImage)renderedImage, (int)160, (int)160);
            ImageToolUtil.write((RenderedImage)renderedImage, (String)imageBag.getType(), (OutputStream)unsyncByteArrayOutputStream);
        }
        catch (IOException ioe) {
            throw new PortalException((Throwable)ioe);
        }
        String fileName = PortletFileRepositoryUtil.getUniqueFileName((long)group.getGroupId(), (long)folder.getFolderId(), (String)oAuth2Application.getClientId());
        FileEntry fileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)group.getGroupId(), (long)oAuth2Application.getUserId(), (String)OAuth2Application.class.getName(), (long)oAuth2Application.getOAuth2ApplicationId(), (String)"com.liferay.oauth2.provider", (long)folder.getFolderId(), (InputStream)new UnsyncByteArrayInputStream(unsyncByteArrayOutputStream.toByteArray()), (String)fileName, null, (boolean)false);
        oAuth2Application.setIconFileEntryId(fileEntry.getFileEntryId());
        oAuth2Application = this.updateOAuth2Application(oAuth2Application);
        if (oldIconFileEntryId > 0L) {
            PortletFileRepositoryUtil.deletePortletFileEntry((long)oldIconFileEntryId);
        }
        return oAuth2Application;
    }

    public OAuth2Application updateOAuth2Application(long oAuth2ApplicationId, List<GrantType> allowedGrantTypesList, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String name, String privacyPolicyURL, List<String> redirectURIsList, long auth2ApplicationScopeAliasesId, ServiceContext serviceContext) throws PortalException {
        OAuth2Application oAuth2Application = this.oAuth2ApplicationPersistence.findByPrimaryKey(oAuth2ApplicationId);
        clientId = StringUtil.trim((String)clientId);
        homePageURL = StringUtil.trim((String)homePageURL);
        name = StringUtil.trim((String)name);
        privacyPolicyURL = StringUtil.trim((String)privacyPolicyURL);
        if (redirectURIsList == null) {
            redirectURIsList = new ArrayList<String>();
        }
        this.validate(oAuth2Application.getCompanyId(), oAuth2ApplicationId, allowedGrantTypesList, clientId, clientProfile, clientSecret, homePageURL, name, privacyPolicyURL, redirectURIsList);
        oAuth2Application.setModifiedDate(new Date());
        oAuth2Application.setOAuth2ApplicationScopeAliasesId(auth2ApplicationScopeAliasesId);
        oAuth2Application.setAllowedGrantTypesList(allowedGrantTypesList);
        oAuth2Application.setClientId(clientId);
        oAuth2Application.setClientProfile(clientProfile);
        oAuth2Application.setClientSecret(clientSecret);
        oAuth2Application.setDescription(description);
        oAuth2Application.setFeaturesList(featuresList);
        oAuth2Application.setHomePageURL(homePageURL);
        oAuth2Application.setIconFileEntryId(iconFileEntryId);
        oAuth2Application.setName(name);
        oAuth2Application.setPrivacyPolicyURL(privacyPolicyURL);
        oAuth2Application.setRedirectURIsList(redirectURIsList);
        return (OAuth2Application)this.oAuth2ApplicationPersistence.update((BaseModel)oAuth2Application);
    }

    public OAuth2Application updateScopeAliases(long userId, String userName, long oAuth2ApplicationId, List<String> scopeAliasesList) throws PortalException {
        OAuth2Application oAuth2Application = this.oAuth2ApplicationPersistence.findByPrimaryKey(oAuth2ApplicationId);
        if (ListUtil.isEmpty(scopeAliasesList)) {
            if (oAuth2Application.getOAuth2ApplicationScopeAliasesId() == 0L) {
                return oAuth2Application;
            }
            oAuth2Application.setModifiedDate(new Date());
            oAuth2Application.setOAuth2ApplicationScopeAliasesId(0L);
            return (OAuth2Application)this.oAuth2ApplicationPersistence.update((BaseModel)oAuth2Application);
        }
        OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases = this._oAuth2ApplicationScopeAliasesLocalService.fetchOAuth2ApplicationScopeAliases(oAuth2ApplicationId, scopeAliasesList);
        if (oAuth2ApplicationScopeAliases != null) {
            oAuth2ApplicationScopeAliases.setUserId(userId);
            oAuth2ApplicationScopeAliases.setUserName(userName);
            oAuth2ApplicationScopeAliases = this._oAuth2ApplicationScopeAliasesLocalService.updateOAuth2ApplicationScopeAliases(oAuth2ApplicationScopeAliases);
        } else {
            oAuth2ApplicationScopeAliases = this._oAuth2ApplicationScopeAliasesLocalService.addOAuth2ApplicationScopeAliases(oAuth2Application.getCompanyId(), userId, userName, oAuth2ApplicationId, scopeAliasesList);
        }
        if (oAuth2Application.getOAuth2ApplicationScopeAliasesId() != oAuth2ApplicationScopeAliases.getOAuth2ApplicationScopeAliasesId()) {
            oAuth2Application.setModifiedDate(new Date());
            oAuth2Application.setOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliases.getOAuth2ApplicationScopeAliasesId());
            return (OAuth2Application)this.oAuth2ApplicationPersistence.update((BaseModel)oAuth2Application);
        }
        return oAuth2Application;
    }

    protected void validate(long companyId, List<GrantType> allowedGrantTypesList, String clientId, int clientProfile, String clientSecret, String homePageURL, String name, String privacyPolicyURL, List<String> redirectURIsList) throws PortalException {
        this.validate(companyId, 0L, allowedGrantTypesList, clientId, clientProfile, clientSecret, homePageURL, name, privacyPolicyURL, redirectURIsList);
    }

    protected void validate(long companyId, long oAuth2ApplicationId, List<GrantType> allowedGrantTypesList, String clientId, int clientProfile, String clientSecret, String homePageURL, String name, String privacyPolicyURL, List<String> redirectURIsList) throws PortalException {
        OAuth2Application existingOAuth2Application;
        if (!Validator.isBlank((String)clientSecret)) {
            for (GrantType grantType : allowedGrantTypesList) {
                if (grantType.isSupportsConfidentialClients()) continue;
                throw new OAuth2ApplicationClientGrantTypeException(grantType.name());
            }
        } else {
            for (GrantType grantType : allowedGrantTypesList) {
                if (grantType.isSupportsPublicClients()) continue;
                throw new OAuth2ApplicationClientGrantTypeException(grantType.name());
            }
        }
        if (!Validator.isBlank((String)clientId) && (existingOAuth2Application = this.oAuth2ApplicationPersistence.fetchByC_C(companyId, clientId)) != null && existingOAuth2Application.getOAuth2ApplicationId() != oAuth2ApplicationId) {
            throw new DuplicateOAuth2ApplicationClientIdException();
        }
        if (!Validator.isBlank((String)homePageURL)) {
            if (!StringUtil.startsWith((String)homePageURL, (String)"http://") && !StringUtil.startsWith((String)homePageURL, (String)"https://")) {
                throw new OAuth2ApplicationHomePageURLSchemeException();
            }
            if (!Validator.isUri((String)homePageURL)) {
                throw new OAuth2ApplicationHomePageURLException();
            }
        }
        if (Validator.isBlank((String)name)) {
            throw new OAuth2ApplicationNameException();
        }
        if (!Validator.isBlank((String)privacyPolicyURL)) {
            if (!StringUtil.startsWith((String)privacyPolicyURL, (String)"http://") && !StringUtil.startsWith((String)privacyPolicyURL, (String)"https://")) {
                throw new OAuth2ApplicationPrivacyPolicyURLSchemeException();
            }
            if (!Validator.isUri((String)privacyPolicyURL)) {
                throw new OAuth2ApplicationPrivacyPolicyURLException();
            }
        }
        if (redirectURIsList.isEmpty()) {
            for (GrantType grantType : allowedGrantTypesList) {
                if (!grantType.isRequiresRedirectURI()) continue;
                throw new OAuth2ApplicationRedirectURIMissingException(grantType.name());
            }
        }
        for (String redirectURI : redirectURIsList) {
            try {
                String normalizedPath;
                URI uri = new URI(redirectURI);
                if (uri.getFragment() != null) {
                    throw new OAuth2ApplicationRedirectURIFragmentException(redirectURI);
                }
                String scheme = uri.getScheme();
                if (scheme == null) {
                    throw new OAuth2ApplicationRedirectURISchemeException(redirectURI);
                }
                if (!Objects.equals(scheme = StringUtil.toLowerCase((String)scheme), "http") && !Objects.equals(scheme, "https") && _ianaRegisteredUriSchemes.contains(scheme)) {
                    throw new OAuth2ApplicationHomePageURLSchemeException(redirectURI);
                }
                String path = uri.getPath();
                if (Objects.equals(path, normalizedPath = this._http.normalizePath(path))) continue;
                throw new OAuth2ApplicationRedirectURIPathException(redirectURI);
            }
            catch (URISyntaxException urise) {
                throw new OAuth2ApplicationRedirectURIException(redirectURI, (Throwable)urise);
            }
        }
    }
}

