/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.impl;

import com.liferay.oauth2.provider.exception.NoSuchOAuth2AuthorizationException;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.service.base.OAuth2AuthorizationLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.oauth2.provider.model.OAuth2Authorization"}, service={AopService.class})
public class OAuth2AuthorizationLocalServiceImpl
extends OAuth2AuthorizationLocalServiceBaseImpl {
    @Deprecated
    public OAuth2Authorization addOAuth2Authorization(long companyId, long userId, String userName, long oAuth2ApplicationId, long oAuth2ApplicationScopeAliasesId, String accessTokenContent, Date accessTokenCreateDate, Date accessTokenExpirationDate, String remoteIPInfo, String refreshTokenContent, Date refreshTokenCreateDate, Date refreshTokenExpirationDate) {
        return this.addOAuth2Authorization(companyId, userId, userName, oAuth2ApplicationId, oAuth2ApplicationScopeAliasesId, accessTokenContent, accessTokenCreateDate, accessTokenExpirationDate, null, remoteIPInfo, refreshTokenContent, refreshTokenCreateDate, refreshTokenExpirationDate);
    }

    public OAuth2Authorization addOAuth2Authorization(long companyId, long userId, String userName, long oAuth2ApplicationId, long oAuth2ApplicationScopeAliasesId, String accessTokenContent, Date accessTokenCreateDate, Date accessTokenExpirationDate, String remoteHostInfo, String remoteIPInfo, String refreshTokenContent, Date refreshTokenCreateDate, Date refreshTokenExpirationDate) {
        long oAuth2AuthorizationId = this.counterLocalService.increment(OAuth2Authorization.class.getName());
        OAuth2Authorization oAuth2Authorization = this.createOAuth2Authorization(oAuth2AuthorizationId);
        oAuth2Authorization.setCompanyId(companyId);
        oAuth2Authorization.setUserId(userId);
        oAuth2Authorization.setUserName(userName);
        oAuth2Authorization.setCreateDate(new Date());
        oAuth2Authorization.setOAuth2ApplicationId(oAuth2ApplicationId);
        oAuth2Authorization.setOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId);
        oAuth2Authorization.setAccessTokenContent(accessTokenContent);
        oAuth2Authorization.setAccessTokenCreateDate(accessTokenCreateDate);
        oAuth2Authorization.setAccessTokenExpirationDate(accessTokenExpirationDate);
        oAuth2Authorization.setRemoteHostInfo(remoteHostInfo);
        oAuth2Authorization.setRemoteIPInfo(remoteIPInfo);
        oAuth2Authorization.setRefreshTokenContent(refreshTokenContent);
        oAuth2Authorization.setRefreshTokenCreateDate(refreshTokenCreateDate);
        oAuth2Authorization.setRefreshTokenExpirationDate(refreshTokenExpirationDate);
        return (OAuth2Authorization)this.oAuth2AuthorizationPersistence.update((BaseModel)oAuth2Authorization);
    }

    @Override
    public OAuth2Authorization deleteOAuth2Authorization(long oAuth2AuthorizationId) throws PortalException {
        Collection oAuth2ScopeGrants = this.oAuth2AuthorizationLocalService.getOAuth2ScopeGrants(oAuth2AuthorizationId);
        for (OAuth2ScopeGrant oAuth2ScopeGrant : oAuth2ScopeGrants) {
            this.oAuth2ScopeGrantPersistence.remove((BaseModel)oAuth2ScopeGrant);
        }
        return this.oAuth2AuthorizationPersistence.remove(oAuth2AuthorizationId);
    }

    public OAuth2Authorization fetchOAuth2AuthorizationByAccessTokenContent(String accessTokenContent) {
        List oAuth2Authorizations = this.oAuth2AuthorizationPersistence.findByAccessTokenContentHash((long)accessTokenContent.hashCode());
        for (OAuth2Authorization oAuth2Authorization : oAuth2Authorizations) {
            if (!accessTokenContent.equals(oAuth2Authorization.getAccessTokenContent())) continue;
            return oAuth2Authorization;
        }
        return null;
    }

    public OAuth2Authorization fetchOAuth2AuthorizationByRefreshTokenContent(String refreshTokenContent) {
        List oAuth2Authorizations = this.oAuth2AuthorizationPersistence.findByRefreshTokenContentHash((long)refreshTokenContent.hashCode());
        for (OAuth2Authorization oAuth2Authorization : oAuth2Authorizations) {
            if (!refreshTokenContent.equals(oAuth2Authorization.getRefreshTokenContent())) continue;
            return oAuth2Authorization;
        }
        return null;
    }

    public OAuth2Authorization getOAuth2AuthorizationByAccessTokenContent(String accessTokenContent) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchOAuth2AuthorizationByAccessTokenContent(accessTokenContent);
        if (oAuth2Authorization == null) {
            throw new NoSuchOAuth2AuthorizationException("No OAuth2 authorization exists with access token content " + accessTokenContent);
        }
        return oAuth2Authorization;
    }

    public OAuth2Authorization getOAuth2AuthorizationByRefreshTokenContent(String refreshTokenContent) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchOAuth2AuthorizationByRefreshTokenContent(refreshTokenContent);
        if (oAuth2Authorization == null) {
            throw new NoSuchOAuth2AuthorizationException("No OAuth2 authorization exists with refresh token content " + refreshTokenContent);
        }
        return oAuth2Authorization;
    }

    public List<OAuth2Authorization> getOAuth2Authorizations(long oAuth2ApplicationId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.oAuth2AuthorizationPersistence.findByOAuth2ApplicationId(oAuth2ApplicationId, start, end, orderByComparator);
    }

    public int getOAuth2AuthorizationsCount(long oAuth2ApplicationId) {
        return this.oAuth2AuthorizationPersistence.countByOAuth2ApplicationId(oAuth2ApplicationId);
    }

    public Collection<OAuth2ScopeGrant> getOAuth2ScopeGrants(long oAuth2AuthorizationId) {
        return this.oAuth2ScopeGrantPersistence.getOAuth2AuthorizationOAuth2ScopeGrants(oAuth2AuthorizationId);
    }

    public List<OAuth2Authorization> getUserOAuth2Authorizations(long userId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.oAuth2AuthorizationPersistence.findByUserId(userId, start, end, orderByComparator);
    }

    public int getUserOAuth2AuthorizationsCount(long userId) {
        return this.oAuth2AuthorizationPersistence.countByUserId(userId);
    }
}

