/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.model.impl;

import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.model.impl.OAuth2AuthorizationImpl;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.CacheModel;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;

public class OAuth2AuthorizationCacheModel
implements CacheModel<OAuth2Authorization>,
Externalizable {
    public long oAuth2AuthorizationId;
    public long companyId;
    public long userId;
    public String userName;
    public long createDate;
    public long oAuth2ApplicationId;
    public long oAuth2ApplicationScopeAliasesId;
    public String accessTokenContent;
    public long accessTokenContentHash;
    public long accessTokenCreateDate;
    public long accessTokenExpirationDate;
    public String remoteHostInfo;
    public String remoteIPInfo;
    public String refreshTokenContent;
    public long refreshTokenContentHash;
    public long refreshTokenCreateDate;
    public long refreshTokenExpirationDate;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OAuth2AuthorizationCacheModel)) {
            return false;
        }
        OAuth2AuthorizationCacheModel oAuth2AuthorizationCacheModel = (OAuth2AuthorizationCacheModel)obj;
        return this.oAuth2AuthorizationId == oAuth2AuthorizationCacheModel.oAuth2AuthorizationId;
    }

    public int hashCode() {
        return HashUtil.hash((int)0, (long)this.oAuth2AuthorizationId);
    }

    public String toString() {
        StringBundler sb = new StringBundler(35);
        sb.append("{oAuth2AuthorizationId=");
        sb.append(this.oAuth2AuthorizationId);
        sb.append(", companyId=");
        sb.append(this.companyId);
        sb.append(", userId=");
        sb.append(this.userId);
        sb.append(", userName=");
        sb.append(this.userName);
        sb.append(", createDate=");
        sb.append(this.createDate);
        sb.append(", oAuth2ApplicationId=");
        sb.append(this.oAuth2ApplicationId);
        sb.append(", oAuth2ApplicationScopeAliasesId=");
        sb.append(this.oAuth2ApplicationScopeAliasesId);
        sb.append(", accessTokenContent=");
        sb.append(this.accessTokenContent);
        sb.append(", accessTokenContentHash=");
        sb.append(this.accessTokenContentHash);
        sb.append(", accessTokenCreateDate=");
        sb.append(this.accessTokenCreateDate);
        sb.append(", accessTokenExpirationDate=");
        sb.append(this.accessTokenExpirationDate);
        sb.append(", remoteHostInfo=");
        sb.append(this.remoteHostInfo);
        sb.append(", remoteIPInfo=");
        sb.append(this.remoteIPInfo);
        sb.append(", refreshTokenContent=");
        sb.append(this.refreshTokenContent);
        sb.append(", refreshTokenContentHash=");
        sb.append(this.refreshTokenContentHash);
        sb.append(", refreshTokenCreateDate=");
        sb.append(this.refreshTokenCreateDate);
        sb.append(", refreshTokenExpirationDate=");
        sb.append(this.refreshTokenExpirationDate);
        sb.append("}");
        return sb.toString();
    }

    public OAuth2Authorization toEntityModel() {
        OAuth2AuthorizationImpl oAuth2AuthorizationImpl = new OAuth2AuthorizationImpl();
        oAuth2AuthorizationImpl.setOAuth2AuthorizationId(this.oAuth2AuthorizationId);
        oAuth2AuthorizationImpl.setCompanyId(this.companyId);
        oAuth2AuthorizationImpl.setUserId(this.userId);
        if (this.userName == null) {
            oAuth2AuthorizationImpl.setUserName("");
        } else {
            oAuth2AuthorizationImpl.setUserName(this.userName);
        }
        if (this.createDate == Long.MIN_VALUE) {
            oAuth2AuthorizationImpl.setCreateDate(null);
        } else {
            oAuth2AuthorizationImpl.setCreateDate(new Date(this.createDate));
        }
        oAuth2AuthorizationImpl.setOAuth2ApplicationId(this.oAuth2ApplicationId);
        oAuth2AuthorizationImpl.setOAuth2ApplicationScopeAliasesId(this.oAuth2ApplicationScopeAliasesId);
        if (this.accessTokenContent == null) {
            oAuth2AuthorizationImpl.setAccessTokenContent("");
        } else {
            oAuth2AuthorizationImpl.setAccessTokenContent(this.accessTokenContent);
        }
        oAuth2AuthorizationImpl.setAccessTokenContentHash(this.accessTokenContentHash);
        if (this.accessTokenCreateDate == Long.MIN_VALUE) {
            oAuth2AuthorizationImpl.setAccessTokenCreateDate(null);
        } else {
            oAuth2AuthorizationImpl.setAccessTokenCreateDate(new Date(this.accessTokenCreateDate));
        }
        if (this.accessTokenExpirationDate == Long.MIN_VALUE) {
            oAuth2AuthorizationImpl.setAccessTokenExpirationDate(null);
        } else {
            oAuth2AuthorizationImpl.setAccessTokenExpirationDate(new Date(this.accessTokenExpirationDate));
        }
        if (this.remoteHostInfo == null) {
            oAuth2AuthorizationImpl.setRemoteHostInfo("");
        } else {
            oAuth2AuthorizationImpl.setRemoteHostInfo(this.remoteHostInfo);
        }
        if (this.remoteIPInfo == null) {
            oAuth2AuthorizationImpl.setRemoteIPInfo("");
        } else {
            oAuth2AuthorizationImpl.setRemoteIPInfo(this.remoteIPInfo);
        }
        if (this.refreshTokenContent == null) {
            oAuth2AuthorizationImpl.setRefreshTokenContent("");
        } else {
            oAuth2AuthorizationImpl.setRefreshTokenContent(this.refreshTokenContent);
        }
        oAuth2AuthorizationImpl.setRefreshTokenContentHash(this.refreshTokenContentHash);
        if (this.refreshTokenCreateDate == Long.MIN_VALUE) {
            oAuth2AuthorizationImpl.setRefreshTokenCreateDate(null);
        } else {
            oAuth2AuthorizationImpl.setRefreshTokenCreateDate(new Date(this.refreshTokenCreateDate));
        }
        if (this.refreshTokenExpirationDate == Long.MIN_VALUE) {
            oAuth2AuthorizationImpl.setRefreshTokenExpirationDate(null);
        } else {
            oAuth2AuthorizationImpl.setRefreshTokenExpirationDate(new Date(this.refreshTokenExpirationDate));
        }
        oAuth2AuthorizationImpl.resetOriginalValues();
        return oAuth2AuthorizationImpl;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.oAuth2AuthorizationId = objectInput.readLong();
        this.companyId = objectInput.readLong();
        this.userId = objectInput.readLong();
        this.userName = objectInput.readUTF();
        this.createDate = objectInput.readLong();
        this.oAuth2ApplicationId = objectInput.readLong();
        this.oAuth2ApplicationScopeAliasesId = objectInput.readLong();
        this.accessTokenContent = objectInput.readUTF();
        this.accessTokenContentHash = objectInput.readLong();
        this.accessTokenCreateDate = objectInput.readLong();
        this.accessTokenExpirationDate = objectInput.readLong();
        this.remoteHostInfo = objectInput.readUTF();
        this.remoteIPInfo = objectInput.readUTF();
        this.refreshTokenContent = objectInput.readUTF();
        this.refreshTokenContentHash = objectInput.readLong();
        this.refreshTokenCreateDate = objectInput.readLong();
        this.refreshTokenExpirationDate = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.oAuth2AuthorizationId);
        objectOutput.writeLong(this.companyId);
        objectOutput.writeLong(this.userId);
        if (this.userName == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.userName);
        }
        objectOutput.writeLong(this.createDate);
        objectOutput.writeLong(this.oAuth2ApplicationId);
        objectOutput.writeLong(this.oAuth2ApplicationScopeAliasesId);
        if (this.accessTokenContent == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.accessTokenContent);
        }
        objectOutput.writeLong(this.accessTokenContentHash);
        objectOutput.writeLong(this.accessTokenCreateDate);
        objectOutput.writeLong(this.accessTokenExpirationDate);
        if (this.remoteHostInfo == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.remoteHostInfo);
        }
        if (this.remoteIPInfo == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.remoteIPInfo);
        }
        if (this.refreshTokenContent == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this.refreshTokenContent);
        }
        objectOutput.writeLong(this.refreshTokenContentHash);
        objectOutput.writeLong(this.refreshTokenCreateDate);
        objectOutput.writeLong(this.refreshTokenExpirationDate);
    }
}

