/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.persistence.impl;

import com.liferay.oauth2.provider.exception.NoSuchOAuth2AuthorizationException;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.model.impl.OAuth2AuthorizationImpl;
import com.liferay.oauth2.provider.model.impl.OAuth2AuthorizationModelImpl;
import com.liferay.oauth2.provider.service.persistence.OAuth2AuthorizationPersistence;
import com.liferay.oauth2.provider.service.persistence.impl.constants.OAuthTwoPersistenceConstants;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.service.persistence.impl.TableMapper;
import com.liferay.portal.kernel.service.persistence.impl.TableMapperFactory;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={OAuth2AuthorizationPersistence.class})
public class OAuth2AuthorizationPersistenceImpl
extends BasePersistenceImpl<OAuth2Authorization>
implements OAuth2AuthorizationPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = OAuth2AuthorizationImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "oAuth2Authorization.userId = ?";
    private FinderPath _finderPathWithPaginationFindByOAuth2ApplicationId;
    private FinderPath _finderPathWithoutPaginationFindByOAuth2ApplicationId;
    private FinderPath _finderPathCountByOAuth2ApplicationId;
    private static final String _FINDER_COLUMN_OAUTH2APPLICATIONID_OAUTH2APPLICATIONID_2 = "oAuth2Authorization.oAuth2ApplicationId = ?";
    private FinderPath _finderPathWithPaginationFindByAccessTokenContentHash;
    private FinderPath _finderPathWithoutPaginationFindByAccessTokenContentHash;
    private FinderPath _finderPathCountByAccessTokenContentHash;
    private static final String _FINDER_COLUMN_ACCESSTOKENCONTENTHASH_COMPANYID_2 = "oAuth2Authorization.companyId = ? AND ";
    private static final String _FINDER_COLUMN_ACCESSTOKENCONTENTHASH_ACCESSTOKENCONTENTHASH_2 = "oAuth2Authorization.accessTokenContentHash = ?";
    private FinderPath _finderPathWithPaginationFindByRefreshTokenContentHash;
    private FinderPath _finderPathWithoutPaginationFindByRefreshTokenContentHash;
    private FinderPath _finderPathCountByRefreshTokenContentHash;
    private static final String _FINDER_COLUMN_REFRESHTOKENCONTENTHASH_COMPANYID_2 = "oAuth2Authorization.companyId = ? AND ";
    private static final String _FINDER_COLUMN_REFRESHTOKENCONTENTHASH_REFRESHTOKENCONTENTHASH_2 = "oAuth2Authorization.refreshTokenContentHash = ?";
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    protected TableMapper<OAuth2Authorization, OAuth2ScopeGrant> oAuth2AuthorizationToOAuth2ScopeGrantTableMapper;
    private static final String _SQL_SELECT_OAUTH2AUTHORIZATION = "SELECT oAuth2Authorization FROM OAuth2Authorization oAuth2Authorization";
    private static final String _SQL_SELECT_OAUTH2AUTHORIZATION_WHERE = "SELECT oAuth2Authorization FROM OAuth2Authorization oAuth2Authorization WHERE ";
    private static final String _SQL_COUNT_OAUTH2AUTHORIZATION = "SELECT COUNT(oAuth2Authorization) FROM OAuth2Authorization oAuth2Authorization";
    private static final String _SQL_COUNT_OAUTH2AUTHORIZATION_WHERE = "SELECT COUNT(oAuth2Authorization) FROM OAuth2Authorization oAuth2Authorization WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "oAuth2Authorization.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No OAuth2Authorization exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No OAuth2Authorization exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(OAuth2AuthorizationPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"oAuth2ApplicationScopeAliasesId"});

    public List<OAuth2Authorization> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<OAuth2Authorization> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<OAuth2Authorization> findByUserId(long userId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<OAuth2Authorization> findByUserId(long userId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUserId;
                finderArgs = new Object[]{userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuth2Authorization oAuth2Authorization : list) {
                if (userId == oAuth2Authorization.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
            query.append(_FINDER_COLUMN_USERID_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(userId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Authorization findByUserId_First(long userId, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByUserId_First(userId, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("userId=");
        msg.append(userId);
        msg.append("}");
        throw new NoSuchOAuth2AuthorizationException(msg.toString());
    }

    public OAuth2Authorization fetchByUserId_First(long userId, OrderByComparator<OAuth2Authorization> orderByComparator) {
        List<OAuth2Authorization> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization findByUserId_Last(long userId, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByUserId_Last(userId, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("userId=");
        msg.append(userId);
        msg.append("}");
        throw new NoSuchOAuth2AuthorizationException(msg.toString());
    }

    public OAuth2Authorization fetchByUserId_Last(long userId, OrderByComparator<OAuth2Authorization> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<OAuth2Authorization> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization[] findByUserId_PrevAndNext(long oAuth2AuthorizationId, long userId, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.findByPrimaryKey(oAuth2AuthorizationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Authorization[] array = new OAuth2AuthorizationImpl[]{this.getByUserId_PrevAndNext(session, oAuth2Authorization, userId, orderByComparator, true), oAuth2Authorization, this.getByUserId_PrevAndNext(session, oAuth2Authorization, userId, orderByComparator, false)};
            OAuth2Authorization[] oAuth2AuthorizationArray = array;
            return oAuth2AuthorizationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Authorization getByUserId_PrevAndNext(Session session, OAuth2Authorization oAuth2Authorization, long userId, OrderByComparator<OAuth2Authorization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
        query.append(_FINDER_COLUMN_USERID_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Authorization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (OAuth2Authorization)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (OAuth2Authorization oAuth2Authorization : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Authorization);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_OAUTH2AUTHORIZATION_WHERE);
            query.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(userId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<OAuth2Authorization> findByOAuth2ApplicationId(long oAuth2ApplicationId) {
        return this.findByOAuth2ApplicationId(oAuth2ApplicationId, -1, -1, null);
    }

    public List<OAuth2Authorization> findByOAuth2ApplicationId(long oAuth2ApplicationId, int start, int end) {
        return this.findByOAuth2ApplicationId(oAuth2ApplicationId, start, end, null);
    }

    public List<OAuth2Authorization> findByOAuth2ApplicationId(long oAuth2ApplicationId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.findByOAuth2ApplicationId(oAuth2ApplicationId, start, end, orderByComparator, true);
    }

    public List<OAuth2Authorization> findByOAuth2ApplicationId(long oAuth2ApplicationId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByOAuth2ApplicationId;
                finderArgs = new Object[]{oAuth2ApplicationId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByOAuth2ApplicationId;
            finderArgs = new Object[]{oAuth2ApplicationId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuth2Authorization oAuth2Authorization : list) {
                if (oAuth2ApplicationId == oAuth2Authorization.getOAuth2ApplicationId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
            query.append(_FINDER_COLUMN_OAUTH2APPLICATIONID_OAUTH2APPLICATIONID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(oAuth2ApplicationId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Authorization findByOAuth2ApplicationId_First(long oAuth2ApplicationId, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByOAuth2ApplicationId_First(oAuth2ApplicationId, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("oAuth2ApplicationId=");
        msg.append(oAuth2ApplicationId);
        msg.append("}");
        throw new NoSuchOAuth2AuthorizationException(msg.toString());
    }

    public OAuth2Authorization fetchByOAuth2ApplicationId_First(long oAuth2ApplicationId, OrderByComparator<OAuth2Authorization> orderByComparator) {
        List<OAuth2Authorization> list = this.findByOAuth2ApplicationId(oAuth2ApplicationId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization findByOAuth2ApplicationId_Last(long oAuth2ApplicationId, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByOAuth2ApplicationId_Last(oAuth2ApplicationId, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("oAuth2ApplicationId=");
        msg.append(oAuth2ApplicationId);
        msg.append("}");
        throw new NoSuchOAuth2AuthorizationException(msg.toString());
    }

    public OAuth2Authorization fetchByOAuth2ApplicationId_Last(long oAuth2ApplicationId, OrderByComparator<OAuth2Authorization> orderByComparator) {
        int count = this.countByOAuth2ApplicationId(oAuth2ApplicationId);
        if (count == 0) {
            return null;
        }
        List<OAuth2Authorization> list = this.findByOAuth2ApplicationId(oAuth2ApplicationId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization[] findByOAuth2ApplicationId_PrevAndNext(long oAuth2AuthorizationId, long oAuth2ApplicationId, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.findByPrimaryKey(oAuth2AuthorizationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Authorization[] array = new OAuth2AuthorizationImpl[]{this.getByOAuth2ApplicationId_PrevAndNext(session, oAuth2Authorization, oAuth2ApplicationId, orderByComparator, true), oAuth2Authorization, this.getByOAuth2ApplicationId_PrevAndNext(session, oAuth2Authorization, oAuth2ApplicationId, orderByComparator, false)};
            OAuth2Authorization[] oAuth2AuthorizationArray = array;
            return oAuth2AuthorizationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Authorization getByOAuth2ApplicationId_PrevAndNext(Session session, OAuth2Authorization oAuth2Authorization, long oAuth2ApplicationId, OrderByComparator<OAuth2Authorization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
        query.append(_FINDER_COLUMN_OAUTH2APPLICATIONID_OAUTH2APPLICATIONID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(oAuth2ApplicationId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Authorization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (OAuth2Authorization)list.get(1);
        }
        return null;
    }

    public void removeByOAuth2ApplicationId(long oAuth2ApplicationId) {
        for (OAuth2Authorization oAuth2Authorization : this.findByOAuth2ApplicationId(oAuth2ApplicationId, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Authorization);
        }
    }

    public int countByOAuth2ApplicationId(long oAuth2ApplicationId) {
        FinderPath finderPath = this._finderPathCountByOAuth2ApplicationId;
        Object[] finderArgs = new Object[]{oAuth2ApplicationId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_OAUTH2AUTHORIZATION_WHERE);
            query.append(_FINDER_COLUMN_OAUTH2APPLICATIONID_OAUTH2APPLICATIONID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(oAuth2ApplicationId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<OAuth2Authorization> findByAccessTokenContentHash(long companyId, long accessTokenContentHash) {
        return this.findByAccessTokenContentHash(companyId, accessTokenContentHash, -1, -1, null);
    }

    public List<OAuth2Authorization> findByAccessTokenContentHash(long companyId, long accessTokenContentHash, int start, int end) {
        return this.findByAccessTokenContentHash(companyId, accessTokenContentHash, start, end, null);
    }

    public List<OAuth2Authorization> findByAccessTokenContentHash(long companyId, long accessTokenContentHash, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.findByAccessTokenContentHash(companyId, accessTokenContentHash, start, end, orderByComparator, true);
    }

    public List<OAuth2Authorization> findByAccessTokenContentHash(long companyId, long accessTokenContentHash, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByAccessTokenContentHash;
                finderArgs = new Object[]{companyId, accessTokenContentHash};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByAccessTokenContentHash;
            finderArgs = new Object[]{companyId, accessTokenContentHash, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuth2Authorization oAuth2Authorization : list) {
                if (companyId == oAuth2Authorization.getCompanyId() && accessTokenContentHash == oAuth2Authorization.getAccessTokenContentHash()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
            query.append("oAuth2Authorization.companyId = ? AND ");
            query.append(_FINDER_COLUMN_ACCESSTOKENCONTENTHASH_ACCESSTOKENCONTENTHASH_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(accessTokenContentHash);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Authorization findByAccessTokenContentHash_First(long companyId, long accessTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByAccessTokenContentHash_First(companyId, accessTokenContentHash, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", accessTokenContentHash=");
        msg.append(accessTokenContentHash);
        msg.append("}");
        throw new NoSuchOAuth2AuthorizationException(msg.toString());
    }

    public OAuth2Authorization fetchByAccessTokenContentHash_First(long companyId, long accessTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) {
        List<OAuth2Authorization> list = this.findByAccessTokenContentHash(companyId, accessTokenContentHash, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization findByAccessTokenContentHash_Last(long companyId, long accessTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByAccessTokenContentHash_Last(companyId, accessTokenContentHash, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", accessTokenContentHash=");
        msg.append(accessTokenContentHash);
        msg.append("}");
        throw new NoSuchOAuth2AuthorizationException(msg.toString());
    }

    public OAuth2Authorization fetchByAccessTokenContentHash_Last(long companyId, long accessTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) {
        int count = this.countByAccessTokenContentHash(companyId, accessTokenContentHash);
        if (count == 0) {
            return null;
        }
        List<OAuth2Authorization> list = this.findByAccessTokenContentHash(companyId, accessTokenContentHash, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization[] findByAccessTokenContentHash_PrevAndNext(long oAuth2AuthorizationId, long companyId, long accessTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.findByPrimaryKey(oAuth2AuthorizationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Authorization[] array = new OAuth2AuthorizationImpl[]{this.getByAccessTokenContentHash_PrevAndNext(session, oAuth2Authorization, companyId, accessTokenContentHash, orderByComparator, true), oAuth2Authorization, this.getByAccessTokenContentHash_PrevAndNext(session, oAuth2Authorization, companyId, accessTokenContentHash, orderByComparator, false)};
            OAuth2Authorization[] oAuth2AuthorizationArray = array;
            return oAuth2AuthorizationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Authorization getByAccessTokenContentHash_PrevAndNext(Session session, OAuth2Authorization oAuth2Authorization, long companyId, long accessTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
        query.append("oAuth2Authorization.companyId = ? AND ");
        query.append(_FINDER_COLUMN_ACCESSTOKENCONTENTHASH_ACCESSTOKENCONTENTHASH_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        qPos.add(accessTokenContentHash);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Authorization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (OAuth2Authorization)list.get(1);
        }
        return null;
    }

    public void removeByAccessTokenContentHash(long companyId, long accessTokenContentHash) {
        for (OAuth2Authorization oAuth2Authorization : this.findByAccessTokenContentHash(companyId, accessTokenContentHash, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Authorization);
        }
    }

    public int countByAccessTokenContentHash(long companyId, long accessTokenContentHash) {
        FinderPath finderPath = this._finderPathCountByAccessTokenContentHash;
        Object[] finderArgs = new Object[]{companyId, accessTokenContentHash};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_OAUTH2AUTHORIZATION_WHERE);
            query.append("oAuth2Authorization.companyId = ? AND ");
            query.append(_FINDER_COLUMN_ACCESSTOKENCONTENTHASH_ACCESSTOKENCONTENTHASH_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(accessTokenContentHash);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<OAuth2Authorization> findByRefreshTokenContentHash(long companyId, long refreshTokenContentHash) {
        return this.findByRefreshTokenContentHash(companyId, refreshTokenContentHash, -1, -1, null);
    }

    public List<OAuth2Authorization> findByRefreshTokenContentHash(long companyId, long refreshTokenContentHash, int start, int end) {
        return this.findByRefreshTokenContentHash(companyId, refreshTokenContentHash, start, end, null);
    }

    public List<OAuth2Authorization> findByRefreshTokenContentHash(long companyId, long refreshTokenContentHash, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.findByRefreshTokenContentHash(companyId, refreshTokenContentHash, start, end, orderByComparator, true);
    }

    public List<OAuth2Authorization> findByRefreshTokenContentHash(long companyId, long refreshTokenContentHash, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByRefreshTokenContentHash;
                finderArgs = new Object[]{companyId, refreshTokenContentHash};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByRefreshTokenContentHash;
            finderArgs = new Object[]{companyId, refreshTokenContentHash, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuth2Authorization oAuth2Authorization : list) {
                if (companyId == oAuth2Authorization.getCompanyId() && refreshTokenContentHash == oAuth2Authorization.getRefreshTokenContentHash()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
            query.append("oAuth2Authorization.companyId = ? AND ");
            query.append(_FINDER_COLUMN_REFRESHTOKENCONTENTHASH_REFRESHTOKENCONTENTHASH_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                query.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(refreshTokenContentHash);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2Authorization findByRefreshTokenContentHash_First(long companyId, long refreshTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByRefreshTokenContentHash_First(companyId, refreshTokenContentHash, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", refreshTokenContentHash=");
        msg.append(refreshTokenContentHash);
        msg.append("}");
        throw new NoSuchOAuth2AuthorizationException(msg.toString());
    }

    public OAuth2Authorization fetchByRefreshTokenContentHash_First(long companyId, long refreshTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) {
        List<OAuth2Authorization> list = this.findByRefreshTokenContentHash(companyId, refreshTokenContentHash, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization findByRefreshTokenContentHash_Last(long companyId, long refreshTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.fetchByRefreshTokenContentHash_Last(companyId, refreshTokenContentHash, orderByComparator);
        if (oAuth2Authorization != null) {
            return oAuth2Authorization;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", refreshTokenContentHash=");
        msg.append(refreshTokenContentHash);
        msg.append("}");
        throw new NoSuchOAuth2AuthorizationException(msg.toString());
    }

    public OAuth2Authorization fetchByRefreshTokenContentHash_Last(long companyId, long refreshTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) {
        int count = this.countByRefreshTokenContentHash(companyId, refreshTokenContentHash);
        if (count == 0) {
            return null;
        }
        List<OAuth2Authorization> list = this.findByRefreshTokenContentHash(companyId, refreshTokenContentHash, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2Authorization[] findByRefreshTokenContentHash_PrevAndNext(long oAuth2AuthorizationId, long companyId, long refreshTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = this.findByPrimaryKey(oAuth2AuthorizationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Authorization[] array = new OAuth2AuthorizationImpl[]{this.getByRefreshTokenContentHash_PrevAndNext(session, oAuth2Authorization, companyId, refreshTokenContentHash, orderByComparator, true), oAuth2Authorization, this.getByRefreshTokenContentHash_PrevAndNext(session, oAuth2Authorization, companyId, refreshTokenContentHash, orderByComparator, false)};
            OAuth2Authorization[] oAuth2AuthorizationArray = array;
            return oAuth2AuthorizationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Authorization getByRefreshTokenContentHash_PrevAndNext(Session session, OAuth2Authorization oAuth2Authorization, long companyId, long refreshTokenContentHash, OrderByComparator<OAuth2Authorization> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_OAUTH2AUTHORIZATION_WHERE);
        query.append("oAuth2Authorization.companyId = ? AND ");
        query.append(_FINDER_COLUMN_REFRESHTOKENCONTENTHASH_REFRESHTOKENCONTENTHASH_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        qPos.add(refreshTokenContentHash);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2Authorization)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (OAuth2Authorization)list.get(1);
        }
        return null;
    }

    public void removeByRefreshTokenContentHash(long companyId, long refreshTokenContentHash) {
        for (OAuth2Authorization oAuth2Authorization : this.findByRefreshTokenContentHash(companyId, refreshTokenContentHash, -1, -1, null)) {
            this.remove((BaseModel)oAuth2Authorization);
        }
    }

    public int countByRefreshTokenContentHash(long companyId, long refreshTokenContentHash) {
        FinderPath finderPath = this._finderPathCountByRefreshTokenContentHash;
        Object[] finderArgs = new Object[]{companyId, refreshTokenContentHash};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_OAUTH2AUTHORIZATION_WHERE);
            query.append("oAuth2Authorization.companyId = ? AND ");
            query.append(_FINDER_COLUMN_REFRESHTOKENCONTENTHASH_REFRESHTOKENCONTENTHASH_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(refreshTokenContentHash);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public OAuth2AuthorizationPersistenceImpl() {
        this.setModelClass(OAuth2Authorization.class);
        this.setModelImplClass(OAuth2AuthorizationImpl.class);
        this.setModelPKClass(Long.TYPE);
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("oAuth2ApplicationScopeAliasesId", "oA2AScopeAliasesId");
        this.setDBColumnNames(dbColumnNames);
    }

    public void cacheResult(OAuth2Authorization oAuth2Authorization) {
        this.entityCache.putResult(this.entityCacheEnabled, OAuth2AuthorizationImpl.class, (Serializable)Long.valueOf(oAuth2Authorization.getPrimaryKey()), (Serializable)oAuth2Authorization);
        oAuth2Authorization.resetOriginalValues();
    }

    public void cacheResult(List<OAuth2Authorization> oAuth2Authorizations) {
        for (OAuth2Authorization oAuth2Authorization : oAuth2Authorizations) {
            if (this.entityCache.getResult(this.entityCacheEnabled, OAuth2AuthorizationImpl.class, (Serializable)Long.valueOf(oAuth2Authorization.getPrimaryKey())) == null) {
                this.cacheResult(oAuth2Authorization);
                continue;
            }
            oAuth2Authorization.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(OAuth2AuthorizationImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(OAuth2Authorization oAuth2Authorization) {
        this.entityCache.removeResult(this.entityCacheEnabled, OAuth2AuthorizationImpl.class, (Serializable)Long.valueOf(oAuth2Authorization.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<OAuth2Authorization> oAuth2Authorizations) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (OAuth2Authorization oAuth2Authorization : oAuth2Authorizations) {
            this.entityCache.removeResult(this.entityCacheEnabled, OAuth2AuthorizationImpl.class, (Serializable)Long.valueOf(oAuth2Authorization.getPrimaryKey()));
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(this.entityCacheEnabled, OAuth2AuthorizationImpl.class, primaryKey);
        }
    }

    public OAuth2Authorization create(long oAuth2AuthorizationId) {
        OAuth2AuthorizationImpl oAuth2Authorization = new OAuth2AuthorizationImpl();
        oAuth2Authorization.setNew(true);
        oAuth2Authorization.setPrimaryKey(oAuth2AuthorizationId);
        oAuth2Authorization.setCompanyId(CompanyThreadLocal.getCompanyId());
        return oAuth2Authorization;
    }

    public OAuth2Authorization remove(long oAuth2AuthorizationId) throws NoSuchOAuth2AuthorizationException {
        return this.remove(Long.valueOf(oAuth2AuthorizationId));
    }

    public OAuth2Authorization remove(Serializable primaryKey) throws NoSuchOAuth2AuthorizationException {
        Session session = null;
        try {
            session = this.openSession();
            OAuth2Authorization oAuth2Authorization = (OAuth2Authorization)session.get(OAuth2AuthorizationImpl.class, primaryKey);
            if (oAuth2Authorization == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchOAuth2AuthorizationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            OAuth2Authorization oAuth2Authorization2 = (OAuth2Authorization)this.remove((BaseModel)oAuth2Authorization);
            return oAuth2Authorization2;
        }
        catch (NoSuchOAuth2AuthorizationException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2Authorization removeImpl(OAuth2Authorization oAuth2Authorization) {
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.deleteLeftPrimaryKeyTableMappings(oAuth2Authorization.getPrimaryKey());
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)oAuth2Authorization)) {
                oAuth2Authorization = (OAuth2Authorization)session.get(OAuth2AuthorizationImpl.class, oAuth2Authorization.getPrimaryKeyObj());
            }
            if (oAuth2Authorization != null) {
                session.delete((Object)oAuth2Authorization);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (oAuth2Authorization != null) {
            this.clearCache(oAuth2Authorization);
        }
        return oAuth2Authorization;
    }

    public OAuth2Authorization updateImpl(OAuth2Authorization oAuth2Authorization) {
        boolean isNew = oAuth2Authorization.isNew();
        if (!(oAuth2Authorization instanceof OAuth2AuthorizationModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(oAuth2Authorization.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)oAuth2Authorization);
                throw new IllegalArgumentException("Implement ModelWrapper in oAuth2Authorization proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom OAuth2Authorization implementation " + oAuth2Authorization.getClass());
        }
        OAuth2AuthorizationModelImpl oAuth2AuthorizationModelImpl = (OAuth2AuthorizationModelImpl)oAuth2Authorization;
        Session session = null;
        try {
            session = this.openSession();
            if (oAuth2Authorization.isNew()) {
                session.save((Object)oAuth2Authorization);
                oAuth2Authorization.setNew(false);
            } else {
                oAuth2Authorization = (OAuth2Authorization)session.merge((Object)oAuth2Authorization);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{oAuth2AuthorizationModelImpl.getUserId()};
            this.finderCache.removeResult(this._finderPathCountByUserId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            args = new Object[]{oAuth2AuthorizationModelImpl.getOAuth2ApplicationId()};
            this.finderCache.removeResult(this._finderPathCountByOAuth2ApplicationId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByOAuth2ApplicationId, args);
            args = new Object[]{oAuth2AuthorizationModelImpl.getCompanyId(), oAuth2AuthorizationModelImpl.getAccessTokenContentHash()};
            this.finderCache.removeResult(this._finderPathCountByAccessTokenContentHash, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByAccessTokenContentHash, args);
            args = new Object[]{oAuth2AuthorizationModelImpl.getCompanyId(), oAuth2AuthorizationModelImpl.getRefreshTokenContentHash()};
            this.finderCache.removeResult(this._finderPathCountByRefreshTokenContentHash, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByRefreshTokenContentHash, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((oAuth2AuthorizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUserId.getColumnBitmask()) != 0L) {
                args = new Object[]{oAuth2AuthorizationModelImpl.getOriginalUserId()};
                this.finderCache.removeResult(this._finderPathCountByUserId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
                args = new Object[]{oAuth2AuthorizationModelImpl.getUserId()};
                this.finderCache.removeResult(this._finderPathCountByUserId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            }
            if ((oAuth2AuthorizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByOAuth2ApplicationId.getColumnBitmask()) != 0L) {
                args = new Object[]{oAuth2AuthorizationModelImpl.getOriginalOAuth2ApplicationId()};
                this.finderCache.removeResult(this._finderPathCountByOAuth2ApplicationId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByOAuth2ApplicationId, args);
                args = new Object[]{oAuth2AuthorizationModelImpl.getOAuth2ApplicationId()};
                this.finderCache.removeResult(this._finderPathCountByOAuth2ApplicationId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByOAuth2ApplicationId, args);
            }
            if ((oAuth2AuthorizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByAccessTokenContentHash.getColumnBitmask()) != 0L) {
                args = new Object[]{oAuth2AuthorizationModelImpl.getOriginalCompanyId(), oAuth2AuthorizationModelImpl.getOriginalAccessTokenContentHash()};
                this.finderCache.removeResult(this._finderPathCountByAccessTokenContentHash, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByAccessTokenContentHash, args);
                args = new Object[]{oAuth2AuthorizationModelImpl.getCompanyId(), oAuth2AuthorizationModelImpl.getAccessTokenContentHash()};
                this.finderCache.removeResult(this._finderPathCountByAccessTokenContentHash, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByAccessTokenContentHash, args);
            }
            if ((oAuth2AuthorizationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByRefreshTokenContentHash.getColumnBitmask()) != 0L) {
                args = new Object[]{oAuth2AuthorizationModelImpl.getOriginalCompanyId(), oAuth2AuthorizationModelImpl.getOriginalRefreshTokenContentHash()};
                this.finderCache.removeResult(this._finderPathCountByRefreshTokenContentHash, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByRefreshTokenContentHash, args);
                args = new Object[]{oAuth2AuthorizationModelImpl.getCompanyId(), oAuth2AuthorizationModelImpl.getRefreshTokenContentHash()};
                this.finderCache.removeResult(this._finderPathCountByRefreshTokenContentHash, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByRefreshTokenContentHash, args);
            }
        }
        this.entityCache.putResult(this.entityCacheEnabled, OAuth2AuthorizationImpl.class, (Serializable)Long.valueOf(oAuth2Authorization.getPrimaryKey()), (Serializable)oAuth2Authorization, false);
        oAuth2Authorization.resetOriginalValues();
        return oAuth2Authorization;
    }

    public OAuth2Authorization findByPrimaryKey(Serializable primaryKey) throws NoSuchOAuth2AuthorizationException {
        OAuth2Authorization oAuth2Authorization = (OAuth2Authorization)this.fetchByPrimaryKey(primaryKey);
        if (oAuth2Authorization == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchOAuth2AuthorizationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return oAuth2Authorization;
    }

    public OAuth2Authorization findByPrimaryKey(long oAuth2AuthorizationId) throws NoSuchOAuth2AuthorizationException {
        return this.findByPrimaryKey(Long.valueOf(oAuth2AuthorizationId));
    }

    public OAuth2Authorization fetchByPrimaryKey(long oAuth2AuthorizationId) {
        return (OAuth2Authorization)this.fetchByPrimaryKey(Long.valueOf(oAuth2AuthorizationId));
    }

    public List<OAuth2Authorization> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<OAuth2Authorization> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<OAuth2Authorization> findAll(int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<OAuth2Authorization> findAll(int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_OAUTH2AUTHORIZATION);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_OAUTH2AUTHORIZATION;
                sql = sql.concat(" ORDER BY oAuth2Authorization.oAuth2AuthorizationId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (OAuth2Authorization oAuth2Authorization : this.findAll()) {
            this.remove((BaseModel)oAuth2Authorization);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_OAUTH2AUTHORIZATION);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public long[] getOAuth2ScopeGrantPrimaryKeys(long pk) {
        long[] pks = this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.getRightPrimaryKeys(pk);
        return (long[])pks.clone();
    }

    public List<OAuth2Authorization> getOAuth2ScopeGrantOAuth2Authorizations(long pk) {
        return this.getOAuth2ScopeGrantOAuth2Authorizations(pk, -1, -1);
    }

    public List<OAuth2Authorization> getOAuth2ScopeGrantOAuth2Authorizations(long pk, int start, int end) {
        return this.getOAuth2ScopeGrantOAuth2Authorizations(pk, start, end, null);
    }

    public List<OAuth2Authorization> getOAuth2ScopeGrantOAuth2Authorizations(long pk, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.getLeftBaseModels(pk, start, end, orderByComparator);
    }

    public int getOAuth2ScopeGrantsSize(long pk) {
        long[] pks = this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.getRightPrimaryKeys(pk);
        return pks.length;
    }

    public boolean containsOAuth2ScopeGrant(long pk, long oAuth2ScopeGrantPK) {
        return this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.containsTableMapping(pk, oAuth2ScopeGrantPK);
    }

    public boolean containsOAuth2ScopeGrants(long pk) {
        return this.getOAuth2ScopeGrantsSize(pk) > 0;
    }

    public void addOAuth2ScopeGrant(long pk, long oAuth2ScopeGrantPK) {
        OAuth2Authorization oAuth2Authorization = this.fetchByPrimaryKey(pk);
        if (oAuth2Authorization == null) {
            this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.addTableMapping(CompanyThreadLocal.getCompanyId().longValue(), pk, oAuth2ScopeGrantPK);
        } else {
            this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.addTableMapping(oAuth2Authorization.getCompanyId(), pk, oAuth2ScopeGrantPK);
        }
    }

    public void addOAuth2ScopeGrant(long pk, OAuth2ScopeGrant oAuth2ScopeGrant) {
        OAuth2Authorization oAuth2Authorization = this.fetchByPrimaryKey(pk);
        if (oAuth2Authorization == null) {
            this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.addTableMapping(CompanyThreadLocal.getCompanyId().longValue(), pk, oAuth2ScopeGrant.getPrimaryKey());
        } else {
            this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.addTableMapping(oAuth2Authorization.getCompanyId(), pk, oAuth2ScopeGrant.getPrimaryKey());
        }
    }

    public void addOAuth2ScopeGrants(long pk, long[] oAuth2ScopeGrantPKs) {
        long companyId = 0L;
        OAuth2Authorization oAuth2Authorization = this.fetchByPrimaryKey(pk);
        companyId = oAuth2Authorization == null ? CompanyThreadLocal.getCompanyId().longValue() : oAuth2Authorization.getCompanyId();
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.addTableMappings(companyId, pk, oAuth2ScopeGrantPKs);
    }

    public void addOAuth2ScopeGrants(long pk, List<OAuth2ScopeGrant> oAuth2ScopeGrants) {
        this.addOAuth2ScopeGrants(pk, ListUtil.toLongArray(oAuth2ScopeGrants, (Accessor)OAuth2ScopeGrant.O_AUTH2_SCOPE_GRANT_ID_ACCESSOR));
    }

    public void clearOAuth2ScopeGrants(long pk) {
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.deleteLeftPrimaryKeyTableMappings(pk);
    }

    public void removeOAuth2ScopeGrant(long pk, long oAuth2ScopeGrantPK) {
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.deleteTableMapping(pk, oAuth2ScopeGrantPK);
    }

    public void removeOAuth2ScopeGrant(long pk, OAuth2ScopeGrant oAuth2ScopeGrant) {
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.deleteTableMapping(pk, oAuth2ScopeGrant.getPrimaryKey());
    }

    public void removeOAuth2ScopeGrants(long pk, long[] oAuth2ScopeGrantPKs) {
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.deleteTableMappings(pk, oAuth2ScopeGrantPKs);
    }

    public void removeOAuth2ScopeGrants(long pk, List<OAuth2ScopeGrant> oAuth2ScopeGrants) {
        this.removeOAuth2ScopeGrants(pk, ListUtil.toLongArray(oAuth2ScopeGrants, (Accessor)OAuth2ScopeGrant.O_AUTH2_SCOPE_GRANT_ID_ACCESSOR));
    }

    public void setOAuth2ScopeGrants(long pk, long[] oAuth2ScopeGrantPKs) {
        Set newOAuth2ScopeGrantPKsSet = SetUtil.fromArray((long[])oAuth2ScopeGrantPKs);
        Set oldOAuth2ScopeGrantPKsSet = SetUtil.fromArray((long[])this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.getRightPrimaryKeys(pk));
        HashSet removeOAuth2ScopeGrantPKsSet = new HashSet(oldOAuth2ScopeGrantPKsSet);
        removeOAuth2ScopeGrantPKsSet.removeAll(newOAuth2ScopeGrantPKsSet);
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.deleteTableMappings(pk, ArrayUtil.toLongArray(removeOAuth2ScopeGrantPKsSet));
        newOAuth2ScopeGrantPKsSet.removeAll(oldOAuth2ScopeGrantPKsSet);
        long companyId = 0L;
        OAuth2Authorization oAuth2Authorization = this.fetchByPrimaryKey(pk);
        companyId = oAuth2Authorization == null ? CompanyThreadLocal.getCompanyId().longValue() : oAuth2Authorization.getCompanyId();
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper.addTableMappings(companyId, pk, ArrayUtil.toLongArray((Collection)newOAuth2ScopeGrantPKsSet));
    }

    public void setOAuth2ScopeGrants(long pk, List<OAuth2ScopeGrant> oAuth2ScopeGrants) {
        try {
            long[] oAuth2ScopeGrantPKs = new long[oAuth2ScopeGrants.size()];
            for (int i = 0; i < oAuth2ScopeGrants.size(); ++i) {
                OAuth2ScopeGrant oAuth2ScopeGrant = oAuth2ScopeGrants.get(i);
                oAuth2ScopeGrantPKs[i] = oAuth2ScopeGrant.getPrimaryKey();
            }
            this.setOAuth2ScopeGrants(pk, oAuth2ScopeGrantPKs);
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "oAuth2AuthorizationId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_OAUTH2AUTHORIZATION;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return OAuth2AuthorizationModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        OAuth2AuthorizationModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        OAuth2AuthorizationModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this.oAuth2AuthorizationToOAuth2ScopeGrantTableMapper = TableMapperFactory.getTableMapper((String)"OA2Auths_OA2ScopeGrants#oAuth2AuthorizationId", (String)"OA2Auths_OA2ScopeGrants", (String)"companyId", (String)"oAuth2AuthorizationId", (String)"oAuth2ScopeGrantId", (BasePersistence)this, OAuth2ScopeGrant.class);
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUserId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUserId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, 16L);
        this._finderPathCountByUserId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByOAuth2ApplicationId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByOAuth2ApplicationId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByOAuth2ApplicationId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByOAuth2ApplicationId", new String[]{Long.class.getName()}, 4L);
        this._finderPathCountByOAuth2ApplicationId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByOAuth2ApplicationId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByAccessTokenContentHash = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByAccessTokenContentHash", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByAccessTokenContentHash = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByAccessTokenContentHash", new String[]{Long.class.getName(), Long.class.getName()}, 3L);
        this._finderPathCountByAccessTokenContentHash = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByAccessTokenContentHash", new String[]{Long.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByRefreshTokenContentHash = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByRefreshTokenContentHash", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByRefreshTokenContentHash = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuth2AuthorizationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByRefreshTokenContentHash", new String[]{Long.class.getName(), Long.class.getName()}, 10L);
        this._finderPathCountByRefreshTokenContentHash = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByRefreshTokenContentHash", new String[]{Long.class.getName(), Long.class.getName()});
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(OAuth2AuthorizationImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        TableMapperFactory.removeTableMapper((String)"OA2Auths_OA2ScopeGrants#oAuth2AuthorizationId");
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.oauth2.provider.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.oauth2.provider.model.OAuth2Authorization"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.oauth2.provider.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.oauth2.provider.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    static {
        try {
            Class.forName(OAuthTwoPersistenceConstants.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
    }
}

