/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.persistence.impl;

import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.model.impl.OAuth2AuthorizationImpl;
import com.liferay.oauth2.provider.model.impl.OAuth2ScopeGrantImpl;
import com.liferay.oauth2.provider.service.persistence.OAuth2ScopeGrantFinder;
import com.liferay.oauth2.provider.service.persistence.impl.OAuth2ScopeGrantFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.SystemException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OAuth2ScopeGrantFinder.class})
public class OAuth2ScopeGrantFinderImpl
extends OAuth2ScopeGrantFinderBaseImpl
implements OAuth2ScopeGrantFinder {
    public static final String FIND_BY_C_A_B_A = OAuth2ScopeGrantFinder.class.getName() + ".findByC_A_B_A";
    @Reference
    private CustomSQL _customSQL;

    public Collection<OAuth2ScopeGrant> findByC_A_B_A(long companyId, String applicationName, String bundleSymbolicName, String accessTokenContent) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_C_A_B_A);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            q.addEntity("OAuth2ScopeGrant", OAuth2ScopeGrantImpl.class);
            q.addEntity("OAuth2Authorization", OAuth2AuthorizationImpl.class);
            qPos.add(companyId);
            qPos.add(applicationName);
            qPos.add(bundleSymbolicName);
            qPos.add(accessTokenContent.hashCode());
            List rows = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)-1, (int)-1);
            ArrayList<OAuth2ScopeGrant> oAuth2ScopeGrants = new ArrayList<OAuth2ScopeGrant>();
            for (Object[] row : rows) {
                OAuth2Authorization oAuth2Authorization = (OAuth2Authorization)row[1];
                if (!accessTokenContent.equals(oAuth2Authorization.getAccessTokenContent())) continue;
                oAuth2ScopeGrants.add((OAuth2ScopeGrant)row[0]);
            }
            ArrayList<OAuth2ScopeGrant> arrayList = oAuth2ScopeGrants;
            return arrayList;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

