/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.persistence.impl;

import com.liferay.oauth2.provider.exception.NoSuchOAuth2ScopeGrantException;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.model.OAuth2ScopeGrantTable;
import com.liferay.oauth2.provider.model.impl.OAuth2ScopeGrantImpl;
import com.liferay.oauth2.provider.model.impl.OAuth2ScopeGrantModelImpl;
import com.liferay.oauth2.provider.service.persistence.OAuth2ScopeGrantPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.service.persistence.impl.TableMapper;
import com.liferay.portal.kernel.service.persistence.impl.TableMapperFactory;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={OAuth2ScopeGrantPersistence.class, BasePersistence.class})
public class OAuth2ScopeGrantPersistenceImpl
extends BasePersistenceImpl<OAuth2ScopeGrant>
implements OAuth2ScopeGrantPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = OAuth2ScopeGrantImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByOAuth2ApplicationScopeAliasesId;
    private FinderPath _finderPathWithoutPaginationFindByOAuth2ApplicationScopeAliasesId;
    private FinderPath _finderPathCountByOAuth2ApplicationScopeAliasesId;
    private static final String _FINDER_COLUMN_OAUTH2APPLICATIONSCOPEALIASESID_OAUTH2APPLICATIONSCOPEALIASESID_2 = "oAuth2ScopeGrant.oAuth2ApplicationScopeAliasesId = ?";
    private FinderPath _finderPathFetchByC_O_A_B_S;
    private FinderPath _finderPathCountByC_O_A_B_S;
    private static final String _FINDER_COLUMN_C_O_A_B_S_COMPANYID_2 = "oAuth2ScopeGrant.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_O_A_B_S_OAUTH2APPLICATIONSCOPEALIASESID_2 = "oAuth2ScopeGrant.oAuth2ApplicationScopeAliasesId = ? AND ";
    private static final String _FINDER_COLUMN_C_O_A_B_S_APPLICATIONNAME_2 = "oAuth2ScopeGrant.applicationName = ? AND ";
    private static final String _FINDER_COLUMN_C_O_A_B_S_APPLICATIONNAME_3 = "(oAuth2ScopeGrant.applicationName IS NULL OR oAuth2ScopeGrant.applicationName = '') AND ";
    private static final String _FINDER_COLUMN_C_O_A_B_S_BUNDLESYMBOLICNAME_2 = "oAuth2ScopeGrant.bundleSymbolicName = ? AND ";
    private static final String _FINDER_COLUMN_C_O_A_B_S_BUNDLESYMBOLICNAME_3 = "(oAuth2ScopeGrant.bundleSymbolicName IS NULL OR oAuth2ScopeGrant.bundleSymbolicName = '') AND ";
    private static final String _FINDER_COLUMN_C_O_A_B_S_SCOPE_2 = "oAuth2ScopeGrant.scope = ?";
    private static final String _FINDER_COLUMN_C_O_A_B_S_SCOPE_3 = "(oAuth2ScopeGrant.scope IS NULL OR oAuth2ScopeGrant.scope = '')";
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    protected TableMapper<OAuth2ScopeGrant, OAuth2Authorization> oAuth2ScopeGrantToOAuth2AuthorizationTableMapper;
    private static final String _SQL_SELECT_OAUTH2SCOPEGRANT = "SELECT oAuth2ScopeGrant FROM OAuth2ScopeGrant oAuth2ScopeGrant";
    private static final String _SQL_SELECT_OAUTH2SCOPEGRANT_WHERE = "SELECT oAuth2ScopeGrant FROM OAuth2ScopeGrant oAuth2ScopeGrant WHERE ";
    private static final String _SQL_COUNT_OAUTH2SCOPEGRANT = "SELECT COUNT(oAuth2ScopeGrant) FROM OAuth2ScopeGrant oAuth2ScopeGrant";
    private static final String _SQL_COUNT_OAUTH2SCOPEGRANT_WHERE = "SELECT COUNT(oAuth2ScopeGrant) FROM OAuth2ScopeGrant oAuth2ScopeGrant WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "oAuth2ScopeGrant.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No OAuth2ScopeGrant exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No OAuth2ScopeGrant exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(OAuth2ScopeGrantPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"oAuth2ApplicationScopeAliasesId"});
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<OAuth2ScopeGrant> findByOAuth2ApplicationScopeAliasesId(long oAuth2ApplicationScopeAliasesId) {
        return this.findByOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId, -1, -1, null);
    }

    public List<OAuth2ScopeGrant> findByOAuth2ApplicationScopeAliasesId(long oAuth2ApplicationScopeAliasesId, int start, int end) {
        return this.findByOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId, start, end, null);
    }

    public List<OAuth2ScopeGrant> findByOAuth2ApplicationScopeAliasesId(long oAuth2ApplicationScopeAliasesId, int start, int end, OrderByComparator<OAuth2ScopeGrant> orderByComparator) {
        return this.findByOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId, start, end, orderByComparator, true);
    }

    public List<OAuth2ScopeGrant> findByOAuth2ApplicationScopeAliasesId(long oAuth2ApplicationScopeAliasesId, int start, int end, OrderByComparator<OAuth2ScopeGrant> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByOAuth2ApplicationScopeAliasesId;
                finderArgs = new Object[]{oAuth2ApplicationScopeAliasesId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByOAuth2ApplicationScopeAliasesId;
            finderArgs = new Object[]{oAuth2ApplicationScopeAliasesId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (OAuth2ScopeGrant oAuth2ScopeGrant : list) {
                if (oAuth2ApplicationScopeAliasesId == oAuth2ScopeGrant.getOAuth2ApplicationScopeAliasesId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTH2SCOPEGRANT_WHERE);
            sb.append(_FINDER_COLUMN_OAUTH2APPLICATIONSCOPEALIASESID_OAUTH2APPLICATIONSCOPEALIASESID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuth2ScopeGrant.oAuth2ScopeGrantId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(oAuth2ApplicationScopeAliasesId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuth2ScopeGrant findByOAuth2ApplicationScopeAliasesId_First(long oAuth2ApplicationScopeAliasesId, OrderByComparator<OAuth2ScopeGrant> orderByComparator) throws NoSuchOAuth2ScopeGrantException {
        OAuth2ScopeGrant oAuth2ScopeGrant = this.fetchByOAuth2ApplicationScopeAliasesId_First(oAuth2ApplicationScopeAliasesId, orderByComparator);
        if (oAuth2ScopeGrant != null) {
            return oAuth2ScopeGrant;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("oAuth2ApplicationScopeAliasesId=");
        sb.append(oAuth2ApplicationScopeAliasesId);
        sb.append("}");
        throw new NoSuchOAuth2ScopeGrantException(sb.toString());
    }

    public OAuth2ScopeGrant fetchByOAuth2ApplicationScopeAliasesId_First(long oAuth2ApplicationScopeAliasesId, OrderByComparator<OAuth2ScopeGrant> orderByComparator) {
        List<OAuth2ScopeGrant> list = this.findByOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2ScopeGrant findByOAuth2ApplicationScopeAliasesId_Last(long oAuth2ApplicationScopeAliasesId, OrderByComparator<OAuth2ScopeGrant> orderByComparator) throws NoSuchOAuth2ScopeGrantException {
        OAuth2ScopeGrant oAuth2ScopeGrant = this.fetchByOAuth2ApplicationScopeAliasesId_Last(oAuth2ApplicationScopeAliasesId, orderByComparator);
        if (oAuth2ScopeGrant != null) {
            return oAuth2ScopeGrant;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("oAuth2ApplicationScopeAliasesId=");
        sb.append(oAuth2ApplicationScopeAliasesId);
        sb.append("}");
        throw new NoSuchOAuth2ScopeGrantException(sb.toString());
    }

    public OAuth2ScopeGrant fetchByOAuth2ApplicationScopeAliasesId_Last(long oAuth2ApplicationScopeAliasesId, OrderByComparator<OAuth2ScopeGrant> orderByComparator) {
        int count = this.countByOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId);
        if (count == 0) {
            return null;
        }
        List<OAuth2ScopeGrant> list = this.findByOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuth2ScopeGrant[] findByOAuth2ApplicationScopeAliasesId_PrevAndNext(long oAuth2ScopeGrantId, long oAuth2ApplicationScopeAliasesId, OrderByComparator<OAuth2ScopeGrant> orderByComparator) throws NoSuchOAuth2ScopeGrantException {
        OAuth2ScopeGrant oAuth2ScopeGrant = this.findByPrimaryKey(oAuth2ScopeGrantId);
        Session session = null;
        try {
            session = this.openSession();
            OAuth2ScopeGrant[] array = new OAuth2ScopeGrantImpl[]{this.getByOAuth2ApplicationScopeAliasesId_PrevAndNext(session, oAuth2ScopeGrant, oAuth2ApplicationScopeAliasesId, orderByComparator, true), oAuth2ScopeGrant, this.getByOAuth2ApplicationScopeAliasesId_PrevAndNext(session, oAuth2ScopeGrant, oAuth2ApplicationScopeAliasesId, orderByComparator, false)};
            OAuth2ScopeGrant[] oAuth2ScopeGrantArray = array;
            return oAuth2ScopeGrantArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2ScopeGrant getByOAuth2ApplicationScopeAliasesId_PrevAndNext(Session session, OAuth2ScopeGrant oAuth2ScopeGrant, long oAuth2ApplicationScopeAliasesId, OrderByComparator<OAuth2ScopeGrant> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTH2SCOPEGRANT_WHERE);
        sb.append(_FINDER_COLUMN_OAUTH2APPLICATIONSCOPEALIASESID_OAUTH2APPLICATIONSCOPEALIASESID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuth2ScopeGrant.oAuth2ScopeGrantId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(oAuth2ApplicationScopeAliasesId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuth2ScopeGrant)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuth2ScopeGrant)list.get(1);
        }
        return null;
    }

    public void removeByOAuth2ApplicationScopeAliasesId(long oAuth2ApplicationScopeAliasesId) {
        for (OAuth2ScopeGrant oAuth2ScopeGrant : this.findByOAuth2ApplicationScopeAliasesId(oAuth2ApplicationScopeAliasesId, -1, -1, null)) {
            this.remove((BaseModel)oAuth2ScopeGrant);
        }
    }

    public int countByOAuth2ApplicationScopeAliasesId(long oAuth2ApplicationScopeAliasesId) {
        FinderPath finderPath = this._finderPathCountByOAuth2ApplicationScopeAliasesId;
        Object[] finderArgs = new Object[]{oAuth2ApplicationScopeAliasesId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTH2SCOPEGRANT_WHERE);
            sb.append(_FINDER_COLUMN_OAUTH2APPLICATIONSCOPEALIASESID_OAUTH2APPLICATIONSCOPEALIASESID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(oAuth2ApplicationScopeAliasesId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public OAuth2ScopeGrant findByC_O_A_B_S(long companyId, long oAuth2ApplicationScopeAliasesId, String applicationName, String bundleSymbolicName, String scope) throws NoSuchOAuth2ScopeGrantException {
        OAuth2ScopeGrant oAuth2ScopeGrant = this.fetchByC_O_A_B_S(companyId, oAuth2ApplicationScopeAliasesId, applicationName, bundleSymbolicName, scope);
        if (oAuth2ScopeGrant == null) {
            StringBundler sb = new StringBundler(12);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", oAuth2ApplicationScopeAliasesId=");
            sb.append(oAuth2ApplicationScopeAliasesId);
            sb.append(", applicationName=");
            sb.append(applicationName);
            sb.append(", bundleSymbolicName=");
            sb.append(bundleSymbolicName);
            sb.append(", scope=");
            sb.append(scope);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchOAuth2ScopeGrantException(sb.toString());
        }
        return oAuth2ScopeGrant;
    }

    public OAuth2ScopeGrant fetchByC_O_A_B_S(long companyId, long oAuth2ApplicationScopeAliasesId, String applicationName, String bundleSymbolicName, String scope) {
        return this.fetchByC_O_A_B_S(companyId, oAuth2ApplicationScopeAliasesId, applicationName, bundleSymbolicName, scope, true);
    }

    public OAuth2ScopeGrant fetchByC_O_A_B_S(long companyId, long oAuth2ApplicationScopeAliasesId, String applicationName, String bundleSymbolicName, String scope, boolean useFinderCache) {
        OAuth2ScopeGrant oAuth2ScopeGrant;
        applicationName = Objects.toString(applicationName, "");
        bundleSymbolicName = Objects.toString(bundleSymbolicName, "");
        scope = Objects.toString(scope, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, oAuth2ApplicationScopeAliasesId, applicationName, bundleSymbolicName, scope};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_O_A_B_S, finderArgs);
        }
        if (!(!(result instanceof OAuth2ScopeGrant) || companyId == (oAuth2ScopeGrant = (OAuth2ScopeGrant)result).getCompanyId() && oAuth2ApplicationScopeAliasesId == oAuth2ScopeGrant.getOAuth2ApplicationScopeAliasesId() && Objects.equals(applicationName, oAuth2ScopeGrant.getApplicationName()) && Objects.equals(bundleSymbolicName, oAuth2ScopeGrant.getBundleSymbolicName()) && Objects.equals(scope, oAuth2ScopeGrant.getScope()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(7);
            sb.append(_SQL_SELECT_OAUTH2SCOPEGRANT_WHERE);
            sb.append(_FINDER_COLUMN_C_O_A_B_S_COMPANYID_2);
            sb.append(_FINDER_COLUMN_C_O_A_B_S_OAUTH2APPLICATIONSCOPEALIASESID_2);
            boolean bindApplicationName = false;
            if (applicationName.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_O_A_B_S_APPLICATIONNAME_3);
            } else {
                bindApplicationName = true;
                sb.append(_FINDER_COLUMN_C_O_A_B_S_APPLICATIONNAME_2);
            }
            boolean bindBundleSymbolicName = false;
            if (bundleSymbolicName.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_O_A_B_S_BUNDLESYMBOLICNAME_3);
            } else {
                bindBundleSymbolicName = true;
                sb.append(_FINDER_COLUMN_C_O_A_B_S_BUNDLESYMBOLICNAME_2);
            }
            boolean bindScope = false;
            if (scope.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_O_A_B_S_SCOPE_3);
            } else {
                bindScope = true;
                sb.append(_FINDER_COLUMN_C_O_A_B_S_SCOPE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(oAuth2ApplicationScopeAliasesId);
                if (bindApplicationName) {
                    queryPos.add(applicationName);
                }
                if (bindBundleSymbolicName) {
                    queryPos.add(bundleSymbolicName);
                }
                if (bindScope) {
                    queryPos.add(scope);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_O_A_B_S, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{companyId, oAuth2ApplicationScopeAliasesId, applicationName, bundleSymbolicName, scope};
                            }
                            _log.warn((Object)("OAuth2ScopeGrantPersistenceImpl.fetchByC_O_A_B_S(long, long, String, String, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    OAuth2ScopeGrant oAuth2ScopeGrant2 = (OAuth2ScopeGrant)list.get(0);
                    result = oAuth2ScopeGrant2;
                    this.cacheResult(oAuth2ScopeGrant2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (OAuth2ScopeGrant)result;
    }

    public OAuth2ScopeGrant removeByC_O_A_B_S(long companyId, long oAuth2ApplicationScopeAliasesId, String applicationName, String bundleSymbolicName, String scope) throws NoSuchOAuth2ScopeGrantException {
        OAuth2ScopeGrant oAuth2ScopeGrant = this.findByC_O_A_B_S(companyId, oAuth2ApplicationScopeAliasesId, applicationName, bundleSymbolicName, scope);
        return (OAuth2ScopeGrant)this.remove((BaseModel)oAuth2ScopeGrant);
    }

    public int countByC_O_A_B_S(long companyId, long oAuth2ApplicationScopeAliasesId, String applicationName, String bundleSymbolicName, String scope) {
        applicationName = Objects.toString(applicationName, "");
        bundleSymbolicName = Objects.toString(bundleSymbolicName, "");
        scope = Objects.toString(scope, "");
        FinderPath finderPath = this._finderPathCountByC_O_A_B_S;
        Object[] finderArgs = new Object[]{companyId, oAuth2ApplicationScopeAliasesId, applicationName, bundleSymbolicName, scope};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_SQL_COUNT_OAUTH2SCOPEGRANT_WHERE);
            sb.append(_FINDER_COLUMN_C_O_A_B_S_COMPANYID_2);
            sb.append(_FINDER_COLUMN_C_O_A_B_S_OAUTH2APPLICATIONSCOPEALIASESID_2);
            boolean bindApplicationName = false;
            if (applicationName.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_O_A_B_S_APPLICATIONNAME_3);
            } else {
                bindApplicationName = true;
                sb.append(_FINDER_COLUMN_C_O_A_B_S_APPLICATIONNAME_2);
            }
            boolean bindBundleSymbolicName = false;
            if (bundleSymbolicName.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_O_A_B_S_BUNDLESYMBOLICNAME_3);
            } else {
                bindBundleSymbolicName = true;
                sb.append(_FINDER_COLUMN_C_O_A_B_S_BUNDLESYMBOLICNAME_2);
            }
            boolean bindScope = false;
            if (scope.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_O_A_B_S_SCOPE_3);
            } else {
                bindScope = true;
                sb.append(_FINDER_COLUMN_C_O_A_B_S_SCOPE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(oAuth2ApplicationScopeAliasesId);
                if (bindApplicationName) {
                    queryPos.add(applicationName);
                }
                if (bindBundleSymbolicName) {
                    queryPos.add(bundleSymbolicName);
                }
                if (bindScope) {
                    queryPos.add(scope);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public OAuth2ScopeGrantPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("oAuth2ApplicationScopeAliasesId", "oA2AScopeAliasesId");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(OAuth2ScopeGrant.class);
        this.setModelImplClass(OAuth2ScopeGrantImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)OAuth2ScopeGrantTable.INSTANCE);
    }

    public void cacheResult(OAuth2ScopeGrant oAuth2ScopeGrant) {
        this.entityCache.putResult(OAuth2ScopeGrantImpl.class, (Serializable)Long.valueOf(oAuth2ScopeGrant.getPrimaryKey()), (Serializable)oAuth2ScopeGrant);
        this.finderCache.putResult(this._finderPathFetchByC_O_A_B_S, new Object[]{oAuth2ScopeGrant.getCompanyId(), oAuth2ScopeGrant.getOAuth2ApplicationScopeAliasesId(), oAuth2ScopeGrant.getApplicationName(), oAuth2ScopeGrant.getBundleSymbolicName(), oAuth2ScopeGrant.getScope()}, (Object)oAuth2ScopeGrant);
    }

    public void cacheResult(List<OAuth2ScopeGrant> oAuth2ScopeGrants) {
        for (OAuth2ScopeGrant oAuth2ScopeGrant : oAuth2ScopeGrants) {
            if (this.entityCache.getResult(OAuth2ScopeGrantImpl.class, (Serializable)Long.valueOf(oAuth2ScopeGrant.getPrimaryKey())) != null) continue;
            this.cacheResult(oAuth2ScopeGrant);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(OAuth2ScopeGrantImpl.class);
        this.finderCache.clearCache(OAuth2ScopeGrantImpl.class);
    }

    public void clearCache(OAuth2ScopeGrant oAuth2ScopeGrant) {
        this.entityCache.removeResult(OAuth2ScopeGrantImpl.class, (BaseModel)oAuth2ScopeGrant);
    }

    public void clearCache(List<OAuth2ScopeGrant> oAuth2ScopeGrants) {
        for (OAuth2ScopeGrant oAuth2ScopeGrant : oAuth2ScopeGrants) {
            this.entityCache.removeResult(OAuth2ScopeGrantImpl.class, (BaseModel)oAuth2ScopeGrant);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(OAuth2ScopeGrantImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(OAuth2ScopeGrantImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(OAuth2ScopeGrantModelImpl oAuth2ScopeGrantModelImpl) {
        Object[] args = new Object[]{oAuth2ScopeGrantModelImpl.getCompanyId(), oAuth2ScopeGrantModelImpl.getOAuth2ApplicationScopeAliasesId(), oAuth2ScopeGrantModelImpl.getApplicationName(), oAuth2ScopeGrantModelImpl.getBundleSymbolicName(), oAuth2ScopeGrantModelImpl.getScope()};
        this.finderCache.putResult(this._finderPathCountByC_O_A_B_S, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByC_O_A_B_S, args, (Object)oAuth2ScopeGrantModelImpl);
    }

    public OAuth2ScopeGrant create(long oAuth2ScopeGrantId) {
        OAuth2ScopeGrantImpl oAuth2ScopeGrant = new OAuth2ScopeGrantImpl();
        oAuth2ScopeGrant.setNew(true);
        oAuth2ScopeGrant.setPrimaryKey(oAuth2ScopeGrantId);
        oAuth2ScopeGrant.setCompanyId(CompanyThreadLocal.getCompanyId());
        return oAuth2ScopeGrant;
    }

    public OAuth2ScopeGrant remove(long oAuth2ScopeGrantId) throws NoSuchOAuth2ScopeGrantException {
        return this.remove(Long.valueOf(oAuth2ScopeGrantId));
    }

    public OAuth2ScopeGrant remove(Serializable primaryKey) throws NoSuchOAuth2ScopeGrantException {
        Session session = null;
        try {
            session = this.openSession();
            OAuth2ScopeGrant oAuth2ScopeGrant = (OAuth2ScopeGrant)session.get(OAuth2ScopeGrantImpl.class, primaryKey);
            if (oAuth2ScopeGrant == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchOAuth2ScopeGrantException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            OAuth2ScopeGrant oAuth2ScopeGrant2 = (OAuth2ScopeGrant)this.remove((BaseModel)oAuth2ScopeGrant);
            return oAuth2ScopeGrant2;
        }
        catch (NoSuchOAuth2ScopeGrantException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuth2ScopeGrant removeImpl(OAuth2ScopeGrant oAuth2ScopeGrant) {
        this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.deleteLeftPrimaryKeyTableMappings(oAuth2ScopeGrant.getPrimaryKey());
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)oAuth2ScopeGrant)) {
                oAuth2ScopeGrant = (OAuth2ScopeGrant)session.get(OAuth2ScopeGrantImpl.class, oAuth2ScopeGrant.getPrimaryKeyObj());
            }
            if (oAuth2ScopeGrant != null) {
                session.delete((Object)oAuth2ScopeGrant);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (oAuth2ScopeGrant != null) {
            this.clearCache(oAuth2ScopeGrant);
        }
        return oAuth2ScopeGrant;
    }

    public OAuth2ScopeGrant updateImpl(OAuth2ScopeGrant oAuth2ScopeGrant) {
        boolean isNew = oAuth2ScopeGrant.isNew();
        if (!(oAuth2ScopeGrant instanceof OAuth2ScopeGrantModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(oAuth2ScopeGrant.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)oAuth2ScopeGrant);
                throw new IllegalArgumentException("Implement ModelWrapper in oAuth2ScopeGrant proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom OAuth2ScopeGrant implementation " + oAuth2ScopeGrant.getClass());
        }
        OAuth2ScopeGrantModelImpl oAuth2ScopeGrantModelImpl = (OAuth2ScopeGrantModelImpl)oAuth2ScopeGrant;
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)oAuth2ScopeGrant);
            } else {
                oAuth2ScopeGrant = (OAuth2ScopeGrant)session.merge((Object)oAuth2ScopeGrant);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(OAuth2ScopeGrantImpl.class, (BaseModel)oAuth2ScopeGrantModelImpl, false, true);
        this.cacheUniqueFindersCache(oAuth2ScopeGrantModelImpl);
        if (isNew) {
            oAuth2ScopeGrant.setNew(false);
        }
        oAuth2ScopeGrant.resetOriginalValues();
        return oAuth2ScopeGrant;
    }

    public OAuth2ScopeGrant findByPrimaryKey(Serializable primaryKey) throws NoSuchOAuth2ScopeGrantException {
        OAuth2ScopeGrant oAuth2ScopeGrant = (OAuth2ScopeGrant)this.fetchByPrimaryKey(primaryKey);
        if (oAuth2ScopeGrant == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchOAuth2ScopeGrantException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return oAuth2ScopeGrant;
    }

    public OAuth2ScopeGrant findByPrimaryKey(long oAuth2ScopeGrantId) throws NoSuchOAuth2ScopeGrantException {
        return this.findByPrimaryKey(Long.valueOf(oAuth2ScopeGrantId));
    }

    public OAuth2ScopeGrant fetchByPrimaryKey(long oAuth2ScopeGrantId) {
        return (OAuth2ScopeGrant)this.fetchByPrimaryKey(Long.valueOf(oAuth2ScopeGrantId));
    }

    public List<OAuth2ScopeGrant> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<OAuth2ScopeGrant> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<OAuth2ScopeGrant> findAll(int start, int end, OrderByComparator<OAuth2ScopeGrant> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<OAuth2ScopeGrant> findAll(int start, int end, OrderByComparator<OAuth2ScopeGrant> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_OAUTH2SCOPEGRANT);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_OAUTH2SCOPEGRANT;
                sql = sql.concat(" ORDER BY oAuth2ScopeGrant.oAuth2ScopeGrantId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (OAuth2ScopeGrant oAuth2ScopeGrant : this.findAll()) {
            this.remove((BaseModel)oAuth2ScopeGrant);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_OAUTH2SCOPEGRANT);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public long[] getOAuth2AuthorizationPrimaryKeys(long pk) {
        long[] pks = this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.getRightPrimaryKeys(pk);
        return (long[])pks.clone();
    }

    public List<OAuth2ScopeGrant> getOAuth2AuthorizationOAuth2ScopeGrants(long pk) {
        return this.getOAuth2AuthorizationOAuth2ScopeGrants(pk, -1, -1);
    }

    public List<OAuth2ScopeGrant> getOAuth2AuthorizationOAuth2ScopeGrants(long pk, int start, int end) {
        return this.getOAuth2AuthorizationOAuth2ScopeGrants(pk, start, end, null);
    }

    public List<OAuth2ScopeGrant> getOAuth2AuthorizationOAuth2ScopeGrants(long pk, int start, int end, OrderByComparator<OAuth2ScopeGrant> orderByComparator) {
        return this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.getLeftBaseModels(pk, start, end, orderByComparator);
    }

    public int getOAuth2AuthorizationsSize(long pk) {
        long[] pks = this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.getRightPrimaryKeys(pk);
        return pks.length;
    }

    public boolean containsOAuth2Authorization(long pk, long oAuth2AuthorizationPK) {
        return this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.containsTableMapping(pk, oAuth2AuthorizationPK);
    }

    public boolean containsOAuth2Authorizations(long pk) {
        return this.getOAuth2AuthorizationsSize(pk) > 0;
    }

    public void addOAuth2Authorization(long pk, long oAuth2AuthorizationPK) {
        OAuth2ScopeGrant oAuth2ScopeGrant = this.fetchByPrimaryKey(pk);
        if (oAuth2ScopeGrant == null) {
            this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.addTableMapping(CompanyThreadLocal.getCompanyId().longValue(), pk, oAuth2AuthorizationPK);
        } else {
            this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.addTableMapping(oAuth2ScopeGrant.getCompanyId(), pk, oAuth2AuthorizationPK);
        }
    }

    public void addOAuth2Authorization(long pk, OAuth2Authorization oAuth2Authorization) {
        OAuth2ScopeGrant oAuth2ScopeGrant = this.fetchByPrimaryKey(pk);
        if (oAuth2ScopeGrant == null) {
            this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.addTableMapping(CompanyThreadLocal.getCompanyId().longValue(), pk, oAuth2Authorization.getPrimaryKey());
        } else {
            this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.addTableMapping(oAuth2ScopeGrant.getCompanyId(), pk, oAuth2Authorization.getPrimaryKey());
        }
    }

    public void addOAuth2Authorizations(long pk, long[] oAuth2AuthorizationPKs) {
        long companyId = 0L;
        OAuth2ScopeGrant oAuth2ScopeGrant = this.fetchByPrimaryKey(pk);
        companyId = oAuth2ScopeGrant == null ? CompanyThreadLocal.getCompanyId().longValue() : oAuth2ScopeGrant.getCompanyId();
        this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.addTableMappings(companyId, pk, oAuth2AuthorizationPKs);
    }

    public void addOAuth2Authorizations(long pk, List<OAuth2Authorization> oAuth2Authorizations) {
        this.addOAuth2Authorizations(pk, ListUtil.toLongArray(oAuth2Authorizations, (Accessor)OAuth2Authorization.O_AUTH2_AUTHORIZATION_ID_ACCESSOR));
    }

    public void clearOAuth2Authorizations(long pk) {
        this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.deleteLeftPrimaryKeyTableMappings(pk);
    }

    public void removeOAuth2Authorization(long pk, long oAuth2AuthorizationPK) {
        this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.deleteTableMapping(pk, oAuth2AuthorizationPK);
    }

    public void removeOAuth2Authorization(long pk, OAuth2Authorization oAuth2Authorization) {
        this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.deleteTableMapping(pk, oAuth2Authorization.getPrimaryKey());
    }

    public void removeOAuth2Authorizations(long pk, long[] oAuth2AuthorizationPKs) {
        this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.deleteTableMappings(pk, oAuth2AuthorizationPKs);
    }

    public void removeOAuth2Authorizations(long pk, List<OAuth2Authorization> oAuth2Authorizations) {
        this.removeOAuth2Authorizations(pk, ListUtil.toLongArray(oAuth2Authorizations, (Accessor)OAuth2Authorization.O_AUTH2_AUTHORIZATION_ID_ACCESSOR));
    }

    public void setOAuth2Authorizations(long pk, long[] oAuth2AuthorizationPKs) {
        Set newOAuth2AuthorizationPKsSet = SetUtil.fromArray((long[])oAuth2AuthorizationPKs);
        Set oldOAuth2AuthorizationPKsSet = SetUtil.fromArray((long[])this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.getRightPrimaryKeys(pk));
        HashSet removeOAuth2AuthorizationPKsSet = new HashSet(oldOAuth2AuthorizationPKsSet);
        removeOAuth2AuthorizationPKsSet.removeAll(newOAuth2AuthorizationPKsSet);
        this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.deleteTableMappings(pk, ArrayUtil.toLongArray(removeOAuth2AuthorizationPKsSet));
        newOAuth2AuthorizationPKsSet.removeAll(oldOAuth2AuthorizationPKsSet);
        long companyId = 0L;
        OAuth2ScopeGrant oAuth2ScopeGrant = this.fetchByPrimaryKey(pk);
        companyId = oAuth2ScopeGrant == null ? CompanyThreadLocal.getCompanyId().longValue() : oAuth2ScopeGrant.getCompanyId();
        this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper.addTableMappings(companyId, pk, ArrayUtil.toLongArray((Collection)newOAuth2AuthorizationPKsSet));
    }

    public void setOAuth2Authorizations(long pk, List<OAuth2Authorization> oAuth2Authorizations) {
        try {
            long[] oAuth2AuthorizationPKs = new long[oAuth2Authorizations.size()];
            for (int i = 0; i < oAuth2Authorizations.size(); ++i) {
                OAuth2Authorization oAuth2Authorization = oAuth2Authorizations.get(i);
                oAuth2AuthorizationPKs[i] = oAuth2Authorization.getPrimaryKey();
            }
            this.setOAuth2Authorizations(pk, oAuth2AuthorizationPKs);
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "oAuth2ScopeGrantId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_OAUTH2SCOPEGRANT;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return OAuth2ScopeGrantModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new OAuth2ScopeGrantModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this.oAuth2ScopeGrantToOAuth2AuthorizationTableMapper = TableMapperFactory.getTableMapper((String)"OA2Auths_OA2ScopeGrants#oAuth2ScopeGrantId", (String)"OA2Auths_OA2ScopeGrants", (String)"companyId", (String)"oAuth2ScopeGrantId", (String)"oAuth2AuthorizationId", (BasePersistence)this, OAuth2Authorization.class);
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByOAuth2ApplicationScopeAliasesId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByOAuth2ApplicationScopeAliasesId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"oA2AScopeAliasesId"}, true);
        this._finderPathWithoutPaginationFindByOAuth2ApplicationScopeAliasesId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByOAuth2ApplicationScopeAliasesId", new String[]{Long.class.getName()}, new String[]{"oA2AScopeAliasesId"}, true);
        this._finderPathCountByOAuth2ApplicationScopeAliasesId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByOAuth2ApplicationScopeAliasesId", new String[]{Long.class.getName()}, new String[]{"oA2AScopeAliasesId"}, false);
        this._finderPathFetchByC_O_A_B_S = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_O_A_B_S", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()}, new String[]{"companyId", "oA2AScopeAliasesId", "applicationName", "bundleSymbolicName", "scope"}, true);
        this._finderPathCountByC_O_A_B_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_O_A_B_S", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()}, new String[]{"companyId", "oA2AScopeAliasesId", "applicationName", "bundleSymbolicName", "scope"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(OAuth2ScopeGrantImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        TableMapperFactory.removeTableMapper((String)"OA2Auths_OA2ScopeGrants#oAuth2ScopeGrantId");
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.oauth2.provider.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.oauth2.provider.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.oauth2.provider.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    private static class OAuth2ScopeGrantModelArgumentsResolver
    implements ArgumentsResolver {
        private static Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private OAuth2ScopeGrantModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            OAuth2ScopeGrantModelImpl oAuth2ScopeGrantModelImpl = (OAuth2ScopeGrantModelImpl)baseModel;
            long columnBitmask = oAuth2ScopeGrantModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return this._getValue(oAuth2ScopeGrantModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | OAuth2ScopeGrantModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return this._getValue(oAuth2ScopeGrantModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return OAuth2ScopeGrantImpl.class.getName();
        }

        public String getTableName() {
            return OAuth2ScopeGrantTable.INSTANCE.getTableName();
        }

        private Object[] _getValue(OAuth2ScopeGrantModelImpl oAuth2ScopeGrantModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? oAuth2ScopeGrantModelImpl.getColumnOriginalValue(columnName) : oAuth2ScopeGrantModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

