/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.web.internal.display.context;

import com.liferay.oauth2.provider.configuration.OAuth2ProviderConfiguration;
import com.liferay.oauth2.provider.constants.ClientProfile;
import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2ApplicationScopeAliases;
import com.liferay.oauth2.provider.service.OAuth2ApplicationScopeAliasesLocalServiceUtil;
import com.liferay.oauth2.provider.service.OAuth2ApplicationService;
import com.liferay.oauth2.provider.service.OAuth2AuthorizationServiceUtil;
import com.liferay.oauth2.provider.web.internal.display.context.BaseOAuth2PortletDisplayContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;

public class OAuth2AdminPortletDisplayContext
extends BaseOAuth2PortletDisplayContext {
    private static final Pattern _baseIdPattern = Pattern.compile("(.{8})(.{4})(.{4})(.{4})(.*)");
    private final OAuth2ProviderConfiguration _oAuth2ProviderConfiguration;

    public static String generateRandomId() {
        String randomSecret = OAuth2AdminPortletDisplayContext.generateRandomSecret();
        return StringUtil.replace((String)randomSecret, (String)"secret-", (String)"id-");
    }

    public static String generateRandomSecret() {
        int size = 16;
        int count = (int)Math.ceil((double)size / 8.0);
        byte[] buffer = new byte[count * 8];
        for (int i = 0; i < count; ++i) {
            BigEndianCodec.putLong((byte[])buffer, (int)(i * 8), (long)SecureRandomUtil.nextLong());
        }
        StringBundler sb = new StringBundler(size);
        for (int i = 0; i < size; ++i) {
            sb.append(Integer.toHexString(0xFF & buffer[i]));
        }
        Matcher matcher = _baseIdPattern.matcher(sb.toString());
        return matcher.replaceFirst("secret-$1-$2-$3-$4-$5");
    }

    public OAuth2AdminPortletDisplayContext(OAuth2ApplicationService oAuth2ApplicationService, OAuth2ProviderConfiguration oAuth2ProviderConfiguration, PortletRequest portletRequest, ThemeDisplay themeDisplay) {
        this._oAuth2ProviderConfiguration = oAuth2ProviderConfiguration;
        this.oAuth2ApplicationService = oAuth2ApplicationService;
        this.portletRequest = portletRequest;
        this.themeDisplay = themeDisplay;
    }

    public List<GrantType> getGrantTypes(PortletPreferences portletPreferences) {
        String[] oAuth2Grants = StringUtil.split((String)portletPreferences.getValue("oAuth2Grants", ""));
        ArrayList<GrantType> grantTypes = new ArrayList<GrantType>();
        for (String oAuth2Grant : oAuth2Grants) {
            grantTypes.add(GrantType.valueOf((String)oAuth2Grant));
        }
        if (grantTypes.isEmpty()) {
            Collections.addAll(grantTypes, GrantType.values());
        }
        if (!this._oAuth2ProviderConfiguration.allowAuthorizationCodeGrant()) {
            grantTypes.remove(GrantType.AUTHORIZATION_CODE);
        }
        if (!this._oAuth2ProviderConfiguration.allowAuthorizationCodePKCEGrant()) {
            grantTypes.remove(GrantType.AUTHORIZATION_CODE_PKCE);
        }
        if (!this._oAuth2ProviderConfiguration.allowClientCredentialsGrant()) {
            grantTypes.remove(GrantType.CLIENT_CREDENTIALS);
        }
        if (!this._oAuth2ProviderConfiguration.allowRefreshTokenGrant()) {
            grantTypes.remove(GrantType.REFRESH_TOKEN);
        }
        if (!this._oAuth2ProviderConfiguration.allowResourceOwnerPasswordCredentialsGrant()) {
            grantTypes.remove(GrantType.RESOURCE_OWNER_PASSWORD);
        }
        return grantTypes;
    }

    public int getOAuth2AuthorizationsCount(OAuth2Application oAuth2Application) throws PortalException {
        return OAuth2AuthorizationServiceUtil.getApplicationOAuth2AuthorizationsCount((long)oAuth2Application.getOAuth2ApplicationId());
    }

    public String[] getOAuth2Features(PortletPreferences portletPreferences) {
        return StringUtil.split((String)portletPreferences.getValue("oAuth2Features", ""));
    }

    public int getScopeAliasesSize(OAuth2Application oAuth2Application) throws PortalException {
        long oAuth2ApplicationScopeAliasesId = oAuth2Application.getOAuth2ApplicationScopeAliasesId();
        if (oAuth2ApplicationScopeAliasesId <= 0L) {
            return 0;
        }
        OAuth2ApplicationScopeAliases oAuth2ApplicationScopeAliases = OAuth2ApplicationScopeAliasesLocalServiceUtil.getOAuth2ApplicationScopeAliases((long)oAuth2ApplicationScopeAliasesId);
        List scopeAliasesList = oAuth2ApplicationScopeAliases.getScopeAliasesList();
        return scopeAliasesList.size();
    }

    public ClientProfile[] getSortedClientProfiles() {
        ClientProfile[] clientProfiles = ClientProfile.values();
        Arrays.sort(clientProfiles, Comparator.comparingInt(ClientProfile::id));
        return clientProfiles;
    }
}

