/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.admin.rest.dto.v1_0.util;

import com.liferay.object.admin.rest.dto.v1_0.ObjectAction;
import com.liferay.object.admin.rest.dto.v1_0.Status;
import com.liferay.object.constants.ObjectActionConstants;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.util.LocalizedMapUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class ObjectActionUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectActionUtil.class);

    public static ObjectAction toObjectAction(Map<String, Map<String, String>> actions, final Locale locale, final ObjectDefinitionLocalService objectDefinitionLocalService, final com.liferay.object.model.ObjectAction serviceBuilderObjectAction) {
        if (serviceBuilderObjectAction == null) {
            return null;
        }
        ObjectAction objectAction = new ObjectAction(){
            {
                this.active = serviceBuilderObjectAction.isActive();
                this.conditionExpression = serviceBuilderObjectAction.getConditionExpression();
                this.dateCreated = serviceBuilderObjectAction.getCreateDate();
                this.dateModified = serviceBuilderObjectAction.getModifiedDate();
                this.description = serviceBuilderObjectAction.getDescription();
                this.errorMessage = LocalizedMapUtil.getLanguageIdMap((Map)serviceBuilderObjectAction.getErrorMessageMap());
                this.id = serviceBuilderObjectAction.getObjectActionId();
                this.label = LocalizedMapUtil.getLanguageIdMap((Map)serviceBuilderObjectAction.getLabelMap());
                this.name = serviceBuilderObjectAction.getName();
                this.objectActionExecutorKey = serviceBuilderObjectAction.getObjectActionExecutorKey();
                this.objectActionTriggerKey = serviceBuilderObjectAction.getObjectActionTriggerKey();
                this.parameters = ObjectActionUtil.toParameters(objectDefinitionLocalService, serviceBuilderObjectAction.getParametersUnicodeProperties());
                this.status = new Status(){
                    {
                        this.code = serviceBuilderObjectAction.getStatus();
                        this.label = ObjectActionConstants.getStatusLabel((int)serviceBuilderObjectAction.getStatus());
                        this.label_i18n = LanguageUtil.get((Locale)locale, (String)ObjectActionConstants.getStatusLabel((int)serviceBuilderObjectAction.getStatus()));
                    }
                };
            }
        };
        objectAction.setActions(actions);
        return objectAction;
    }

    public static Map<String, Object> toParameters(ObjectDefinitionLocalService objectDefinitionLocalService, UnicodeProperties parametersUnicodeProperties) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (Map.Entry entry : parametersUnicodeProperties.entrySet()) {
            Object value = entry.getValue();
            if (Objects.equals(entry.getKey(), "notificationTemplateId")) {
                value = GetterUtil.getLong(value);
            } else if (Objects.equals(entry.getKey(), "objectDefinitionId")) {
                try {
                    ObjectDefinition objectDefinition = objectDefinitionLocalService.getObjectDefinition(GetterUtil.getLong(value));
                    parameters.put("objectDefinitionExternalReferenceCode", objectDefinition.getExternalReferenceCode());
                }
                catch (PortalException portalException) {
                    _log.error((Throwable)portalException);
                }
                value = GetterUtil.getLong(value);
            } else if (Objects.equals(entry.getKey(), "predefinedValues")) {
                value = JSONFactoryUtil.looseDeserialize((String)((String)value));
            } else if (Objects.equals(entry.getKey(), "relatedObjectEntries")) {
                value = GetterUtil.getBoolean(value);
            }
            parameters.put((String)entry.getKey(), value);
        }
        return parameters;
    }

    public static UnicodeProperties toParametersUnicodeProperties(Map<String, ?> parameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : parameters.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof ArrayList) {
                value = JSONFactoryUtil.looseSerialize(value);
            }
            map.put(entry.getKey(), value.toString());
        }
        return UnicodePropertiesBuilder.create(map, (boolean)true).build();
    }
}

